﻿<?xml version="1.0" encoding="utf-8"?>
<pattern id="Content" xmlns="http://purl.oclc.org/dsdl/schematron">
    <title>Content Validations</title>

    <rule context="xbrli:xbrl[not(@i:nil='true')]">
        <!-- Rule ID: VR.SS.GEN.000014
    
        WHERE IN TUPLE(email1.02.00:ElectronicContactElectronicMail)
        IF (ElectronicContact.ElectronicMail.Usage.Code <>"03")
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000014" diagnostics="DVR.SS.GEN.000014"
            test="not(
                key('contextDetailsById', $SENDER.ContextId)[self::email1.02.00:ElectronicContactElectronicMail]/pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code[not(matches(.,'^03$','i'))]
            )"/>

        <!-- Rule ID: VR.SS.GEN.000018
    
        WHERE IN TUPLE(phone1.xx.xx:ElectronicContactTelephone)
        IF (pyde.xx.xx:ElectronicContact.Telephone.Usage.Code <> NULL AND pyde.xx.xx:ElectronicContact.Telephone.Usage.Code "03")
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.GEN.000018" diagnostics="DVR.SS.GEN.000018"
            test="not(
                key('contextDetailsById', $SENDER.ContextId)[self::phone1.02.00:ElectronicContactTelephone]/pyde.02.00:ElectronicContact.Telephone.Usage.Code[not(@i:nil='true') and not(matches(.,'^03$','i'))]
            )"/>

        <!-- Rule ID: VR.SS.GEN.000021
    
        WHERE IN TUPLE(phone1.xx.xx:ElectronicContactTelephone)
        IF (pyde.xx.xx:ElectronicContact.Telephone.ServiceLine.Code <> NULL AND pyde.xx.xx:ElectronicContact.Telephone.ServiceLine.Code <> SET("01", "02"))
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.GEN.000021" diagnostics="DVR.SS.GEN.000021"
            test="not(
                key('contextDetailsById', $SENDER.ContextId)[self::phone1.02.00:ElectronicContactTelephone]/pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code[not(@i:nil='true') and not(matches(.,'^(01|02)$','i'))]
            )"/>

        <!-- Rule ID: VR.SS.GEN.000038
    
        IF COUNT(RP.SENDER:orgname1.02.00:OrganisationNameDetails) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000038" diagnostics="DVR.SS.RIR.000038"
            test="not(
                count(key('contextDetailsById', $SENDER.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1
            )"/>

        <!-- Rule ID: VR.SS.GEN.000040
    
        IF COUNT(RP.SENDER:prsnstrcnm1.02.00:PersonNameDetails) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000040" diagnostics="DVR.SS.RIR.000040"
            test="not(
                count(key('contextDetailsById', $SENDER.ContextId)[self::prsnstrcnm1.02.00:PersonNameDetails]) &gt; 1
            )"/>

        <!-- Rule ID: VR.SS.GEN.000042
    
        IF COUNT(RP.SENDER:email1.02.00:ElectronicContactElectronicMail) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000042" diagnostics="DVR.SS.RIR.000042"
            test="not(
                count(key('contextDetailsById', $SENDER.ContextId)[self::email1.02.00:ElectronicContactElectronicMail]) &gt; 1
            )"/>

        <!-- Rule ID: VR.SS.GEN.000044
    
        IF COUNT(RP.SENDER:phone1.02.00:ElectronicContactTelephone) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000044" diagnostics="DVR.SS.RIR.000044"
            test="not(
                count(key('contextDetailsById', $SENDER.ContextId)[self::phone1.02.00:ElectronicContactTelephone]) &gt; 1
            )"/>

        <!-- Rule ID: VR.SS.GEN.000046
    
        IF COUNT(RP.RECEIVER:orgname1.02.00:OrganisationNameDetails) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000046" diagnostics="DVR.SS.RIR.000046"
            test="not(
                count(key('contextDetailsById', $RECEIVER.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1
            )"/>
    </rule>

    <rule context="address3.02.01:AddressDetails[not(@i:nil='true')]">
        <let name="tupleContextId" value="*[1]/@contextRef" />

        <!-- Rule ID: VR.SS.GEN.000027
    
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.Usage.Code NOT IN SET ("POS","RES"))
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000027" diagnostics="DVR.SS.GEN.000027"
            test="not(
                pyde.02.01:AddressDetails.Usage.Code[not(matches(.,'^(POS|RES)$','i'))]
            )"/>

        <!-- Rule ID: VR.SS.GEN.000030
    
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.Country.Code = "au") AND (AddressDetails.Postcode.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000030" diagnostics="DVR.SS.GEN.000030"
            test="not(
                pyde.02.08:AddressDetails.Country.Code[. = 'au']
                and
                not(pyde.02.00:AddressDetails.Postcode.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>

        <!-- Rule ID: VR.SS.GEN.000031
    
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.Country.Code = "au") AND (AddressDetails.StateOrTerritory.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000031" diagnostics="DVR.SS.GEN.000031"
            test="not(
                pyde.02.08:AddressDetails.Country.Code[. = 'au']
                and
                not(pyde.02.00:AddressDetails.StateOrTerritory.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>

        <!-- Rule ID: VR.SS.GEN.000038
    
        WHERE IN TUPLE  (address3.02.01:AddressDetails)
        IF LENGTH(pyde.02.00:AddressDetails.LocalityName.Text) > 50
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000038" diagnostics="DVR.SS.GEN.000038"
            test="not(
                pyde.02.00:AddressDetails.LocalityName.Text[string-length(.) > 50]
            )"/>
    </rule>

    <rule context="orgname1.02.00:OrganisationNameDetails[not(@i:nil='true')]">
        <let name="tupleContextId" value="*[1]/@contextRef" />

        <!-- Rule ID: VR.SS.GEN.000007
    
        WHERE IN TUPLE(organisationname1.xx.xx:OrganisationNameDetails)
        IF (pyde.xx.xx:OrganisationNameDetails.OrganisationalNameType.Code <> NULL AND pyde.xx.xx:OrganisationNameDetails.OrganisationalNameType.Code <> "MN")
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000007" diagnostics="DVR.SS.GEN.000007"
            test="not(
                pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code[not(@i:nil='true') and not(. = 'MN')]
            )"/>
    </rule>

    <rule context="xbrli:xbrl[not(@i:nil='true')]/xbrli:context[exists($MEMROLTRANS.Context[generate-id() = generate-id(current())])]">
        <let name="thisContextId" value="@id" />

        <!-- Rule ID: VR.SS.RIR.000034
  
        FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
        IF (emsup.02.08:SuperannuationRollover.TransferWholeBalance.Indicator = "false") AND (emsup.02.08:SuperannuationRollover.Requested.Amount = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
		    -->
        <assert id="VR.SS.RIR.000034" diagnostics="DVR.SS.RIR.000034"
            test="not(
                key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.TransferWholeBalance.Indicator[matches(.,'^(false|0)$')]]
                and
                not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.Requested.Amount[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
            )" />

        <!-- Rule ID: VR.SS.GEN.000048
    
        FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
        IF COUNT(prsnstrcnm1.02.00:PersonNameDetails) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000048" diagnostics="DVR.SS.RIR.000048"
            test="not(
                count(key('contextDetailsById', $thisContextId)[self::prsnstrcnm1.02.00:PersonNameDetails]) &gt; 1
            )"/>

        <!-- Rule ID: VR.SS.GEN.000050
    
        FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
        IF COUNT(address3.02.01:AddressDetails) > 1
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000050" diagnostics="DVR.SS.RIR.000050"
            test="not(
				        count(key('contextDetailsById', $thisContextId)[self::address3.02.01:AddressDetails]) &gt; 1
			      )"/>

        <!-- Rule ID: VR.SS.RIR.000052
  
        FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
        IF (pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator = FALSE and RP.MEMBERROLLOVERTRANSACTION Identifier Scheme = "http://www.sbr.gov.au/id")
			  RETURN VALIDATION MESSAGE
        END IF
		    -->
        <assert id="VR.SS.RIR.000052" diagnostics="DVR.SS.RIR.000052"
            test="not(
				        key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[matches(.,'^(false|0)$')]]
				        and
				        xbrli:entity/xbrli:identifier
				        [                            
					          matches(@scheme,'^http://www.sbr.gov.au/id$')
				        ]
			      )" />

        <!-- Rule ID: VR.SS.RIR.000053
  
        FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
        IF (Identifier Scheme = "http://www.ato.gov.au/tfn" and pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator = TRUE)
           RETURN VALIDATION MESSAGE
        END IF
		-->
        <assert id="VR.SS.RIR.000053" diagnostics="DVR.SS.RIR.000053"
            test="not(
				        key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[matches(.,'^(true|1)$')]]
				        and
				        xbrli:entity/xbrli:identifier
				        [                            
					          matches(@scheme,'^http://www.ato.gov.au/tfn$')
				        ]
			      )" />

        <!-- Rule ID: VR.SS.RIR.000100
    
        IF LENGTH(emsup.02.03:SuperannuationFundDetails.MemberClient.Identifier) > 20
          RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000100" diagnostics="DVR.SS.RIR.000100"
            test="not(
                key('contextDetailsById', $thisContextId)[self::emsup.02.03:SuperannuationFundDetails.MemberClient.Identifier[string-length(.) > 20]]
            )"/>

        <!-- Rule ID: VR.SS.RIR.000111
    
        WHERE IN CONTEXT SET(SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN},
        SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI},
        SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{RecFundUSI},
        SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}.{RecFundUSI}) 
        IF COUNT(financialinstitutionaccount1.xx.xx:FinancialInstitutionAccount) > 1
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.RIR.000111" diagnostics="DVR.SS.RIR.000111"
            test="not(
                count(key('contextDetailsById', $thisContextId)[self::financialinstitutionaccount1.02.00:FinancialInstitutionAccount]) &gt; 1
            )"/>

        <!-- Rule ID: VR.SS.RIR.000112
    
        WHERE IN CONTEXT SET(SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN},
        SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI},
        SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{RecFundUSI},
        SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}.{RecFundUSI}) 
        IF (emsup.xx.xx:ReleaseAuthority.ProductType.Code <> NULL)
          RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.RIR.000112" diagnostics="DVR.SS.RIR.000112"
            test="not(
                count(key('contextDetailsById', $thisContextId)[self::emsup.02.39:SuperannuationRollover.ReleaseAuthorityProductType.Code])
            )"/>
    </rule>
</pattern>