﻿<?xml version="1.0" encoding="utf-8"?>
<pattern id="Mandatories" xmlns="http://purl.oclc.org/dsdl/schematron">
    <title>Mandatory Validations</title>

    <rule context="xbrli:xbrl[not(@i:nil='true')]">
        <!-- Rule ID: VR.SS.GEN.000037
        
        IF COUNT(MessageSender) = 1 AND [SPRROL1] = NULL
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000037" diagnostics="DVR.SS.RIR.000037"
            test="not(
                count($SENDER.ContextId) = 1
                and
                not(key('contextDetailsById', $SENDER.ContextId)[self::orgname1.02.00:OrganisationNameDetails[not(@i:nil='true')]])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000039
        
        IF COUNT(MessageSender) = 1 AND [SPRROL3] = NULL
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.RIR.000039" diagnostics="DVR.SS.RIR.000039"
            test="not(
                count($SENDER.ContextId) = 1
                and
                not(key('contextDetailsById', $SENDER.ContextId)[self::prsnstrcnm1.02.00:PersonNameDetails[not(@i:nil='true')]])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000041
        
        IF COUNT(MessageSender) = 1 AND [SPRROL7] = NULL
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.RIR.000041" diagnostics="DVR.SS.RIR.000041"
            test="not(
                count($SENDER.ContextId) = 1
                and
                not(key('contextDetailsById', $SENDER.ContextId)[self::email1.02.00:ElectronicContactElectronicMail[not(@i:nil='true')]])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000043
        
        IF COUNT(MessageSender) = 1 AND [SPRROL9] = NULL
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.RIR.000043" diagnostics="DVR.SS.RIR.000043"
            test="not(
                count($SENDER.ContextId) = 1
                and
                not(key('contextDetailsById', $SENDER.ContextId)[self::phone1.02.00:ElectronicContactTelephone[not(@i:nil='true')]])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000045
        
        IF COUNT(MessageReciver) = 1 AND [SPRROL13] = NULL
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.RIR.000045" diagnostics="DVR.SS.RIR.000045"
            test="not(
                count($RECEIVER.ContextId) = 1
                and
                not(key('contextDetailsById', $RECEIVER.ContextId)[self::orgname1.02.00:OrganisationNameDetails[not(@i:nil='true')]])
            )"/>
    </rule>

    <rule context="address3.02.01:AddressDetails[not(@i:nil='true')]">
        <let name="tupleContextId" value="*[1]/@contextRef" />
        
        <!-- Rule ID: VR.SS.GEN.000026
        
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.Usage.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000026" diagnostics="DVR.SS.GEN.000026"
            test="not(
                not(pyde.02.01:AddressDetails.Usage.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000028
        
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.Line1.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000028" diagnostics="DVR.SS.GEN.000028"
            test="not(
                not(pyde.02.00:AddressDetails.Line1.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000029
        
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.LocalityName.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000029" diagnostics="DVR.SS.GEN.000029"
            test="not(
                not(pyde.02.00:AddressDetails.LocalityName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000032
        
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.Country.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000032" diagnostics="DVR.SS.GEN.000032"
            test="not(
                not(pyde.02.08:AddressDetails.Country.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
    </rule>

    <rule context="financialinstitutionaccount1.02.00:FinancialInstitutionAccount[not(@i:nil='true')]">
        <let name="tupleContextId" value="*[1]/@contextRef" />
        
        <!-- Rule ID: VR.SS.RIR.000108
            
        WHERE IN TUPLE(financialinstitutionaccount1.xx.xx:FinancialInstitutionAccount)
        IF (pyid.xx.xx:FinancialInstitutionAccount.BankStateBranch.Number = NULL)
              RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.RIR.000108" diagnostics="DVR.SS.RIR.000108"
            test="not(
                not(pyid.02.00:FinancialInstitutionAccount.BankStateBranch.Number[not(@i:nil='true')])
            )"/>

        <!-- Rule ID: VR.SS.RIR.000109
            
        WHERE IN TUPLE(financialinstitutionaccount1.xx.xx:FinancialInstitutionAccount)
        IF (pyid.xx.xx:FinancialInstitutionAccount.FinancialInstitutionAccount.Number = NULL)
              RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.RIR.000109" diagnostics="DVR.SS.RIR.000109"
            test="not(
                not(pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccount.Number[not(@i:nil='true')])
            )"/>

        <!-- Rule ID: VR.SS.RIR.000110
            
        WHERE IN TUPLE(financialinstitutionaccount1.xx.xx:FinancialInstitutionAccount)
        IF (pyid.xx.xx:FinancialInstitutionAccount.FinancialInstitutionAccountName.Text = NULLORBLANK)
              RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.RIR.000110" diagnostics="DVR.SS.RIR.000110"
            test="not(
                not(pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccountName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
    </rule>

    <rule context="orgname1.02.00:OrganisationNameDetails[not(@i:nil='true')]">
        <let name="tupleContextId" value="*[1]/@contextRef" />
        
        <!-- Rule ID: VR.SS.GEN.000006
        
        WHERE IN TUPLE(orgname1.02.00:OrganisationNameDetails)
        IF (OrganisationNameDetails.OrganisationalNameType.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.GEN.000006" diagnostics="DVR.SS.GEN.000006"
            test="not(
                not(pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000008
        
        WHERE IN TUPLE(orgname1.02.00:OrganisationNameDetails)
        IF (OrganisationNameDetails.OrganisationalName.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.GEN.000008" diagnostics="DVR.SS.GEN.000008"
            test="not(
                not(pyde.02.00:OrganisationNameDetails.OrganisationalName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
    </rule>

    <rule context="prsnstrcnm1.02.00:PersonNameDetails[not(@i:nil='true')]">
        <let name="tupleContextId" value="*[1]/@contextRef" />
        
        <!-- Rule ID: VR.SS.RIR.000106
        
        WHERE IN TUPLE([SPRROL3])
        IF [SPRROL202] = NULLORBLANK
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.RIR.000106" diagnostics="DVR.SS.RIR.000106"
            test="not(
                $tupleContextId = $SENDER.ContextId
                and
                not(pyde.02.00:PersonNameDetails.FamilyName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>

      <!-- Rule ID: VR.SS.GEN.000010
        
        WHERE IN TUPLE(prsnstrcnm1.02.00:PersonNameDetails)
        IF (PersonNameDetails.FamilyName.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
      <assert id="VR.SS.GEN.000010" diagnostics="DVR.SS.GEN.000010"
          test="not(
                $tupleContextId = $MEMROLTRANS.ContextId
                and
                not(pyde.02.00:PersonNameDetails.FamilyName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>

        <!-- Rule ID: VR.SS.RIR.000107
        
        WHERE IN TUPLE(prsnstrcnm1.02.00:PersonNameDetails)
        IF (PersonNameDetails.GivenName.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000107" diagnostics="DVR.SS.RIR.000107"
            test="not(
                  $tupleContextId = $SENDER.ContextId
                  and
                  not(pyde.02.00:PersonNameDetails.GivenName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
              )"/>
      
        <!-- Rule ID: VR.SS.GEN.000011
        
        WHERE IN TUPLE(prsnstrcnm1.02.00:PersonNameDetails)
        IF (PersonNameDetails.GivenName.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000011" diagnostics="DVR.SS.GEN.000011"
            test="not(
                $tupleContextId = $MEMROLTRANS.ContextId
                and
                not(pyde.02.00:PersonNameDetails.GivenName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
      
    </rule>

    <rule context="email1.02.00:ElectronicContactElectronicMail[not(@i:nil='true')]">
        <let name="tupleContextId" value="*[1]/@contextRef" />
        
        <!-- Rule ID: VR.SS.GEN.000013
        
        WHERE IN TUPLE(email1.02.00:ElectronicContactElectronicMail)
        IF (ElectronicContact.ElectronicMail.Usage.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000013" diagnostics="DVR.SS.GEN.000013"
            test="not(
                not(pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000015
        
        WHERE IN TUPLE(email1.02.00:ElectronicContactElectronicMail)
        IF (ElectronicContact.ElectronicMail.Address.Text = NULLORBLANK)
           RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000015" diagnostics="DVR.SS.GEN.000015"
            test="not(
                not(pyde.02.00:ElectronicContact.ElectronicMail.Address.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
    </rule>

    <rule context="phone1.02.00:ElectronicContactTelephone[not(@i:nil='true')]">
        <let name="tupleContextId" value="*[1]/@contextRef" />
        
        <!-- Rule ID: VR.SS.GEN.000017
        
        WHERE IN TUPLE(phone1.02.00:ElectronicContactTelephone)
        IF (ElectronicContact.Telephone.Usage.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000017" diagnostics="DVR.SS.GEN.000017"
            test="not(
                not(pyde.02.00:ElectronicContact.Telephone.Usage.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000019
        
        WHERE IN TUPLE(phone1.02.00:ElectronicContactTelephone)
        IF (ElectronicContact.Telephone.ServiceLine.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000019" diagnostics="DVR.SS.GEN.000019"
            test="not(
                not(pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000020
        
        WHERE IN TUPLE (phone1.02.00:ElectronicContactTelephone)
        IF (ElectronicContact.Telephone.Minimal.Number = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000020" diagnostics="DVR.SS.GEN.000020"
            test="not(
                not(pyde.02.00:ElectronicContact.Telephone.Minimal.Number[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
    </rule>

    <rule context="sprrol.0003.inititaterollover.req.02.00:SuperannuationRolloverOtherDetails[not(@i:nil='true')]">
        <let name="tupleContextId" value="*[1]/@contextRef" />
        
        <!-- Rule ID: VR.SS.RIR.000101
        
        IF (emsup.02.23:SuperannuationRollover.OtherDetails.Text IN TUPLE(SuperannuationRolloverOtherDetails)) = NULLORBLANK
           RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.RIR.000101" diagnostics="DVR.SS.RIR.000101"
            test="not(
                not(emsup.02.23:SuperannuationRollover.OtherDetails.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
        
        <!-- Rule ID: VR.SS.RIR.000102
        
        IF (emsup.02.23:SuperannuationRollover.OtherDetails.Description IN TUPLE(SuperannuationRolloverOtherDetails))= NULLORBLANK
           RETURN VALIDATION MESSAGE
        ENDIF
        -->
        <assert id="VR.SS.RIR.000102" diagnostics="DVR.SS.RIR.000102"
            test="not(
                not(emsup.02.23:SuperannuationRollover.OtherDetails.Description[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
            )"/>
    </rule>

    <rule context="xbrli:xbrl[not(@i:nil='true')]/xbrli:context[exists($MEMROLTRANS.Context[generate-id() = generate-id(current())])]">
        <let name="thisContextId" value="@id" />
        
        <!-- Rule ID: VR.SS.GEN.000023
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
        IF (PersonDemographicDetails.Sex.Code = NULLORBLANK)
           RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000023" diagnostics="DVR.SS.RIR.000023"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::pyde.02.18:PersonDemographicDetails.Sex.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000024
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
        IF (PersonDemographicDetails.Birth.Date = NULLORBLANK)
           RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000024" diagnostics="DVR.SS.RIR.000024"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::pyde.02.00:PersonDemographicDetails.Birth.Date[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000033
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
        IF (SuperannuationRollover.TransferWholeBalance.Indicator = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000033" diagnostics="DVR.SS.RIR.000033"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.TransferWholeBalance.Indicator[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000047
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
        IF COUNT(prsnstrcnm1.02.00:PersonNameDetails) = 0
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000047" diagnostics="DVR.SS.RIR.000047"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::prsnstrcnm1.02.00:PersonNameDetails])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000049
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
        IF COUNT(address3.02.01:AddressDetails) = 0
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000049" diagnostics="DVR.SS.RIR.000049"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::address3.02.01:AddressDetails])
            )"/>
        
        <!-- Rule ID: VR.SS.GEN.000051
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
        IF (pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.RIR.000051" diagnostics="DVR.SS.RIR.000051"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
            )"/>
    </rule>
</pattern>