<?xml version="1.0" encoding="UTF-8" standalone="yes"?><xsl:stylesheet xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:saxon="http://saxon.sf.net/" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:schold="http://www.ascc.net/xml/schematron" xmlns:iso="http://purl.oclc.org/dsdl/schematron" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:s="http://www.w3.org/2003/05/soap-envelope" xmlns:wsa="http://www.w3.org/2005/08/addressing" xmlns:i="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:function="http://ato.gov.au/SWSFunctions" xmlns:xbrli="http://www.xbrl.org/2003/instance" xmlns:xbrldi="http://xbrl.org/2006/xbrldi" xmlns:link="http://www.xbrl.org/2003/linkbase" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:ref="http://www.xbrl.org/2006/ref" xmlns:iso4217="http://www.xbrl.org/2003/iso4217" xmlns:xmime="http://www.w3.org/2005/05/xmlmime" xmlns:service="http://sbr.gov.au/comn/list.02.service" xmlns:sbdh="http://sbr.gov.au/comn/sbdm.02.data" xmlns:core="http://sbr.gov.au/comn/core.02.data" xmlns:tech="http://sbr.gov.au/fdtn/sbr.01.02.tech" xmlns:address3.02.01="http://sbr.gov.au/comnmdle/comnmdle.addressdetails3.02.01.module" xmlns:financialinstitutionaccount1.02.00="http://sbr.gov.au/comnmdle/comnmdle.financialinstitutionaccount1.02.00.module" xmlns:orgname1.02.00="http://sbr.gov.au/comnmdle/comnmdle.organisationname1.02.00.module" xmlns:prsnstrcnm1.02.00="http://sbr.gov.au/comnmdle/comnmdle.personstructuredname1.02.00.module" xmlns:email1.02.00="http://sbr.gov.au/comnmdle/comnmdle.electroniccontactelectronicmail1.02.00.module" xmlns:phone1.02.00="http://sbr.gov.au/comnmdle/comnmdle.electroniccontacttelephone1.02.00.module" xmlns:sprrol.0003.inititaterollover.req.02.00="http://sbr.gov.au/rprt/sprstrm/sprrol/sprrol.0003.inititaterollover.request.02.00.report" xmlns:pyde.02.00="http://sbr.gov.au/icls/py/pyde/pyde.02.00.data" xmlns:pyde.02.01="http://sbr.gov.au/icls/py/pyde/pyde.02.01.data" xmlns:pyde.02.08="http://sbr.gov.au/icls/py/pyde/pyde.02.08.data" xmlns:pyde.02.18="http://sbr.gov.au/icls/py/pyde/pyde.02.18.data" xmlns:pyid.02.00="http://sbr.gov.au/icls/py/pyid/pyid.02.00.data" xmlns:pyid.02.05="http://sbr.gov.au/icls/py/pyid/pyid.02.05.data" xmlns:emsup.02.03="http://sbr.gov.au/icls/em/emsup/emsup.02.03.data" xmlns:emsup.02.08="http://sbr.gov.au/icls/em/emsup/emsup.02.08.data" xmlns:emsup.02.23="http://sbr.gov.au/icls/em/emsup/emsup.02.23.data" xmlns:emsup.02.39="http://sbr.gov.au/icls/em/emsup/emsup.02.39.data" version="2.0"><!--
            Implementers: please note that overriding process-prolog or process-root is
            the preferred method for meta-stylesheets to use where possible.
        -->


<!--PHASES-->


<!--PROLOG-->
<xsl:import xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" href="SSRIR202006Validator_Functions.xsl"/><xsl:variable xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" name="document-uri"><xsl:value-of select="document-uri(/)"/></xsl:variable><xsl:variable name="Apostrophe">'</xsl:variable><xsl:output xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" method="xml" omit-xml-declaration="no" standalone="yes" indent="no"/><xsl:param xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" name="document-id"/><!--MODE: SCHEMATRON-FULL-PATH-2ATO-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" match="node() | @*" mode="schematron-get-full-path-2ato"><xsl:for-each select="ancestor-or-self::*"><xsl:if test="name(.) != 'documents' and name(.) != 'document'"><xsl:text>/</xsl:text><xsl:value-of select="name(.)"/><xsl:if test="preceding-sibling::*[name(.)=name(current())]"><xsl:text>[</xsl:text><xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/><xsl:text>]</xsl:text></xsl:if></xsl:if></xsl:for-each><xsl:if test="not(self::*)"><xsl:text/>/@<xsl:value-of select="name(.)"/></xsl:if></xsl:template>

<!--XSD TYPES FOR XSLT2-->


<!--KEYS AND FUNCTIONS-->
<xsl:key name="contextById" match="/xbrli:xbrl/xbrli:context" use="@id"/><xsl:key name="contextDetailsById" match="/xbrli:xbrl/*" use="@contextRef | */@contextRef"/>

<!--DEFAULT RULES-->


<!--MODE: SCHEMATRON-SELECT-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-select-full-path"><xsl:apply-templates select="." mode="schematron-get-full-path"/></xsl:template>

<!--MODE: SCHEMATRON-FULL-PATH-->
<!--This mode can be used to generate an ugly though full XPath for locators-->
<xsl:template match="*" mode="schematron-get-full-path"><xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/><xsl:text>/</xsl:text><xsl:choose><xsl:when test="namespace-uri()=''"><xsl:value-of select="name()"/></xsl:when><xsl:otherwise><xsl:text>*:</xsl:text><xsl:value-of select="local-name()"/><xsl:text>[namespace-uri()='</xsl:text><xsl:value-of select="namespace-uri()"/><xsl:text>']</xsl:text></xsl:otherwise></xsl:choose><xsl:variable name="preceding" select="count(preceding-sibling::*[local-name()=local-name(current())                                   and namespace-uri() = namespace-uri(current())])"/><xsl:text>[</xsl:text><xsl:value-of select="1+ $preceding"/><xsl:text>]</xsl:text></xsl:template><xsl:template match="@*" mode="schematron-get-full-path"><xsl:apply-templates select="parent::*" mode="schematron-get-full-path"/><xsl:text>/</xsl:text><xsl:choose><xsl:when test="namespace-uri()=''">
                            @<xsl:value-of select="name()"/></xsl:when><xsl:otherwise><xsl:text>@*[local-name()='</xsl:text><xsl:value-of select="local-name()"/><xsl:text>' and namespace-uri()='</xsl:text><xsl:value-of select="namespace-uri()"/><xsl:text>']</xsl:text></xsl:otherwise></xsl:choose></xsl:template>

<!--MODE: SCHEMATRON-FULL-PATH-2-->
<!--This mode can be used to generate prefixed XPath for humans-->
<xsl:template match="node() | @*" mode="schematron-get-full-path-2"><xsl:for-each select="ancestor-or-self::*"><xsl:text>/</xsl:text><xsl:value-of select="name(.)"/><xsl:if test="preceding-sibling::*[name(.)=name(current())]"><xsl:text>[</xsl:text><xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/><xsl:text>]</xsl:text></xsl:if></xsl:for-each><xsl:if test="not(self::*)"><xsl:text/>/@<xsl:value-of select="name(.)"/></xsl:if></xsl:template><!--MODE: SCHEMATRON-FULL-PATH-3-->
<!--
            This mode can be used to generate prefixed XPath for humans
            (Top-level element has index)
        -->
<xsl:template match="node() | @*" mode="schematron-get-full-path-3"><xsl:for-each select="ancestor-or-self::*"><xsl:text>/</xsl:text><xsl:value-of select="name(.)"/><xsl:if test="parent::*"><xsl:text>[</xsl:text><xsl:value-of select="count(preceding-sibling::*[name(.)=name(current())])+1"/><xsl:text>]</xsl:text></xsl:if></xsl:for-each><xsl:if test="not(self::*)"><xsl:text/>/@<xsl:value-of select="name(.)"/></xsl:if></xsl:template>

<!--MODE: GENERATE-ID-FROM-PATH -->
<xsl:template match="/" mode="generate-id-from-path"/><xsl:template match="text()" mode="generate-id-from-path"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:value-of select="concat('.text-', 1+count(preceding-sibling::text()), '-')"/></xsl:template><xsl:template match="comment()" mode="generate-id-from-path"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:value-of select="concat('.comment-', 1+count(preceding-sibling::comment()), '-')"/></xsl:template><xsl:template match="processing-instruction()" mode="generate-id-from-path"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:value-of select="concat('.processing-instruction-', 1+count(preceding-sibling::processing-instruction()), '-')"/></xsl:template><xsl:template match="@*" mode="generate-id-from-path"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:value-of select="concat('.@', name())"/></xsl:template><xsl:template match="*" mode="generate-id-from-path" priority="-0.5"><xsl:apply-templates select="parent::*" mode="generate-id-from-path"/><xsl:text>.</xsl:text><xsl:value-of select="concat('.',name(),'-',1+count(preceding-sibling::*[name()=name(current())]),'-')"/></xsl:template>

<!--MODE: GENERATE-ID-2 -->
<xsl:template match="/" mode="generate-id-2">U</xsl:template><xsl:template match="*" mode="generate-id-2" priority="2"><xsl:text>U</xsl:text><xsl:number level="multiple" count="*"/></xsl:template><xsl:template match="node()" mode="generate-id-2"><xsl:text>U.</xsl:text><xsl:number level="multiple" count="*"/><xsl:text>n</xsl:text><xsl:number count="node()"/></xsl:template><xsl:template match="@*" mode="generate-id-2"><xsl:text>U.</xsl:text><xsl:number level="multiple" count="*"/><xsl:text>_</xsl:text><xsl:value-of select="string-length(local-name(.))"/><xsl:text>_</xsl:text><xsl:value-of select="translate(name(),':','.')"/></xsl:template><!--Strip characters--><xsl:template match="text()" priority="-1"/>

<!--SCHEMA SETUP-->
<xsl:template match="/"><xsl:variable xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" name="results"><xsl:apply-templates select="/" mode="M40"/><xsl:apply-templates select="/" mode="M41"/><xsl:apply-templates select="/" mode="M42"/><xsl:apply-templates select="/" mode="M43"/></xsl:variable><xsl:if xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:isns="http://www.ato.gov.au/IS/2009/02" test="$results"><xsl:element name="tns:Event" namespace="http://sbr.gov.au/comn/event.02.data" inherit-namespaces="no"><xsl:element name="tns:MaximumSeverity.Code"><xsl:choose><xsl:when test="$results//tns:Severity.Code[.='Error']">Error</xsl:when><xsl:when test="$results//tns:Severity.Code[.='Partial']">Partial</xsl:when><xsl:when test="$results//tns:Severity.Code[.='Warning']">Warning</xsl:when><xsl:when test="$results//tns:Severity.Code[.='Information']">Information</xsl:when><xsl:when test="$results//tns:Severity.Code[.='Progressive']">Progressive</xsl:when><xsl:otherwise>Information</xsl:otherwise></xsl:choose></xsl:element><xsl:element name="tns:EventItems"><xsl:if test="not($results//tns:Severity.Code[.='Error'] or  $results//tns:Severity.Code[.='Partial'])"><xsl:element name="tns:EventItem"><xsl:element name="tns:Error.Code">CMN.ATO.GEN.OK</xsl:element><xsl:element name="tns:Severity.Code">Information</xsl:element><xsl:element name="tns:Short.Description">Message accepted</xsl:element><xsl:element name="tns:Locations"><xsl:element name="tns:Location"><xsl:element name="tns:Location.Instance.Identifier"><xsl:value-of select="$document-id"/></xsl:element></xsl:element></xsl:element></xsl:element></xsl:if><xsl:copy-of copy-namespaces="no" select="$results"/></xsl:element></xsl:element></xsl:if></xsl:template>

<!--SCHEMATRON PATTERNS-->


<!--
                PATTERN VariablesXBRL variables that are applicable accross all of the SSRIR services.-->
<xsl:variable name="SENDER.Context" select="xbrli:xbrl/xbrli:context                                       [                                           not(@i:nil='true')                                            and                                            xbrli:period/xbrli:startDate[not(@i:nil='true')]                                            and                                            xbrli:period/xbrli:endDate[not(@i:nil='true')]                                           and                                            xbrli:entity/xbrli:segment                                           [                                               count(xbrldi:explicitMember) = 1                                                and                                               count(xbrldi:typedMember) = 0                                               and                                               xbrldi:explicitMember                                               [                                                   matches(@dimension,'^RprtPyType\.\d{2}\.\d{2}:ReportPartyTypeDimension$')                                                   and                                                    matches(.,'^RprtPyType\.\d{2}\.\d{2}:MessageSender$')                                                       ]                                           ]                                       ]"/><xsl:variable name="SENDER.ContextId" select="$SENDER.Context/@id"/><xsl:variable name="RECEIVER.Context" select="xbrli:xbrl/xbrli:context                                       [                                           not(@i:nil='true')                                            and                                            xbrli:period/xbrli:startDate[not(@i:nil='true')]                                            and                                            xbrli:period/xbrli:endDate[not(@i:nil='true')]                                           and                                            xbrli:entity/xbrli:segment                                           [                                               count(xbrldi:explicitMember) = 1                                                and                                               count(xbrldi:typedMember) = 0                                               and                                               xbrldi:explicitMember                                               [                                                   matches(@dimension,'^RprtPyType\.\d{2}\.\d{2}:ReportPartyTypeDimension$')                                                   and                                                    matches(.,'^RprtPyType\.\d{2}\.\d{2}:MessageReceiver$')                                                       ]                                           ]                                       ]"/><xsl:variable name="RECEIVER.ContextId" select="$RECEIVER.Context/@id"/><xsl:variable name="MEMROLTRANS.Context" select="xbrli:xbrl/xbrli:context                                       [                                           not(@i:nil='true')                                            and                                            xbrli:period/xbrli:startDate[not(@i:nil='true')]                                            and                                            xbrli:period/xbrli:endDate[not(@i:nil='true')]                                           and                                            xbrli:entity/xbrli:segment                                           [                                               count(xbrldi:explicitMember) = 1                                                and                                                (count(xbrldi:typedMember) &gt;= 3 and count(xbrldi:typedMember) &lt;= 5)                                               and                                               xbrldi:explicitMember                                               [                                                   (ends-with(@dimension, ':ReportPartyTypeDimension') or @dimension ='ReportPartyTypeDimension')                                                   and (ends-with(., ':SuperFundMember') or . = 'SuperFundMember')                                               ]                                               and                                                count(xbrldi:typedMember[(ends-with(@dimension, ':TransferringSuperFundAllocatedMemberIDDimension') or @dimension = 'TransferringSuperFundAllocatedMemberIDDimension')]                                                   /*[(ends-with(name(), ':SuperannuationFundDetails.MemberClient.Identifier') or name() = 'SuperannuationFundDetails.MemberClient.Identifier')]) = 1                                               and count(xbrldi:typedMember[(ends-with(@dimension, ':TransferringSuperFundABNDimension') or @dimension = 'TransferringSuperFundABNDimension')]                                                   /*[(ends-with(name(), ':Identifiers.AustralianBusinessNumber.Identifier') or name() = 'Identifiers.AustralianBusinessNumber.Identifier')]) = 1                                               and count(xbrldi:typedMember[(ends-with(@dimension, ':ReceivingSuperFundABNDimension') or @dimension = 'ReceivingSuperFundABNDimension')]                                                   /*[(ends-with(name(), ':Identifiers.AustralianBusinessNumber.Identifier') or name()= 'Identifiers.AustralianBusinessNumber.Identifier' )]) = 1                                               and count(xbrldi:typedMember[(ends-with(@dimension, ':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension = 'TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension' )]                                                   /*[(ends-with(name(), ':SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier') or name() = 'SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier')]) &lt;= 1                                               and count(xbrldi:typedMember[(ends-with(@dimension, ':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension')]                                                   /*[(ends-with(name(), ':SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier') or name() = 'SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier' )]) &lt;= 1                                           ]                                       ]"/><xsl:variable name="MEMROLTRANS.ContextId" select="$MEMROLTRANS.Context/@id"/><xsl:template match="text()" priority="-1" mode="M40"/><xsl:template match="@*|node()" priority="-2" mode="M40"><xsl:apply-templates select="*" mode="M40"/></xsl:template>

<!--
                PATTERN ContextValidations for contexts that are applicable accross all of the SSRIR services.-->


	<!--
            RULE -->
<xsl:template match="xbrli:xbrl[not(@i:nil='true')]" priority="1003" mode="M41">

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         not($SENDER.ContextId)                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.6</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Missing context declaration.</tns:Short.Description><tns:Detailed.Description>Instance document MUST contain {contextcount} {contextname} context declarations.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>contextcount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>MessageSender</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>MessageSender</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000001</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:context</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         not($RECEIVER.ContextId)                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.6</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Missing context declaration.</tns:Short.Description><tns:Detailed.Description>Instance document MUST contain {contextcount} {contextname} context declarations.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>contextcount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>MessageReceiver</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>MessageReceiver</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000002</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:context</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         count($MEMROLTRANS.ContextId) &lt; 1                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.6</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Missing context declaration.</tns:Short.Description><tns:Detailed.Description>Instance document MUST contain {contextcount} {contextname} context declarations.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>contextcount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>SuperFundMember</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>SuperFundMember</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000003</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:context</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         count($SENDER.ContextId) &gt; 1                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.10</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Too many instances of a context declaration.</tns:Short.Description><tns:Detailed.Description>Context {contextname} may only contain {contextcount} occurrences within the instance document.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>MessageSender</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextcount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>MessageSender</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000005</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:context</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         count($RECEIVER.ContextId) &gt; 1                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.10</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Too many instances of a context declaration.</tns:Short.Description><tns:Detailed.Description>Context {contextname} may only contain {contextcount} occurrences within the instance document.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>MessageReceiver</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextcount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>MessageReceiver</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000036</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/xbrli:context</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M41"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl[not(@i:nil='true')]/xbrli:context[exists($SENDER.Context[generate-id() = generate-id(current())])]" priority="1002" mode="M41">

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         xbrli:entity/xbrli:identifier                         [                                                         matches(@scheme,'^http://www.abr.gov.au/abn$')                             and                             not(function:ValidateABN(.))                         ]                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.1</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>ABN {abn} is not valid</tns:Short.Description><tns:Detailed.Description>Please check the ABN to confirm that the number is correct. See {url} for more information.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>abn</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.abr.gov.au/abn</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.100001</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         xbrli:entity/xbrli:identifier                         [                                                         not(matches(@scheme,'^http://www.abr.gov.au/abn$'))                         ]                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.14</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Invalid Entity Identifier Scheme {entityIdScheme}</tns:Short.Description><tns:Detailed.Description>Invalid value supplied for Entity Identifier Scheme - must be {url}. Please correct and resubmit</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>entityIdScheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.abr.gov.au/abn</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.100002</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M41"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl[not(@i:nil='true')]/xbrli:context[exists($RECEIVER.Context[generate-id() = generate-id(current())])]" priority="1001" mode="M41">

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         xbrli:entity/xbrli:identifier                         [                                                         not(matches(@scheme,'^http://www.abr.gov.au/abn$'))                         ]                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.14</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Invalid Entity Identifier Scheme {entityIdScheme}</tns:Short.Description><tns:Detailed.Description>Invalid value supplied for Entity Identifier Scheme - must be {url}. Please correct and resubmit</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>entityIdScheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.abr.gov.au/abn</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.100003</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         xbrli:entity/xbrli:identifier                         [                                                         matches(@scheme,'^http://www.abr.gov.au/abn$')                             and                             not(function:ValidateABN(.))                         ]                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.1</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>ABN {abn} is not valid</tns:Short.Description><tns:Detailed.Description>Please check the ABN to confirm that the number is correct. See {url} for more information.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>abn</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.abr.gov.au/abn</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.100100</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M41"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl[not(@i:nil='true')]/xbrli:context[exists($MEMROLTRANS.Context[generate-id() = generate-id(current())])]" priority="1000" mode="M41">

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         xbrli:entity/xbrli:identifier                         [                                                         matches(@scheme,'^http://www.sbr.gov.au/id$')                      and                      string-length(.) &gt; 20                           ]                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an unexpected value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>xbrli:entity/xbrli:identifier</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>no more than 20 characters</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000103</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:variable name="RecUSI" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[(ends-with(@dimension, ':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension = 'ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension')]/*"/><xsl:variable name="RecABN" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[(ends-with(@dimension, ':ReceivingSuperFundABNDimension') or @dimension = 'ReceivingSuperFundABNDimension')]/*"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         $RecUSI                         [                             (                               ends-with(name(), ':SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier')                                or                                name() = 'SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier'                             )                             and                             not(function:ValidateUSI(., $RecABN))                         ]                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.2</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Unique Superannuation Identifier {usi} not known to Superannuation entity ABN {abn}.</tns:Short.Description><tns:Detailed.Description>Please check the Product Identifier is associated to the ABN provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>usi</tns:Parameter.Identifier><tns:Parameter.Text/></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>abn</tns:Parameter.Identifier><tns:Parameter.Text/></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000104</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:variable name="TferUSI" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[(ends-with(@dimension, ':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension = 'TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension')]/*"/><xsl:variable name="TferABN" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[(ends-with(@dimension, ':TransferringSuperFundABNDimension') or @dimension = 'TransferringSuperFundABNDimension')]/*"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         $TferUSI                         [                             (                               ends-with(name(), ':SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier')                                or                                name() = 'SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier'                             )                             and                             not(function:ValidateUSI(., $TferABN))                         ]                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.2</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Unique Superannuation Identifier {usi} not known to Superannuation entity ABN {abn}.</tns:Short.Description><tns:Detailed.Description>Please check the Product Identifier is associated to the ABN provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>usi</tns:Parameter.Identifier><tns:Parameter.Text/></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>abn</tns:Parameter.Identifier><tns:Parameter.Text/></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000105</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         xbrli:entity/xbrli:identifier                         [                                                         matches(@scheme,'^http://www.ato.gov.au/tfn$')                             and                             not(function:ValidateTFN(.))                         ]                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.9</tns:Error.Code><tns:Severity.Code>Warning</tns:Severity.Code><tns:Short.Description>TFN failed the TFN algorithm check.</tns:Short.Description><tns:Detailed.Description>TFN {tfn} failed the TFN algorithm check</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tfn</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.100006</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         xbrli:entity/xbrli:identifier                         [                                                         not(matches(@scheme,'^http://www.ato.gov.au/tfn$'))                             and                             not(matches(@scheme,'^http://www.sbr.gov.au/id$'))                         ]                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.14</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Invalid Entity Identifier Scheme {entityIdScheme}</tns:Short.Description><tns:Detailed.Description>Invalid value supplied for Entity Identifier Scheme - must be {url}. Please correct and resubmit</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>entityIdScheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.ato.gov.au/tfn or http://www.sbr.gov.au/id</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.100007</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         xbrli:entity/xbrli:segment/xbrldi:typedMember[(ends-with(@dimension, ':TransferringSuperFundABNDimension') or @dimension = 'TransferringSuperFundABNDimension')]/*                         [                             (                               ends-with(name(), ':Identifiers.AustralianBusinessNumber.Identifier')                                or                                name() = 'Identifiers.AustralianBusinessNumber.Identifier'                             )                             and                             not(function:ValidateABN(.))                         ]                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.1</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>ABN {abn} is not valid</tns:Short.Description><tns:Detailed.Description>Please check the ABN to confirm that the number is correct. See {url} for more information.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>abn</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:segment/xbrldi:typedMember[(ends-with(@dimension, ':TransferringSuperFundABNDimension') or @dimension = 'TransferringSuperFundABNDimension')]/*[(ends-with(name(), ':Identifiers.AustralianBusinessNumber.Identifier') or name() = 'Identifiers.AustralianBusinessNumber.Identifier')]"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.abr.gov.au/abn</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.100013</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                         xbrli:entity/xbrli:segment/xbrldi:typedMember[(ends-with(@dimension, ':ReceivingSuperFundABNDimension') or @dimension = 'ReceivingSuperFundABNDimension')]/*                         [                             (                               ends-with(name(), ':Identifiers.AustralianBusinessNumber.Identifier')                                or                                name() = 'Identifiers.AustralianBusinessNumber.Identifier'                             )                             and                             not(function:ValidateABN(.))                         ]                      )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SBR.GEN.GEN.1</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>ABN {abn} is not valid</tns:Short.Description><tns:Detailed.Description>Please check the ABN to confirm that the number is correct. See {url} for more information.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>abn</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./xbrli:entity/xbrli:segment/xbrldi:typedMember[(ends-with(@dimension, ':ReceivingSuperFundABNDimension') or @dimension = 'ReceivingSuperFundABNDimension')]/*[(ends-with(name(), ':Identifiers.AustralianBusinessNumber.Identifier') or name() = 'Identifiers.AustralianBusinessNumber.Identifier')]"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>url</tns:Parameter.Identifier><tns:Parameter.Text>http://www.abr.gov.au/abn</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.100014</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M41"/></xsl:template><xsl:template match="text()" priority="-1" mode="M41"/><xsl:template match="@*|node()" priority="-2" mode="M41"><xsl:apply-templates select="*" mode="M41"/></xsl:template>

<!--
                PATTERN MandatoriesMandatory Validations-->


	<!--
            RULE -->
<xsl:template match="xbrli:xbrl[not(@i:nil='true')]" priority="1008" mode="M42">

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count($SENDER.ContextId) = 1                 and                 not(key('contextDetailsById', $SENDER.ContextId)[self::orgname1.02.00:OrganisationNameDetails[not(@i:nil='true')]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>orgname1.02.00:OrganisationNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000037</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/orgname1.02.00:OrganisationNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count($SENDER.ContextId) = 1                 and                 not(key('contextDetailsById', $SENDER.ContextId)[self::prsnstrcnm1.02.00:PersonNameDetails[not(@i:nil='true')]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>prsnstrcnm1.02.00:PersonNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000039</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/prsnstrcnm1.02.00:PersonNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count($SENDER.ContextId) = 1                 and                 not(key('contextDetailsById', $SENDER.ContextId)[self::email1.02.00:ElectronicContactElectronicMail[not(@i:nil='true')]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>email1.02.00:ElectronicContactElectronicMail</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000041</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/email1.02.00:ElectronicContactElectronicMail</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count($SENDER.ContextId) = 1                 and                 not(key('contextDetailsById', $SENDER.ContextId)[self::phone1.02.00:ElectronicContactTelephone[not(@i:nil='true')]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>phone1.02.00:ElectronicContactTelephone</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000043</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/phone1.02.00:ElectronicContactTelephone</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count($RECEIVER.ContextId) = 1                 and                 not(key('contextDetailsById', $RECEIVER.ContextId)[self::orgname1.02.00:OrganisationNameDetails[not(@i:nil='true')]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>orgname1.02.00:OrganisationNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RECEIVER.Context/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RECEIVER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RECEIVER.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RECEIVER.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000045</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/orgname1.02.00:OrganisationNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M42"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="address3.02.01:AddressDetails[not(@i:nil='true')]" priority="1007" mode="M42"><xsl:variable name="tupleContextId" select="*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.01:AddressDetails.Usage.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.01:AddressDetails.Usage.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000026</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.01:AddressDetails.Usage.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:AddressDetails.Line1.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:AddressDetails.Line1.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000028</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:AddressDetails.Line1.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:AddressDetails.LocalityName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:AddressDetails.LocalityName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000029</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:AddressDetails.LocalityName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.08:AddressDetails.Country.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.08:AddressDetails.Country.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000032</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.08:AddressDetails.Country.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M42"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="financialinstitutionaccount1.02.00:FinancialInstitutionAccount[not(@i:nil='true')]" priority="1006" mode="M42"><xsl:variable name="tupleContextId" select="*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyid.02.00:FinancialInstitutionAccount.BankStateBranch.Number[not(@i:nil='true')])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyid.02.00:FinancialInstitutionAccount.BankStateBranch.Number</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000108</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyid.02.00:FinancialInstitutionAccount.BankStateBranch.Number</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccount.Number[not(@i:nil='true')])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccount.Number</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000109</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccount.Number</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccountName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccountName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000110</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccountName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M42"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="orgname1.02.00:OrganisationNameDetails[not(@i:nil='true')]" priority="1005" mode="M42"><xsl:variable name="tupleContextId" select="*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000006</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:OrganisationNameDetails.OrganisationalName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:OrganisationNameDetails.OrganisationalName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000008</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:OrganisationNameDetails.OrganisationalName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M42"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="prsnstrcnm1.02.00:PersonNameDetails[not(@i:nil='true')]" priority="1004" mode="M42"><xsl:variable name="tupleContextId" select="*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 $tupleContextId = $SENDER.ContextId                 and                 not(pyde.02.00:PersonNameDetails.FamilyName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:PersonNameDetails.GivenName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000106</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:PersonNameDetails.FamilyName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 $tupleContextId = $MEMROLTRANS.ContextId                 and                 not(pyde.02.00:PersonNameDetails.FamilyName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:PersonNameDetails.FamilyName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000010</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:PersonNameDetails.FamilyName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                   $tupleContextId = $SENDER.ContextId                   and                   not(pyde.02.00:PersonNameDetails.GivenName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])               )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:PersonNameDetails.GivenName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000107</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:PersonNameDetails.GivenName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 $tupleContextId = $MEMROLTRANS.ContextId                 and                 not(pyde.02.00:PersonNameDetails.GivenName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:PersonNameDetails.GivenName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000011</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:PersonNameDetails.GivenName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M42"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="email1.02.00:ElectronicContactElectronicMail[not(@i:nil='true')]" priority="1003" mode="M42"><xsl:variable name="tupleContextId" select="*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000013</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:ElectronicContact.ElectronicMail.Address.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:ElectronicContact.ElectronicMail.Address.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000015</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:ElectronicContact.ElectronicMail.Address.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M42"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="phone1.02.00:ElectronicContactTelephone[not(@i:nil='true')]" priority="1002" mode="M42"><xsl:variable name="tupleContextId" select="*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:ElectronicContact.Telephone.Usage.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:ElectronicContact.Telephone.Usage.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000017</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:ElectronicContact.Telephone.Usage.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000019</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(pyde.02.00:ElectronicContact.Telephone.Minimal.Number[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:ElectronicContact.Telephone.Minimal.Number</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000020</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:ElectronicContact.Telephone.Minimal.Number</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M42"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="sprrol.0003.inititaterollover.req.02.00:SuperannuationRolloverOtherDetails[not(@i:nil='true')]" priority="1001" mode="M42"><xsl:variable name="tupleContextId" select="*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(emsup.02.23:SuperannuationRollover.OtherDetails.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>emsup.02.23:SuperannuationRollover.OtherDetails.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000101</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/emsup.02.23:SuperannuationRollover.OtherDetails.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(emsup.02.23:SuperannuationRollover.OtherDetails.Description[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>emsup.02.23:SuperannuationRollover.OtherDetails.Description</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000102</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/emsup.02.23:SuperannuationRollover.OtherDetails.Description</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M42"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl[not(@i:nil='true')]/xbrli:context[exists($MEMROLTRANS.Context[generate-id() = generate-id(current())])]" priority="1000" mode="M42"><xsl:variable name="thisContextId" select="@id"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $thisContextId)[self::pyde.02.18:PersonDemographicDetails.Sex.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.18:PersonDemographicDetails.Sex.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000023</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.18:PersonDemographicDetails.Sex.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $thisContextId)[self::pyde.02.00:PersonDemographicDetails.Birth.Date[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:PersonDemographicDetails.Birth.Date</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000024</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:PersonDemographicDetails.Birth.Date</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.TransferWholeBalance.Indicator[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>emsup.02.08:SuperannuationRollover.TransferWholeBalance.Indicator</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000033</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/emsup.02.08:SuperannuationRollover.TransferWholeBalance.Indicator</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $thisContextId)[self::prsnstrcnm1.02.00:PersonNameDetails])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>prsnstrcnm1.02.00:PersonNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000047</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/prsnstrcnm1.02.00:PersonNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $thisContextId)[self::address3.02.01:AddressDetails])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>address3.02.01:AddressDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000049</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/address3.02.01:AddressDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 not(key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.4</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Mandatory data element not supplied.</tns:Short.Description><tns:Detailed.Description>{elementname} is mandatory and MUST be provided.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000051</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M42"/></xsl:template><xsl:template match="text()" priority="-1" mode="M42"/><xsl:template match="@*|node()" priority="-2" mode="M42"><xsl:apply-templates select="*" mode="M42"/></xsl:template>

<!--
                PATTERN ContentContent Validations-->


	<!--
            RULE -->
<xsl:template match="xbrli:xbrl[not(@i:nil='true')]" priority="1003" mode="M43">

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 key('contextDetailsById', $SENDER.ContextId)[self::email1.02.00:ElectronicContactElectronicMail]/pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code[not(matches(.,'^03$','i'))]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an unexpected value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>email1.02.00:ElectronicContactElectronicMail/pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>03</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000014</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/email1.02.00:ElectronicContactElectronicMail/pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 key('contextDetailsById', $SENDER.ContextId)[self::phone1.02.00:ElectronicContactTelephone]/pyde.02.00:ElectronicContact.Telephone.Usage.Code[not(@i:nil='true') and not(matches(.,'^03$','i'))]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an unexpected value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>phone1.02.00:ElectronicContactTelephone/pyde.02.00:ElectronicContact.Telephone.Usage.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>03</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000018</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/phone1.02.00:ElectronicContactTelephone/pyde.02.00:ElectronicContact.Telephone.Usage.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 key('contextDetailsById', $SENDER.ContextId)[self::phone1.02.00:ElectronicContactTelephone]/pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code[not(@i:nil='true') and not(matches(.,'^(01|02)$','i'))]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an unexpected value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>phone1.02.00:ElectronicContactTelephone/pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>01 or 02</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000021</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/phone1.02.00:ElectronicContactTelephone/pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $SENDER.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>orgname1.02.00:OrganisationNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000038</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/orgname1.02.00:OrganisationNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $SENDER.ContextId)[self::prsnstrcnm1.02.00:PersonNameDetails]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>prsnstrcnm1.02.00:PersonNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000040</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/prsnstrcnm1.02.00:PersonNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $SENDER.ContextId)[self::email1.02.00:ElectronicContactElectronicMail]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>email1.02.00:ElectronicContactElectronicMail</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000042</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/email1.02.00:ElectronicContactElectronicMail</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $SENDER.ContextId)[self::phone1.02.00:ElectronicContactTelephone]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>phone1.02.00:ElectronicContactTelephone</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$SENDER.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000044</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/phone1.02.00:ElectronicContactTelephone</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $RECEIVER.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>orgname1.02.00:OrganisationNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RECEIVER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RECEIVER.Context/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RECEIVER.ContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RECEIVER.Context/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$RECEIVER.Context/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000046</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/orgname1.02.00:OrganisationNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M43"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="address3.02.01:AddressDetails[not(@i:nil='true')]" priority="1002" mode="M43"><xsl:variable name="tupleContextId" select="*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 pyde.02.01:AddressDetails.Usage.Code[not(matches(.,'^(POS|RES)$','i'))]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an unexpected value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.01:AddressDetails.Usage.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>POS or RES</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000027</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.01:AddressDetails.Usage.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 pyde.02.08:AddressDetails.Country.Code[. = 'au']                 and                 not(pyde.02.00:AddressDetails.Postcode.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.7</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Conditional data element rule failure.</tns:Short.Description><tns:Detailed.Description>{elementname1} MUST be provided if {elementname2} is set to {elementname2value}</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname1</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:AddressDetails.Postcode.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementname2</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.08:AddressDetails.Country.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementname2value</tns:Parameter.Identifier><tns:Parameter.Text>au</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000030</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:AddressDetails.Postcode.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 pyde.02.08:AddressDetails.Country.Code[. = 'au']                 and                 not(pyde.02.00:AddressDetails.StateOrTerritory.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.7</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Conditional data element rule failure.</tns:Short.Description><tns:Detailed.Description>{elementname1} MUST be provided if {elementname2} is set to {elementname2value}</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname1</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:AddressDetails.StateOrTerritory.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementname2</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.08:AddressDetails.Country.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementname2value</tns:Parameter.Identifier><tns:Parameter.Text>au</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000031</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:AddressDetails.StateOrTerritory.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 pyde.02.00:AddressDetails.LocalityName.Text[string-length(.) &gt; 50]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an unexpected value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:AddressDetails.LocalityName.Text</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>no more than 50 characters</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000038</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:AddressDetails.LocalityName.Text</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M43"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="orgname1.02.00:OrganisationNameDetails[not(@i:nil='true')]" priority="1001" mode="M43"><xsl:variable name="tupleContextId" select="*[1]/@contextRef"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code[not(@i:nil='true') and not(. = 'MN')]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an unexpected value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>MN</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$tupleContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextById',$tupleContextId)/xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.GEN.000007</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M43"/></xsl:template>

	<!--
            RULE -->
<xsl:template match="xbrli:xbrl[not(@i:nil='true')]/xbrli:context[exists($MEMROLTRANS.Context[generate-id() = generate-id(current())])]" priority="1000" mode="M43"><xsl:variable name="thisContextId" select="@id"/>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.TransferWholeBalance.Indicator[matches(.,'^(false|0)$')]]                 and                 not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.Requested.Amount[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.RLVR.1</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>SuperannuationRollover.Requested.Amount MUST be provided if SuperannuationRollover.TransferWholeBalance.Indicator is "false"</tns:Short.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000034</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/emsup.02.08:SuperannuationRollover.Requested.Amount</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $thisContextId)[self::prsnstrcnm1.02.00:PersonNameDetails]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>prsnstrcnm1.02.00:PersonNameDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000048</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/prsnstrcnm1.02.00:PersonNameDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(             count(key('contextDetailsById', $thisContextId)[self::address3.02.01:AddressDetails]) &gt; 1          )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>address3.02.01:AddressDetails</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="./@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000050</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/address3.02.01:AddressDetails</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(             key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[matches(.,'^(false|0)$')]]             and             xbrli:entity/xbrli:identifier             [                                            matches(@scheme,'^http://www.sbr.gov.au/id$')             ]          )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.1</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>TFN quoted indicator does not match Entity ID scheme.</tns:Short.Description><tns:Detailed.Description>Identifiers.TaxFileNumberNotProvided.Indicator has been set to {value} however the Entity ID Scheme is set to {entityscheme}</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>value</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator]"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>entityscheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000052</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(             key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[matches(.,'^(true|1)$')]]             and             xbrli:entity/xbrli:identifier             [                                            matches(@scheme,'^http://www.ato.gov.au/tfn$')             ]          )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.1</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>TFN quoted indicator does not match Entity ID scheme.</tns:Short.Description><tns:Detailed.Description>Identifiers.TaxFileNumberNotProvided.Indicator has been set to {value} however the Entity ID Scheme is set to {entityscheme}</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>value</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator]"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>entityscheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000053</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 key('contextDetailsById', $thisContextId)[self::emsup.02.03:SuperannuationFundDetails.MemberClient.Identifier[string-length(.) &gt; 20]]             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.5</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Data element contained an unexpected value.</tns:Short.Description><tns:Detailed.Description>{elementname} MUST be set to {elementvalue}.</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname</tns:Parameter.Identifier><tns:Parameter.Text>emsup.02.03:SuperannuationFundDetails.MemberClient.Identifier</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementvalue</tns:Parameter.Identifier><tns:Parameter.Text>no more than 20 characters</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000100</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/emsup.02.03:SuperannuationFundDetails.MemberClient.Identifier</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $thisContextId)[self::financialinstitutionaccount1.02.00:FinancialInstitutionAccount]) &gt; 1             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.8</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Tuple has too many occurrences for a context declaration.</tns:Short.Description><tns:Detailed.Description>Tuple {tuplename} must only have {tuplecount} occurrence within the context {contextname}</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>tuplename</tns:Parameter.Identifier><tns:Parameter.Text>financialinstitutionaccount1.02.00:FinancialInstitutionAccount</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>tuplecount</tns:Parameter.Identifier><tns:Parameter.Text>1</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>contextname</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextID</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="$thisContextId"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000111</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/financialinstitutionaccount1.02.00:FinancialInstitutionAccount</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose>

		<!--
            ASSERT -->
<xsl:choose><xsl:when test="not(                 count(key('contextDetailsById', $thisContextId)[self::emsup.02.39:SuperannuationRollover.ReleaseAuthorityProductType.Code])             )"/><xsl:otherwise> <tns:EventItem xmlns:tns="http://sbr.gov.au/comn/event.02.data" xmlns:svrl="http://purl.oclc.org/dsdl/svrl" xmlns:isns="http://www.ato.gov.au/IS/2009/02"><tns:Error.Code>SUPER.GEN.GEN.7</tns:Error.Code><tns:Severity.Code>Error</tns:Severity.Code><tns:Short.Description>Conditional data element rule failure.</tns:Short.Description><tns:Detailed.Description>{elementname1} MUST be provided if {elementname2} is set to {elementname2value}</tns:Detailed.Description><tns:Parameters><tns:Parameter><tns:Parameter.Identifier>elementname1</tns:Parameter.Identifier><tns:Parameter.Text>emsup.02.39:SuperannuationRollover.ReleaseAuthorityProductType.Code</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementname2</tns:Parameter.Identifier><tns:Parameter.Text>eb:Action</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>elementname2value</tns:Parameter.Identifier><tns:Parameter.Text>ReleaseAuthority</tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReportPartyTypeDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="substring-after(xbrli:entity/xbrli:segment/xbrldi:explicitMember[ends-with(@dimension,':ReportPartyTypeDimension') or @dimension='ReportPartyTypeDimension'],':')"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ContextId</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="@id"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Identifier</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>Scheme</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:identifier/@scheme"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundAllocatedMemberIDDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundAllocatedMemberIDDimension') or @dimension='TransferringSuperFundAllocatedMemberIDDimension']/*:SuperannuationFundDetails.MemberClient.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperFundABNDimension') or @dimension='TransferringSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='TransferringSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperFundABNDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperFundABNDimension') or @dimension='ReceivingSuperFundABNDimension']/*:Identifiers.AustralianBusinessNumber.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension</tns:Parameter.Identifier><tns:Parameter.Text>
            <xsl:value-of xmlns="http://www.ato.gov.au/IS/2009/02" select="xbrli:entity/xbrli:segment/xbrldi:typedMember[ends-with(@dimension,':ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension') or @dimension='ReceivingSuperannuationFundUniqueSuperannuationIdentifierDimension']/*:SuperannuationFundDetails.UniqueSuperannuationIdentifier.Identifier"/>
          </tns:Parameter.Text></tns:Parameter><tns:Parameter><tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier><tns:Parameter.Text>VR.SS.RIR.000112</tns:Parameter.Text></tns:Parameter></tns:Parameters><tns:Locations><tns:Location><tns:Location.Instance.Identifier><xsl:value-of select="$document-id"/></tns:Location.Instance.Identifier><tns:Location.Path.Text><xsl:apply-templates select="." mode="schematron-get-full-path-2ato"/><xsl:text>/emsup.02.39:SuperannuationRollover.ReleaseAuthorityProductType.Code</xsl:text></tns:Location.Path.Text></tns:Location></tns:Locations></tns:EventItem></xsl:otherwise></xsl:choose><xsl:apply-templates select="*" mode="M43"/></xsl:template><xsl:template match="text()" priority="-1" mode="M43"/><xsl:template match="@*|node()" priority="-2" mode="M43"><xsl:apply-templates select="*" mode="M43"/></xsl:template></xsl:stylesheet>