<!-- The command-line parameters are:
    phase           NMTOKEN | "#ALL" (default) Select the phase for validation
    allow-foreign   "true" | "false" (default)   Pass non-Schematron elements to the generated stylesheet
    diagnose= true | false|yes|no    Add the diagnostics to the assertion test in reports (yes|no are obsolete)
    generate-paths=true|false|yes|no   generate the @location attribute with XPaths (yes|no are obsolete)
    sch.exslt.imports semi-colon delimited string of filenames for some EXSLT implementations          
    optimize        "visit-no-attributes"     Use only when the schema has no attributes as the context nodes
    generate-fired-rule "true"(default) | "false"  Generate fired-rule elements
-->

<xsl:stylesheet
    version="2.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias"
    xmlns:schold="http://www.ascc.net/xml/schematron"
    xmlns:iso="http://purl.oclc.org/dsdl/schematron"
    xmlns:svrl="http://purl.oclc.org/dsdl/svrl"
    xmlns:tns="http://sbr.gov.au/comn/event.02.data"
    xmlns:i="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:isns="http://www.ato.gov.au/IS/2009/02">

  <xsl:import href="iso_schematron_skeleton_for_saxon.xsl"/>

  <xsl:param name="diagnose">true</xsl:param>
  <xsl:param name="phase">
    <xsl:choose>
      <!-- Handle ISO Schematron phases -->
      <xsl:when test="//iso:schema/@defaultPhase">
        <xsl:value-of select="//iso:schema/@defaultPhase"/>
      </xsl:when>
      <xsl:otherwise>#ALL</xsl:otherwise>
    </xsl:choose>
  </xsl:param>
  <xsl:param name="allow-foreign">false</xsl:param>
  <xsl:param name="generate-paths">true</xsl:param>
  <xsl:param name="generate-fired-rule">true</xsl:param>
  <xsl:param name="optimize"/>
  <xsl:param name="output-encoding"/>
  <xsl:param name="sch.exslt.imports"/>

  <xsl:template name="process-prolog">

    <axsl:import href="SSRIR202006Validator_Functions.xsl"/>
    <axsl:variable name="document-uri">
      <axsl:value-of select="document-uri(/)" />
    </axsl:variable>

    <!-- Variable to support the use of an apostrophe in country names. -->
    <xsl:text disable-output-escaping="yes">&lt;xsl:variable name="Apostrophe"&gt;&#39;&lt;/xsl:variable&gt;</xsl:text>

    <axsl:output method="xml" omit-xml-declaration="no" standalone="yes" indent="no">
      <xsl:if test=" string-length($output-encoding) &gt; 0">
        <xsl:attribute name="encoding">
          <xsl:value-of select=" $output-encoding" />
        </xsl:attribute>
      </xsl:if>
    </axsl:output>
    <axsl:param name="document-id"></axsl:param>



    <xsl:comment>MODE: SCHEMATRON-FULL-PATH-2ATO</xsl:comment>
    <xsl:text>&#10;</xsl:text>
    <xsl:comment>This mode can be used to generate prefixed XPath for humans</xsl:comment>
    <xsl:text>&#10;</xsl:text>
    <!--simplify the error messages by using the namespace prefixes of the
     instance rather than the generic namespace-uri-styled qualification-->

    <axsl:template match="node() | @*" mode="schematron-get-full-path-2ato">
      <!--report the element hierarchy-->
      <axsl:for-each select="ancestor-or-self::*">
        <axsl:if test="name(.) != 'documents' and name(.) != 'document'">
          <axsl:text>/</axsl:text>
          <axsl:value-of select="name(.)"/>
          <axsl:if test="preceding-sibling::*[name(.)=name(current())]">
            <axsl:text>[</axsl:text>
            <axsl:value-of
                select="count(preceding-sibling::*[name(.)=name(current())])+1"/>
            <axsl:text>]</axsl:text>
          </axsl:if>
        </axsl:if>          
      </axsl:for-each>
      <!--report the attribute-->
      <axsl:if test="not(self::*)">
        <axsl:text/>/@<axsl:value-of select="name(.)"/>
      </axsl:if>
    </axsl:template>

  </xsl:template>

  <!-- Overrides skeleton.xsl -->
  <xsl:template name="process-root">
    <xsl:param name="title"/>
    <xsl:param name="contents" />
    <xsl:param name="queryBinding" >xslt1</xsl:param>
    <xsl:param name="schemaVersion" />
    <xsl:param name="id" />
    <xsl:param name="version"/>
    <!-- "Rich" parameters -->
    <xsl:param name="fpi" />
    <xsl:param name="icon" />
    <xsl:param name="lang" />
    <xsl:param name="see" />
    <xsl:param name="space" />

    <axsl:variable name="results">
      <xsl:apply-templates mode="do-schema-p"/>
      <xsl:copy-of select="$contents"/>
    </axsl:variable>
    <axsl:if test="$results">
      <axsl:element name="tns:Event" namespace="http://sbr.gov.au/comn/event.02.data" inherit-namespaces="no">
        <axsl:element name="tns:MaximumSeverity.Code">
          <axsl:choose>
            <axsl:when test="$results//tns:Severity.Code[.='Error']">Error</axsl:when>
            <axsl:when test="$results//tns:Severity.Code[.='Partial']">Partial</axsl:when>
            <axsl:when test="$results//tns:Severity.Code[.='Warning']">Warning</axsl:when>
            <axsl:when test="$results//tns:Severity.Code[.='Information']">Information</axsl:when>
            <axsl:when test="$results//tns:Severity.Code[.='Progressive']">Progressive</axsl:when>
            <axsl:otherwise>Information</axsl:otherwise>
          </axsl:choose>
        </axsl:element>
        <axsl:element name="tns:EventItems">
          <axsl:if  test="not($results//tns:Severity.Code[.='Error'] or  $results//tns:Severity.Code[.='Partial'])">
            <axsl:element name="tns:EventItem">
              <axsl:element name="tns:Error.Code">CMN.ATO.GEN.OK</axsl:element>
              <axsl:element name="tns:Severity.Code">Information</axsl:element>
              <axsl:element name="tns:Short.Description">Message accepted</axsl:element>
              <axsl:element name="tns:Locations">
                <axsl:element name="tns:Location">
                  <axsl:element name="tns:Location.Instance.Identifier">
                    <axsl:value-of select="$document-id"/>
                  </axsl:element>
                </axsl:element>
              </axsl:element>
            </axsl:element>
          </axsl:if>
          <axsl:copy-of copy-namespaces="no" select="$results"/>
        </axsl:element>
      </axsl:element>
    </axsl:if>
  </xsl:template>

  <xsl:template name="process-assert">
    <xsl:param name="test"/>
    <xsl:param name="diagnostics" />
    <xsl:param name="id" />
    <xsl:param name="flag" />
    <xsl:param name="properties" />

    <!-- "Linkable" parameters -->
    <xsl:param name="role"/>
    <xsl:param name="subject"/>
    <!-- "Rich" parameters -->
    <xsl:param name="fpi" />
    <xsl:param name="icon" />
    <xsl:param name="lang" />
    <xsl:param name="see" />
    <xsl:param name="space" />
    <xsl:choose>
      <!-- <xsl:when test="$diagnose = 'yes' or $diagnose= 'true' "> -->
      <xsl:when test="$diagnose">
        <xsl:call-template name="diagnosticsSplit">
          <xsl:with-param name="str" select="$diagnostics"/>
        </xsl:call-template>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="process-report">
    <xsl:param name="id"/>
    <xsl:param name="test"/>
    <xsl:param name="diagnostics"/>
    <xsl:param name="flag" />
    <xsl:param name="properties" />
    <!-- "Linkable" parameters -->
    <xsl:param name="role"/>
    <xsl:param name="subject"/>
    <!-- "Rich" parameters -->
    <xsl:param name="fpi" />
    <xsl:param name="icon" />
    <xsl:param name="lang" />
    <xsl:param name="see" />
    <xsl:param name="space" />

  </xsl:template>

  <xsl:template name="process-diagnostic">
    <xsl:param name="id"/>
    <!-- Rich parameters -->
    <xsl:param name="fpi" />
    <xsl:param name="icon" />
    <xsl:param name="lang" />
    <xsl:param name="see" />
    <xsl:param name="space" />

    <tns:EventItem>
      <tns:Error.Code>
        <xsl:value-of select="isns:ProcessMessage/isns:Code/text()" />
      </tns:Error.Code>

      <xsl:choose>
        <xsl:when test="string-length(isns:ProcessMessage/isns:Severity/text()) &gt; 0">
          <tns:Severity.Code>
            <xsl:value-of select="isns:ProcessMessage/isns:Severity/text()" />
          </tns:Severity.Code>
        </xsl:when>
        <xsl:otherwise>
          <tns:Severity.Code>Error</tns:Severity.Code>
        </xsl:otherwise>
      </xsl:choose>

      <xsl:if test="string-length(isns:ProcessMessage/isns:Description/text()) &gt; 0">
        <tns:Short.Description>
          <xsl:value-of select="isns:ProcessMessage/isns:Description/text()" />
        </tns:Short.Description>
      </xsl:if>

      <xsl:choose>
        <xsl:when test="string-length(isns:ProcessMessage/isns:LongDescription/text()) &gt; 0">
          <tns:Detailed.Description>
            <xsl:value-of select="isns:ProcessMessage/isns:LongDescription/text()" />
          </tns:Detailed.Description>
        </xsl:when>  
       <xsl:otherwise/>
      </xsl:choose>

      <tns:Parameters>
        <xsl:for-each select="isns:EventItem/isns:Parameters/isns:Parameter">
          <tns:Parameter>
            <tns:Parameter.Identifier>
              <xsl:value-of select="isns:Parameter.Identifier/text()" />
            </tns:Parameter.Identifier>
            <tns:Parameter.Text>
              <xsl:copy-of select ="isns:Parameter.Text/node()"/>
            </tns:Parameter.Text>
          </tns:Parameter>
        </xsl:for-each>
        <tns:Parameter>
          <tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier>
          <tns:Parameter.Text>
            <!-- The $id is the DVR id in the diagnostics sch file. Strip out the D to leave the VR. -->
            <!-- Eg: DVR.SS.RIR.000001 -> VR.SS.RIR.000001 -->
            <xsl:value-of select="substring($id, 2, string-length($id))" />
          </tns:Parameter.Text>
        </tns:Parameter>
      </tns:Parameters>

      <tns:Locations>
        <tns:Location>
          <tns:Location.Instance.Identifier>
            <axsl:value-of select="$document-id"/>
          </tns:Location.Instance.Identifier>
          <tns:Location.Path.Text>
            <axsl:apply-templates select="." mode="schematron-get-full-path-2ato"/>
            <xsl:if test="string-length( isns:ProcessMessage/isns:Location[1] ) &gt; 0">
              <xsl:text disable-output-escaping="yes">&lt;xsl:text&gt;</xsl:text>/<xsl:value-of select="isns:ProcessMessage/isns:Location" /><xsl:text disable-output-escaping="yes">&lt;/xsl:text&gt;</xsl:text>
            </xsl:if>
          </tns:Location.Path.Text>
        </tns:Location>
      </tns:Locations>

    </tns:EventItem>
  </xsl:template>


  <!-- Overrides skeleton -->
  <xsl:template name="process-emph" >
    <xsl:param name="class" />
  </xsl:template>

  <xsl:template name="process-rule">
    <xsl:param name="id"/>
    <xsl:param name="context"/>
    <xsl:param name="flag"/>
    <xsl:param name="properties" />
    <!-- "Linkable" parameters -->
    <xsl:param name="role"/>
    <xsl:param name="subject"/>
    <!-- "Rich" parameters -->
    <xsl:param name="fpi" />
    <xsl:param name="icon" />
    <xsl:param name="lang" />
    <xsl:param name="see" />
    <xsl:param name="space" />
  </xsl:template>

  <xsl:template name="process-ns">
    <xsl:param name="prefix"/>
    <xsl:param name="uri"/>
  </xsl:template>

  <xsl:template name="process-p">
    <xsl:param name="icon"/>
    <xsl:param name="class"/>
    <xsl:param name="id"/>
    <xsl:param name="lang"/>
  </xsl:template>

  <xsl:template name="process-pattern">
    <xsl:param name="name"/>
    <xsl:param name="id"/>
    <xsl:param name="is-a"/>

    <!-- "Rich" parameters -->
    <xsl:param name="fpi" />
    <xsl:param name="icon" />
    <xsl:param name="lang" />
    <xsl:param name="see" />
    <xsl:param name="space" />
  </xsl:template>

  <!-- Overrides skeleton -->
  <xsl:template name="process-message" >
    <xsl:param name="pattern"/>
    <xsl:param name="role"/>
  </xsl:template>


  <!-- Overrides skeleton -->
  <xsl:template name="process-span" >
    <xsl:param name="class" />
  </xsl:template>

</xsl:stylesheet>