﻿<?xml version="1.0" encoding="utf-8"?>
<pattern id="Content" xmlns="http://purl.oclc.org/dsdl/schematron">
    <title>Content Validations</title>

  <rule context="xbrli:xbrl[not(@i:nil='true')]">

    <!--    Rule ID: VR.SS.GEN.000014
    
            WHERE IN TUPLE(email1.02.00:ElectronicContactElectronicMail)
            IF (ElectronicContact.ElectronicMail.Usage.Code <>"03")
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000014" diagnostics="DVR.SS.GEN.000014"
            test="not(
                      key('contextDetailsById', $SENDER.ContextId)[self::email1.02.00:ElectronicContactElectronicMail]/pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code[not(@i:nil = 'true') and not(matches(.,'^03$','i'))]
                  )"/>


    <!--    Rule ID: VR.SS.GEN.000018
    
            WHERE IN TUPLE(phone1.02.00:ElectronicContactTelephone)
            IF (ElectronicContact.Telephone.Usage.Code <>"03")
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000018" diagnostics="DVR.SS.GEN.000018"
            test="not(
                      key('contextDetailsById', $SENDER.ContextId)[self::phone1.02.00:ElectronicContactTelephone]/pyde.02.00:ElectronicContact.Telephone.Usage.Code[not(matches(.,'^03$','i'))]
                  )"/>


    <!--    Rule ID: VR.SS.GEN.000021
    
            WHERE IN TUPLE(phone1.02.00:ElectronicContactTelephone)
            IF (ElectronicContact.Telephone.ServiceLine.Code NOT IN SET ("01", "02"))
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000021" diagnostics="DVR.SS.GEN.000021"
            test="not(
                      key('contextDetailsById', $SENDER.ContextId)[self::phone1.02.00:ElectronicContactTelephone]/pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code[not(@i:nil = 'true') and not(matches(.,'^(01|02)$','i'))]
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000046
    
            IF COUNT(RP.SENDER:orgname1.02.00:OrganisationNameDetails) > 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000046" diagnostics="DVR.SS.RRT.000046"
            test="not(
                      count(key('contextDetailsById', $SENDER.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000048
    
            IF COUNT(RP.SENDER:prsnstrcnm1.02.00:PersonNameDetails) > 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000048" diagnostics="DVR.SS.RRT.000048"
            test="not(
                      count(key('contextDetailsById', $SENDER.ContextId)[self::prsnstrcnm1.02.00:PersonNameDetails]) &gt; 1
                  )"/>
    

    <!--    Rule ID: VR.SS.RRT.000050
    
            IF COUNT(RP.SENDER:email1.02.00:ElectronicContactElectronicMail) <> 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000050" diagnostics="DVR.SS.RRT.000050"
            test="not(
                      count(key('contextDetailsById', $SENDER.ContextId)[self::email1.02.00:ElectronicContactElectronicMail]) &gt; 1
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000052
    
            IF COUNT(RP.SENDER:phone1.02.00:ElectronicContactTelephone) <> 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000052" diagnostics="DVR.SS.RRT.000052"
            test="not(
                      count(key('contextDetailsById', $SENDER.ContextId)[self::phone1.02.00:ElectronicContactTelephone]) &gt; 1
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000054
    
            IF COUNT(RP.RECEIVER:orgname1.02.00:OrganisationNameDetails) <> 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000054" diagnostics="DVR.SS.RRT.000054"
            test="not(
                      count(key('contextDetailsById', $RECEIVER.ContextId)[self::orgname1.02.00:OrganisationNameDetails]) &gt; 1
                  )"/>

    
    <!--    Rule ID: VR.SS.RRT.000062
    
            IF (Count (TransferringFund.Any:fininstacc1.02.00:FinancialInstitutionAccount) > 1)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000062" diagnostics="DVR.SS.RRT.000062"
            test="not(
                      count(key('contextDetailsById', $TRANSFUND.ContextId)[self::fininstacc1.02.00:FinancialInstitutionAccount]) &gt; 1
                  )"/>
  </rule>

  <rule context="address3.02.01:AddressDetails[not(@i:nil='true')]">
    <let name="tupleContextId" value="*[1]/@contextRef" />
    
    <!--    Rule ID: VR.SS.GEN.000027
    
            WHERE IN TUPLE (address3.02.01:AddressDetails)
            IF (AddressDetails.Usage.Code NOT IN SET ("POS","RES"))
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000027" diagnostics="DVR.SS.GEN.000027"
            test="not(
                      pyde.02.01:AddressDetails.Usage.Code[not(@i:nil = 'true') and not(matches(.,'^(POS|RES)$','i'))]
                  )"/>
    
    
    <!--    Rule ID: VR.SS.GEN.000030
    
            WHERE IN TUPLE (address3.02.01:AddressDetails)
            IF (AddressDetails.Country.Code = "au") AND (AddressDetails.Postcode.Text = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000030" diagnostics="DVR.SS.GEN.000030"
            test="not(
                      pyde.02.08:AddressDetails.Country.Code[. = 'au']
                      and
                      not(pyde.02.00:AddressDetails.Postcode.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>

    
    <!--    Rule ID: VR.SS.GEN.000031
    
            WHERE IN TUPLE (address3.02.01:AddressDetails)
            IF (AddressDetails.Country.Code = "au") AND (AddressDetails.StateOrTerritory.Code = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000031" diagnostics="DVR.SS.GEN.000031"
            test="not(
                      pyde.02.08:AddressDetails.Country.Code[. = 'au']
                      and
                      not(pyde.02.00:AddressDetails.StateOrTerritory.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>


    <!--    Rule ID: VR.SS.GEN.100102
    
            WHERE IN TUPLE  (address3.02.01:AddressDetails)
            IF LENGTH(pyde.02.00:AddressDetails.LocalityName.Text) > 50
              RETURN VALIDATION MESSAGE
            ENDIF
        -->
    <assert id="VR.SS.GEN.100102" diagnostics="DVR.SS.GEN.100102"
            test="not(
                      pyde.02.00:AddressDetails.LocalityName.Text[string-length(.) > 50]
                  )"/>
  </rule>

  <rule context="orgname1.02.00:OrganisationNameDetails[not(@i:nil='true')]">
    <let name="tupleContextId" value="*[1]/@contextRef" />
    
    <!--    Rule ID: VR.SS.GEN.000007
    
            WHERE IN TUPLE(orgname1.02.00:OrganisationNameDetails)
            IF (OrganisationNameDetails.OrganisationalNameType.Code <>"MN")
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000007" diagnostics="DVR.SS.GEN.000007"
            test="not(
                      pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code[not(@i:nil = 'true') and not(matches(.,'^MN$','i'))]
                  )"/>
    
  </rule>

  <rule context="xbrli:xbrl[not(@i:nil='true')]/xbrli:context[exists($MEMROLTRANS.Context[generate-id() = generate-id(current())])]">
    <let name="thisContextId" value="@id" />

    <!--    Rule ID: VR.SS.RRT.000037
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF (RP.MEMBERROLLOVERTRANSACTION:SuperannuationRollover.TransferWholeBalance.Indicator = "true") 
            AND (SuperannuationRollover.InsuredDeathCover.Amount = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000037" diagnostics="DVR.SS.RRT.000037"
            test="not(
                      key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.TransferWholeBalance.Indicator[matches(.,'^(true|1)$')]]
                      and
                      not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.InsuredDeathCover.Amount[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000038
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF (RP.MEMBERROLLOVERTRANSACTION:SuperannuationRollover.TransferWholeBalance.Indicator = "true")
            AND (RP.MEMBERROLLOVERTRANSACTION:SuperannuationRollover.InsuredTotalPermanentDisablementCover.Amount = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000038" diagnostics="DVR.SS.RRT.000038"
            test="not(
                      key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.TransferWholeBalance.Indicator[matches(.,'^(true|1)$')]]
                      and
                      not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.InsuredTotalPermanentDisablementCover.Amount[@contextRef = $thisContextId and not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000039
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF (RP.MEMBERROLLOVERTRANSACTION:SuperannuationRollover.TransferWholeBalance.Indicator = "true")
            AND (RP.MEMBERROLLOVERTRANSACTION:SuperannuationRollover.InsuredIncomeProtectionMonthlyCover.Amount = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000039" diagnostics="DVR.SS.RRT.000039"
            test="not(
                      key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.TransferWholeBalance.Indicator[matches(.,'^(true|1)$')]]
                      and
                      not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.InsuredIncomeProtectionMonthlyCover.Amount[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>

    <!--    Rule ID: VR.SS.RRT.000056
    
            FOR ANY OCCURRENCE OF CONTEXT (SuperFundMember.Any.Any.Any)
            IF COUNT(SuperFundMember.Any.Any.Any:prsnstrcnm1.02.00:PersonNameDetails)  > 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000056" diagnostics="DVR.SS.RRT.000056"
            test="not(
                      count(key('contextDetailsById', $thisContextId)[self::prsnstrcnm1.02.00:PersonNameDetails]) &gt; 1
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000058
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF COUNT(RP.MEMBERROLLOVERTRANSACTION:address3.02.01:AddressDetails) <> 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000058" diagnostics="DVR.SS.RRT.000058"
            test="not(
                      count(key('contextDetailsById', $thisContextId)[self::address3.02.01:AddressDetails]) &gt; 1
                  )"/>
    
    
    <!-- Rule ID: VR.SS.RRT.000060
  
         FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
         IF (pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator = FALSE and RP.MEMBERROLLOVERTRANSACTION Identifier Scheme = "http://www.sbr.gov.au/id")
            RETURN VALIDATION MESSAGE
         END IF
    -->
    <assert id="VR.SS.RRT.000060" diagnostics="DVR.SS.RRT.000060"
            test="not(
                        key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[matches(.,'^(false|0)$')]]
                        and
                        xbrli:entity/xbrli:identifier
                        [                            
                            matches(@scheme,'^http://www.sbr.gov.au/id$')
                        ]
                     )" />

    
    <!-- Rule ID: VR.SS.RRT.000061
  
         FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
         IF (RP.MEMBERROLLOVERTRANSACTION:Identifiers.TaxFileNumberNotProvided.Indicator = TRUE and RP.MEMBERROLLOVERTRANSACTION Identifier Scheme = "http://www.ato.gov.au/tfn")
            RETURN VALIDATION MESSAGE
         END IF
    -->
    <assert id="VR.SS.RRT.000061" diagnostics="DVR.SS.RRT.000061"
            test="not(
                        key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[matches(.,'^(true|1)$')]]
                        and
                        xbrli:entity/xbrli:identifier
                        [                            
                            matches(@scheme,'^http://www.ato.gov.au/tfn$')
                        ]
                     )" />

    <!-- 
    Variables for the rules VR.SS.RRT.000068, VR.SS.RRT.000069 and VR.SS.RRT.000070
    -->
    <let name="kiwiSaverTaxFreeComponent" value="key('contextDetailsById', $thisContextId)[self::emsup.02.12:SuperannuationRollover.KiwiSaverTaxFreeComponent.Amount[not(@i:nil='true')]]" />
    <let name="kiwiSaverPreserved" value="key('contextDetailsById', $thisContextId)[self::emsup.02.12:SuperannuationRollover.KiwiSaverPreserved.Amount[not(@i:nil='true')]]" />

    <!-- Rule ID: VR.SS.RRT.000068
         WHERE IN CONTEXT SET(SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{RecFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}.{RecFundUSI}) 
         IF emsup.xx.xx:SuperannuationRollover.KiwiSaverTaxFreeComponent.Amount <> NULL AND emsup.xx.xx:SuperannuationRollover.KiwiSaverPreserved.Amount = NULL
             RETURN VALIDATION MESSAGE
         ENDIF
    -->
    <assert id="VR.SS.RRT.000068" diagnostics="DVR.SS.RRT.000068"
            test="not(
                      $kiwiSaverTaxFreeComponent and not($kiwiSaverPreserved)
                  )"/>
    
    <!-- Rule ID: VR.SS.RRT.000069
         WHERE IN CONTEXT SET(SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{RecFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}.{RecFundUSI}) 
         IF emsup.xx.xx:SuperannuationRollover.KiwiSaverTaxFreeComponent.Amount <> NULL AND emsup.xx.xx:SuperannuationRollover.KiwiSaverPreserved.Amount <> NULL AND emsup.xx.xx:SuperannuationRollover.KiwiSaverTaxFreeComponent.Amount <> emsup.xx.xx:SuperannuationRollover.KiwiSaverPreserved.Amount
             RETURN VALIDATION MESSAGE
         ENDIF
    -->
    <assert id="VR.SS.RRT.000069" diagnostics="DVR.SS.RRT.000069"
            test="not(
                      $kiwiSaverTaxFreeComponent and $kiwiSaverPreserved and 
                      (number($kiwiSaverTaxFreeComponent) != number($kiwiSaverPreserved))
                  )"/>
    
    <!-- Rule ID: VR.SS.RRT.000070
         WHERE IN CONTEXT SET(SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{RecFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}.{RecFundUSI}) 
         IF emsup.xx.xx:SuperannuationRollover.KiwiSaverPreserved.Amount <> NULL AND
         emsup.xx.xx:SuperannuationRollover.KiwiSaverTaxFreeComponent.Amount = NULL
             RETURN VALIDATION MESSAGE
         ENDIF
    -->
    <assert id="VR.SS.RRT.000070" diagnostics="DVR.SS.RRT.000070"
            test="not(
                      not($kiwiSaverTaxFreeComponent) and $kiwiSaverPreserved
                  )"/>    

    <!-- Rule ID: VR.SS.RRT.000109
    
          WHERE IN CONTEXT SET(SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{RecFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}.{RecFundUSI}) 
          IF emsup.xx.xx:SuperannuationRollover.DeathBenefitTax.Code <> NULL AND emsup.xx.xx:SuperannuationRollover.DeathBenefitRecipientAgeCategory.Code = NULL
              RETURN VALIDATION MESSAGE
          ENDIF
        -->
    <assert id="VR.SS.RRT.000109" diagnostics="DVR.SS.RRT.000109"
            test="not(
                key('contextDetailsById', $thisContextId)[self::emsup.02.38:SuperannuationRollover.DeathBenefitTax.Code] and
                not(key('contextDetailsById', $thisContextId)[self::emsup.02.38:SuperannuationRollover.DeathBenefitRecipientAgeCategory.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
            )"/>

    <!-- Rule ID: VR.SS.RRT.000110
    
          WHERE IN CONTEXT SET(SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{RecFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}.{RecFundUSI}) 
          IF emsup.xx.xx:SuperannuationRollover.DeathBenefitRecipientAgeCategory.Code <> NULL AND emsup.xx.xx:SuperannuationRollover.DeathBenefitTax.Code = NULL
              RETURN VALIDATION MESSAGE
          ENDIF
        -->
    <assert id="VR.SS.RRT.000110" diagnostics="DVR.SS.RRT.000110"
            test="not(
                key('contextDetailsById', $thisContextId)[self::emsup.02.38:SuperannuationRollover.DeathBenefitRecipientAgeCategory.Code] and
                not(key('contextDetailsById', $thisContextId)[self::emsup.02.38:SuperannuationRollover.DeathBenefitTax.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
            )"/>

    <!-- 
    Variables for the rule(s) VR.SS.RRT.000111
    -->
    <let name="releaseAuthorityProductTypeCode" value="key('contextDetailsById', $thisContextId)[self::emsup.02.39:SuperannuationRollover.ReleaseAuthorityProductType.Code[not(@i:nil='true')]]" />    
    
    <!-- Rule ID: VR.SS.RRT.000111
    
          WHERE IN CONTEXT SET(SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{RecFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}.{RecFundUSI}) 
          IF esump.xx.xx:SuperannuationRollover.ReleaseAuthorityProductType.Code <> NULL
              RETURN VALIDATION MESSAGE
          ENDIF
        -->
    <assert id="VR.SS.RRT.000111" diagnostics="DVR.SS.RRT.000111"
            test="not(
            $releaseAuthorityProductTypeCode
            )"/>

    <!-- 
    Variables for the rule(s) VR.SS.RRT.000112, VR.SS.RRT.000113
    -->
    <let name="initiatorTypeCode" value="key('contextDetailsById', $thisContextId)[self::emsup.02.39:SuperannuationRollover.InitiatorType.Code[not(@i:nil='true')]]" />

    <!-- Rule ID: VR.SS.RRT.000112
    
        WHERE IN CONTEXT SET(SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{RecFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}.{RecFundUSI}) 
        IF emsup.xx.xx:SuperannuationRollover.InitiatorType.Code <> NULL AND emsup.xx.xx:SuperannuationRollover.InitiatorType.Code <> SET("IRR","EPF")
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
    <assert id="VR.SS.RRT.000112" diagnostics="DVR.SS.RRT.000112"
           test="not(
           $initiatorTypeCode and 
           $initiatorTypeCode[not(matches(.,'^(IRR|EPF)$','i'))]
            )"/>

    <!-- 
    Variables for the rule(s) VR.SS.RRT.000113
    -->    
    <let name="initiatorConversationID" value="key('contextDetailsById', $thisContextId)[self::emsup.02.39:SuperannuationRollover.InitiatorConversationID.Text[not(@i:nil='true')]]" />
    
    <!-- Rule ID: VR.SS.RRT.000113
    
        WHERE IN CONTEXT SET(SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{RecFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}.{RecFundUSI}) 
        IF (emsup.xx.xx:SuperannuationRollover.InitiatorType.Code <> NULL AND 
        emsup.xx.xx:SuperannuationRollover.InitiatorType.Code = SET("IRR","EPF") AND
        emsup.xx.xx:SuperannuationRollover.InitiatorConversationID.Text = NULL)
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
    <assert id="VR.SS.RRT.000113" diagnostics="DVR.SS.RRT.000113"
           test="not(
              $initiatorTypeCode and 
              $initiatorTypeCode[matches(.,'^(IRR|EPF)$','i')] and
              not($initiatorConversationID)  
            )"/>

    <!-- 
    Variables for the rule(s) VR.SS.RRT.000114
    -->
    <let name="initiatorPartID" value="key('contextDetailsById', $thisContextId)[self::emsup.02.39:SuperannuationRollover.InitiatorPartID.Text[not(@i:nil='true')]]" />

    <!-- Rule ID: VR.SS.RRT.000114
    
        WHERE IN CONTEXT SET(SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{RecFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}.{RecFundUSI}) 
        IF (emsup.xx.xx:SuperannuationRollover.InitiatorType.Code <> NULL AND 
        emsup.xx.xx:SuperannuationRollover.InitiatorType.Code = SET("IRR","EPF") AND
        emsup.xx.xx:SuperannuationRollover.InitiatorPartID.Text = NULL)
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
    <assert id="VR.SS.RRT.000114" diagnostics="DVR.SS.RRT.000114"
           test="not(
              $initiatorTypeCode and 
              $initiatorTypeCode[matches(.,'^(IRR|EPF)$','i')] and
              not($initiatorPartID)  
            )"/>

    <!-- 
    Variables for the rule(s) VR.SS.RRT.000115
    -->
    <let name="initiatorContextID" value="key('contextDetailsById', $thisContextId)[self::emsup.02.39:SuperannuationRollover.InitiatorContextID.Text[not(@i:nil='true')]]" />

    <!-- Rule ID: VR.SS.RRT.000115
    
        WHERE IN CONTEXT SET(SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{RecFundUSI}, SuperFundMember.{TferFundMemberID}.{TferFundABN}.{RecFundABN}.{TferFundUSI}.{RecFundUSI}) 
        IF (emsup.xx.xx:SuperannuationRollover.InitiatorType.Code <> NULL AND 
        emsup.xx.xx:SuperannuationRollover.InitiatorType.Code = SET("IRR","EPF") AND
        emsup.xx.xx:SuperannuationRollover.InitiatorContextID.Text = NULL)
            RETURN VALIDATION MESSAGE
        ENDIF
        -->
    <assert id="VR.SS.RRT.000115" diagnostics="DVR.SS.RRT.000115"
           test="not(
              $initiatorTypeCode and 
              $initiatorTypeCode[matches(.,'^(IRR|EPF)$','i')] and
              not($initiatorContextID)  
            )"/>
    
  </rule>
</pattern>
