﻿<?xml version="1.0" encoding="utf-8"?>
<pattern id="Mandatories" xmlns="http://purl.oclc.org/dsdl/schematron">
  <title>Mandatory Validations</title>

  <rule context="xbrli:xbrl[not(@i:nil='true')]">

    <!--    Rule ID: VR.SS.RRT.000040
    
            IF (RP.FUNDPAYMENT:pyin.02.00:PaymentMechanism.PaymentReferenceNumber.Identifier = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000040" diagnostics="DVR.SS.RRT.000040"
            test="not(
                      not(key('contextDetailsById', $TRANSFUND.ContextId)[self::pyin.02.00:PaymentMechanism.PaymentReferenceNumber.Identifier[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000041
    
            IF (RP.FUNDPAYMENT:pyin.02.00:PaymentRecord.Payment.Amount = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000041" diagnostics="DVR.SS.RRT.000041"
            test="not(
                      not(key('contextDetailsById', $TRANSFUND.ContextId)[self::pyin.02.00:PaymentRecord.Payment.Amount[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000047
    
            IF COUNT(MessageSender:prsnstrcnm1.02.00:PersonNameDetails) <> 1
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000047" diagnostics="DVR.SS.RRT.000047"
            test="not(
                      not(key('contextDetailsById', $SENDER.ContextId)[self::prsnstrcnm1.02.00:PersonNameDetails])
                  )"/>

    <!--    Rule ID: VR.SS.RRT.000049
    
            IF COUNT(RP.SENDER:email1.02.00:ElectronicContactElectronicMail) = 0
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000049" diagnostics="DVR.SS.RRT.000049"
            test="not(
                      not(key('contextDetailsById', $SENDER.ContextId)[self::email1.02.00:ElectronicContactElectronicMail])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000051
    
            IF COUNT(RP.SENDER:phone1.02.00:ElectronicContactTelephone) = 0
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000051" diagnostics="DVR.SS.RRT.000051"
            test="not(
                      not(key('contextDetailsById', $SENDER.ContextId)[self::phone1.02.00:ElectronicContactTelephone])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000053
    
            IF COUNT(RP.RECEIVER:orgname1.02.00:OrganisationNameDetails) = 0
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000053" diagnostics="DVR.SS.RRT.000053"
            test="not(
                      not(key('contextDetailsById', $RECEIVER.ContextId)[self::orgname1.02.00:OrganisationNameDetails])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000066
    
            IF (Count (RP.FUNDPAYMENT:fininstacc1.02.00:FinancialInstitutionAccount) = 0)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000066" diagnostics="DVR.SS.RRT.000066"
            test="not(
                      not(key('contextDetailsById', $TRANSFUND.ContextId)[self::fininstacc1.02.00:FinancialInstitutionAccount])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000067
    
            IF COUNT(RP.SENDER:orgname1.02.00:OrganisationNameDetails) = 0
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000067" diagnostics="DVR.SS.RRT.000067"
            test="not(
                      not(key('contextDetailsById', $SENDER.ContextId)[self::orgname1.02.00:OrganisationNameDetails])
                  )"/>

  </rule>

  <rule context="address3.02.01:AddressDetails[not(@i:nil='true')]">
    <let name="tupleContextId" value="*[1]/@contextRef" />

    <!--    Rule ID: VR.SS.GEN.000026
    
            WHERE IN TUPLE (address3.02.01:AddressDetails)
            IF (AddressDetails.Usage.Code = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000026" diagnostics="DVR.SS.GEN.000026"
            test="not(
                      not(pyde.02.01:AddressDetails.Usage.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>


    <!--    Rule ID: VR.SS.GEN.000028
    
            WHERE IN TUPLE (address3.02.01:AddressDetails)
            IF (AddressDetails.Line1.Text = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000028" diagnostics="DVR.SS.GEN.000028"
            test="not(
                      not(pyde.02.00:AddressDetails.Line1.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>


    <!--    Rule ID: VR.SS.GEN.000029
    
            WHERE IN TUPLE (address3.02.01:AddressDetails)
            IF (AddressDetails.LocalityName.Text = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000029" diagnostics="DVR.SS.GEN.000029"
            test="not(
                      not(pyde.02.00:AddressDetails.LocalityName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>


    <!--    Rule ID: VR.SS.GEN.000032
    
            WHERE IN TUPLE (address3.02.01:AddressDetails)
            IF (AddressDetails.Country.Code = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000032" diagnostics="DVR.SS.GEN.000032"
            test="not(
                      not(pyde.02.08:AddressDetails.Country.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>

  </rule>

  <rule context="orgname1.02.00:OrganisationNameDetails[not(@i:nil='true')]">
    <let name="tupleContextId" value="*[1]/@contextRef" />

    <!--    Rule ID: VR.SS.GEN.000006
    
            WHERE IN TUPLE(orgname1.02.00:OrganisationNameDetails)
            IF (OrganisationNameDetails.OrganisationalNameType.Code = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            ENDIF
        -->
    <assert id="VR.SS.GEN.000006" diagnostics="DVR.SS.GEN.000006"
            test="not(
                      not(pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>


    <!--    Rule ID: VR.SS.GEN.000008
    
            WHERE IN TUPLE(orgname1.02.00:OrganisationNameDetails)
            IF (OrganisationNameDetails.OrganisationalName.Text = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            ENDIF
        -->
    <assert id="VR.SS.GEN.000008" diagnostics="DVR.SS.GEN.000008"
            test="not(
                      not(pyde.02.00:OrganisationNameDetails.OrganisationalName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>

  </rule>

  <rule context="prsnstrcnm1.02.00:PersonNameDetails[not(@i:nil='true')]">
    <let name="tupleContextId" value="*[1]/@contextRef" />

    <!--    Rule ID: VR.SS.GEN.000010
            SuperFundMember
            WHERE IN TUPLE(prsnstrcnm1.02.00:PersonNameDetails)
            IF (PersonNameDetails.FamilyName.Text = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000010" diagnostics="DVR.SS.GEN.000010"
            test="not(
                      $tupleContextId = $MEMROLTRANS.ContextId
                      and
                      not(pyde.02.00:PersonNameDetails.FamilyName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>

    <!--    Rule ID: VR.SS.GEN.000011
            SuperFundMember
            WHERE IN TUPLE(prsnstrcnm1.02.00:PersonNameDetails)
            IF (PersonNameDetails.GivenName.Text = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000011" diagnostics="DVR.SS.GEN.000011"
            test="not(
                      $tupleContextId = $MEMROLTRANS.ContextId
                      and
                      not(pyde.02.00:PersonNameDetails.GivenName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>

    <!--    Rule ID: VR.SS.RRT.000107
            MessageSender
            WHERE IN TUPLE([SPRROL3])
            IF [SPRROL202] = NULLORBLANK
               RETURN VALIDATION MESSAGE
            ENDIF
    -->
    <assert id="VR.SS.RRT.000107" diagnostics="DVR.SS.RRT.000107"
            test="not(
                      $tupleContextId = $SENDER.ContextId
                      and
                      not(pyde.02.00:PersonNameDetails.FamilyName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000108
            MessageSender
            WHERE IN TUPLE([SPRROL3])
                IF [SPRROL203] = NULLORBLANK
                   RETURN VALIDATION MESSAGE
            ENDIF
        -->
    <assert id="VR.SS.RRT.000108" diagnostics="DVR.SS.RRT.000108"
            test="not(
                      $tupleContextId = $SENDER.ContextId
                      and
                      not(pyde.02.00:PersonNameDetails.GivenName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>
  </rule>

  <rule context="email1.02.00:ElectronicContactElectronicMail[not(@i:nil='true')]">
    <let name="tupleContextId" value="*[1]/@contextRef" />

    <!--    Rule ID: VR.SS.GEN.000013
    
            WHERE IN TUPLE(email1.02.00:ElectronicContactElectronicMail)
            IF (ElectronicContact.ElectronicMail.Usage.Code = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000013" diagnostics="DVR.SS.GEN.000013"
            test="not(
                      not(pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>


    <!--    Rule ID: VR.SS.GEN.000015
    
            WHERE IN TUPLE(email1.02.00:ElectronicContactElectronicMail)
            IF (ElectronicContact.ElectronicMail.Address.Text = NULLORBLANK)
               RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000015" diagnostics="DVR.SS.GEN.000015"
            test="not(
                      not(pyde.02.00:ElectronicContact.ElectronicMail.Address.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>
  </rule>

  <rule context="phone1.02.00:ElectronicContactTelephone[not(@i:nil='true')]">
    <let name="tupleContextId" value="*[1]/@contextRef" />

    <!--    Rule ID: VR.SS.GEN.000017
    
            WHERE IN TUPLE(phone1.02.00:ElectronicContactTelephone)
            IF (ElectronicContact.Telephone.Usage.Code = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000017" diagnostics="DVR.SS.GEN.000017"
            test="not(
                      not(pyde.02.00:ElectronicContact.Telephone.Usage.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>


    <!--    Rule ID: VR.SS.GEN.000019
    
            WHERE IN TUPLE(phone1.02.00:ElectronicContactTelephone)
            IF (ElectronicContact.Telephone.ServiceLine.Code = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000019" diagnostics="DVR.SS.GEN.000019"
            test="not(
                      not(pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>


    <!--    Rule ID: VR.SS.GEN.000020
    
            WHERE IN TUPLE (phone1.02.00:ElectronicContactTelephone)
            IF (ElectronicContact.Telephone.Minimal.Number = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.GEN.000020" diagnostics="DVR.SS.GEN.000020"
            test="not(
                      not(pyde.02.00:ElectronicContact.Telephone.Minimal.Number[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>

  </rule>

  <rule context="sprrol.0003.rollovertrans.req.02.00:SuperannuationRolloverOtherDetails[not(@i:nil='true')]">
    <let name="tupleContextId" value="*[1]/@contextRef" />

    <!--    Rule ID: VR.SS.RRT.000100
    
            IF (emsup.02.23:SuperannuationRollover.OtherDetails.Text IN TUPLE(SuperannuationRolloverOtherDetails)) = NULLORBLANK
               RETURN VALIDATION MESSAGE
            ENDIF
        -->
    <assert id="VR.SS.RRT.000100" diagnostics="DVR.SS.RRT.000100"
            test="not(
                      not(emsup.02.23:SuperannuationRollover.OtherDetails.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000101
    
            IF (emsup.02.23:SuperannuationRollover.OtherDetails.Description  IN TUPLE(SuperannuationRolloverOtherDetails))= NULLORBLANK
               RETURN VALIDATION MESSAGE
            ENDIF
        -->
    <assert id="VR.SS.RRT.000101" diagnostics="DVR.SS.RRT.000101"
            test="not(
                      not(emsup.02.23:SuperannuationRollover.OtherDetails.Description[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>

  </rule>

  <rule context="fininstacc1.02.00:FinancialInstitutionAccount[not(@i:nil='true')]">

    <!--    Rule ID: VR.SS.RRT.000063
    
            WHERE IN TUPLE (fininstacc1.02.00:FinancialInstitutionAccount)
            IF (FinancialInstitutionAccount.BankStateBranch.Number = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000063" diagnostics="DVR.SS.RRT.000063"
            test="not(
                      not(pyid.02.00:FinancialInstitutionAccount.BankStateBranch.Number[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000064
    
            WHERE IN TUPLE (fininstacc1.02.00:FinancialInstitutionAccount)
            IF (pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccount.Number = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000064" diagnostics="DVR.SS.RRT.000064"
            test="not(
                      not(pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccount.Number[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000065
    
            WHERE IN TUPLE (fininstacc1.02.00:FinancialInstitutionAccount)
            IF (pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccountName.Text = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000065" diagnostics="DVR.SS.RRT.000065"
            test="not(
                      not(pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccountName.Text[not(@i:nil='true') and string-length(normalize-space(.)) != 0])
                  )"/>

  </rule>

  <rule context="xbrli:xbrl[not(@i:nil='true')]/xbrli:context[exists($MEMROLTRANS.Context[generate-id() = generate-id(current())])]">
    <let name="thisContextId" value="@id" />

    <!--    Rule ID: VR.SS.RRT.000012
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF (PersonDemographicDetails.Sex.Code = NULLORBLANK)
               RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000012" diagnostics="DVR.SS.RRT.000012"
            test="not(
                      not(key('contextDetailsById', $thisContextId)[self::pyde.02.18:PersonDemographicDetails.Sex.Code[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000013
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF (PersonDemographicDetails.Birth.Date = NULLORBLANK)
               RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000013" diagnostics="DVR.SS.RRT.000013"
            test="not(
                      not(key('contextDetailsById', $thisContextId)[self::pyde.02.00:PersonDemographicDetails.Birth.Date[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000015
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF (emsup.02.08:SuperannuationFundDetails.EligibleServicePeriodStart.Date = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000015" diagnostics="DVR.SS.RRT.000015"
            test="not(
                      not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationFundDetails.EligibleServicePeriodStart.Date[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000016
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF (rvctc2.02.10:IncomeTax.Superannuation.TaxFreeComponent.Amount = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000016" diagnostics="DVR.SS.RRT.000016"
            test="not(
                      not(key('contextDetailsById', $thisContextId)[self::rvctc2.02.10:IncomeTax.Superannuation.TaxFreeComponent.Amount[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000017
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF (rvctc2.02.00:IncomeTax.Superannuation.TaxableComponentTaxedElement.Amount = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000017" diagnostics="DVR.SS.RRT.000017"
            test="not(
                      not(key('contextDetailsById', $thisContextId)[self::rvctc2.02.00:IncomeTax.Superannuation.TaxableComponentTaxedElement.Amount[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000018
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF (rvctc2.02.00:IncomeTax.Superannuation.TaxableComponentUntaxedElement.Amount = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000018" diagnostics="DVR.SS.RRT.000018"
            test="not(
                      not(key('contextDetailsById', $thisContextId)[self::rvctc2.02.00:IncomeTax.Superannuation.TaxableComponentUntaxedElement.Amount[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000019
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF (emsup.02.08:SuperannuationRollover.BenefitComponentsPreserved.Amount = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000019" diagnostics="DVR.SS.RRT.000019"
            test="not(
                      not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.BenefitComponentsPreserved.Amount[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000020
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF (emsup.02.08:SuperannuationRollover.BenefitComponentsUnrestricted.Amount = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000020" diagnostics="DVR.SS.RRT.000020"
            test="not(
                      not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.BenefitComponentsUnrestricted.Amount[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000021
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF (emsup.02.08:SuperannuationRollover.BenefitComponentsRestricted.Amount = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000021" diagnostics="DVR.SS.RRT.000021"
            test="not(
                      not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.BenefitComponentsRestricted.Amount[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000036
    
            FOR ANY OCCURRENCE OF CONTEXT (SuperFundMember.Any.Any.Any)
            IF (emsup.02.08:SuperannuationRollover.TransferWholeBalance.Indicator = NULLORBLANK)
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000036" diagnostics="DVR.SS.RRT.000036"
            test="not(
                      not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationRollover.TransferWholeBalance.Indicator[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000055
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF COUNT(prsnstrcnm1.02.00:PersonNameDetails) = 0
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000055" diagnostics="DVR.SS.RRT.000055"
            test="not(
                      not(key('contextDetailsById', $thisContextId)[self::prsnstrcnm1.02.00:PersonNameDetails])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000057
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF COUNT(address3.02.01:AddressDetails) = 0
                RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000057" diagnostics="DVR.SS.RRT.000057"
            test="not(
                      not(key('contextDetailsById', $thisContextId)[self::address3.02.01:AddressDetails])
                  )"/>


    <!--    Rule ID: VR.SS.RRT.000059
    
            FOR ANY OCCURRENCE OF CONTEXT (RP.MEMBERROLLOVERTRANSACTION)
            IF (pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator = NULLORBLANK)
               RETURN VALIDATION MESSAGE
            END IF
        -->
    <assert id="VR.SS.RRT.000059" diagnostics="DVR.SS.RRT.000059"
            test="not(
                      not(key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[not(@i:nil='true') and string-length(normalize-space(.)) != 0]])
                  )"/>

  </rule>


</pattern>
