<!-- 
	Copied from ISO_SVRL.xsl in order to create a very very simple html output.  Hoping to grab a better one
	if the ATO internet starts working again so i can find one...

	Derived from Conformance1-5.xsl.

	Copyright (c) 2001, 2006 Rick Jelliffe and Academia Sinica Computing Center, Taiwan
-->

<!-- The command-line parameters are:
	phase           NMTOKEN | "#ALL" (default) Select the phase for validation
	allow-foreign   "true" | "false" (default)   Pass non-Schematron elements to the generated stylesheet
	diagnose= true | false|yes|no    Add the diagnostics to the assertion test in reports (yes|no are obsolete)
	generate-paths=true|false|yes|no   generate the @location attribute with XPaths (yes|no are obsolete)
	sch.exslt.imports semi-colon delimited string of filenames for some EXSLT implementations          
	optimize        "visit-no-attributes"     Use only when the schema has no attributes as the context nodes
	generate-fired-rule "true"(default) | "false"  Generate fired-rule elements
-->

<xsl:stylesheet
	version="2.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:axsl="http://www.w3.org/1999/XSL/TransformAlias"
	xmlns:isns="http://www.ato.gov.au/IS/2009/02"
	xmlns:i="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:tns="http://sbr.gov.au/comn/event.02.data"
    xmlns:sbdm="http://sbr.gov.au/comn/sbdm.02.data">


    <xsl:template match="/EBMS_ProcessMessages">
        <tns:Event xmlns="http://www.ato.gov.au/IS/2009/02">
            <!--<xsl:apply-templates select ="EBMS_MaximumSeverity"/>-->
            <xsl:apply-templates select ="EBMS_ProcessMessage"/>
        </tns:Event>
    </xsl:template>

    <xsl:template  match ="EBMS_ProcessMessage">
        <tns:MaximumSeverity.Code/>
        <tns:EventItems xmlns="http://www.ato.gov.au/IS/2009/02">
                <tns:EventItem>
                    <tns:Error.Code>
                        <xsl:value-of select="ErrorCode/text()" />
                    </tns:Error.Code>
                    <xsl:choose>
                        <xsl:when test="string-length( Severity/text() ) &gt; 0">
                            <tns:Severity.Code>
                                <xsl:value-of select="Severity/text()" />
                            </tns:Severity.Code>
                        </xsl:when>
                        <xsl:otherwise>
                            <tns:Severity.Code>Error</tns:Severity.Code>
                        </xsl:otherwise>
                    </xsl:choose>

                    <xsl:if test="string-length(Description/text()) &gt; 0">
                        <tns:Short.Description>
                            <xsl:value-of select="Description/text()" />
                        </tns:Short.Description>
                    </xsl:if>

                    <xsl:if test="string-length(LongDescription/text()) &gt; 0">
                        <tns:Detailed.Description>
                            <xsl:value-of select="LongDescription/text()" />
                        </tns:Detailed.Description>
                    </xsl:if>

                    <xsl:if test="count(Parameters) = 1">
                        <tns:Parameters>
                            <xsl:for-each select="Parameters/Parameter">
                                <tns:Parameter>
                                    <tns:Parameter.Identifier>
                                        <xsl:value-of select="Name/text()" />
                                    </tns:Parameter.Identifier>
                                    <tns:Parameter.Text>
                                        <xsl:copy-of select ="Value/node()"/>
                                    </tns:Parameter.Text>
                                </tns:Parameter>
                            </xsl:for-each>
                            <tns:Parameter>
                                <tns:Parameter.Identifier>RuleIdentifier</tns:Parameter.Identifier>
                                <tns:Parameter.Text>
                                    <!-- The $id is the DVR id in the diagnostics sch file. Strip out the D to leave the VR. -->
                                    <!-- Eg: DVR.SS.RIR.000001 -> VR.SS.RIR.000001 -->
                                    <!--<xsl:value-of select="substring($id, 2, string-length($id))" />-->
                                </tns:Parameter.Text>
                            </tns:Parameter>
                        </tns:Parameters>
                    </xsl:if>

                    <tns:Locations>
                        <tns:Location>
                            <tns:Location.Instance.Identifier/>
                            <tns:Location.Path.Text>
                                <xsl:value-of select="Location/text()" />
                            </tns:Location.Path.Text>
                        </tns:Location>
                    </tns:Locations>
                </tns:EventItem>
        </tns:EventItems>
    </xsl:template>

</xsl:stylesheet>