#ifndef __ATO_AKM_KS_PRIVATE_H__
#define __ATO_AKM_KS_PRIVATE_H__

#include <stddef.h>

#include "atoakm/keystore.h"

#ifdef __cplusplus
extern "C" {
#endif

/** @internal
This method is subject to change.

@param ctx the current thread local Context.
@param ks the keystore.
@param obj the new credential which is not usable until a request is completed and saved.
@param pwd the password of the keystore.
@param abn
@param name1 GivenNames or DeviceName (alphanum only if DeviceName).
@param name2 FamilyName or blank if device
@param pid PersonId or blank if device

@return ATO_ERR_OK(0) if successful, otherwise
- ATO_AKM_ERR_ALIASEXISTS if isreplacable is FALSE and credential alias already exists in the destination store
- ATO_AKM_ERR_BADPWD if the source credential password is wrong
- ATO_AKM_ERR_PWDDEST if the destination store password is wrong
- ATO_AKM_ERR_PWDPOLICY if this is a new password that doesn't meet strength requirements
*/
ATO_AKM_EXPORT int ato_ks_newcredential(ato_Ctx *ctx, ato_Keystore *ks, ato_Credential **obj, const char *pwd, const char *abn, const char *name1, const char *name2, const char *pid);

ATO_AKM_EXPORT void atoe_ks_create(ato_Ctx *ctx, ato_Keystore **obj, const char *buffer, const ato_ksProperties *properties);
ATO_AKM_EXPORT void atoe_ks_checkcorrectpwd(ato_Ctx *ctx, ato_Keystore *ks, const char *pwd);
ATO_AKM_EXPORT void atoe_ks_changepwd(ato_Ctx *ctx, ato_Keystore *ks, const char *pwd, const char *newpwd);
ATO_AKM_EXPORT void atoe_ks_save(ato_Ctx *ctx, ato_Keystore *ks, char **buffer);
ATO_AKM_EXPORT void atoe_ks_newcredential(ato_Ctx *ctx, ato_Keystore *ks, ato_Credential **obj, const char *pwd, const char *abn, const char *name1, const char *name2, const char *pid);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_AKM_KS_PRIVATE_H__*/
