#ifndef __ATO_AKM_RENEW_INTERNAL_H__
#define __ATO_AKM_RENEW_INTERNAL_H__

#ifndef ATO_AKM_INTERNAL
#error "This file is for internal use only"
#endif

typedef struct _ato_Crr ato_Crr;

#ifdef __cplusplus
extern "C" {
#endif

extern int ato__crr_init(void);
extern void ato__crr_deinit(void);

extern void ato__crr_create(ato_Ctx *ctx, ato_Crr **obj, ato_ksProperties *ksprop, const char *id, const char *type, ato_Crypto *crypto);
extern void ato__crr_createnew(ato_Ctx *ctx, ato_Crr **obj, ato_ksProperties *ksprop, const char *id, const char *type, const char *abn, const char *name1, const char *name2, const char *pid);
extern void *ato__crr_free(ato_Crr *crr);

// do not free ato_String
extern ato_String *ato__crr_renew_generate(ato_Ctx *ctx, ato_Crr *crr, ato_PwdKdf *pk);
extern const char *ato__crr_renew_send(ato_Ctx *ctx, ato_Crr *crr);
// if response is NULL use the ato__crr_renew_send() generated response held internally
extern void ato__crr_renew_process(ato_Ctx *ctx, ato_Crr *crr, const char *response);
// calls _generate, _send, _process in one go
extern void ato__crr_renew(ato_Ctx *ctx, ato_Crr *crr, ato_PwdKdf *pk);

extern const char *ato__crr_name1(ato_Crr *crr);
extern const char *ato__crr_name2(ato_Crr *crr);
extern const char *ato__crr_abn(ato_Crr *crr);
extern const char *ato__crr_fingerprint(ato_Crr *crr);
extern const char *ato__crr_legalName(ato_Crr *crr);
extern const char *ato__crr_creationDate(ato_Crr *crr);
// Retrieves crypto object and transfers responsible for freeing to caller if this is called at least once.
extern ato_Crypto *ato__crr_crypto_asowner(ato_Crr *crr);
extern const char *ato__crr_pbemode(ato_Crr *crr);

// not valid until ato__crr_renew_generate() called
extern ato_String *ato__crr_requestdata(ato_Crr *crr);
extern ato_String *ato__crr_b64p10(ato_Crr *crr);

extern ato_String *ato__crr_salt(ato_Crr *crr);
extern ato_String *ato__crr_p8(ato_Crr *crr);
extern const char *ato__crr_requestid(ato_Crr *crr);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_AKM_RENEW_INTERNAL_H__*/
