#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <assert.h>
#include <stdarg.h>

#include "atobase/all.h"

#include "../common/log.h"

#define _TIMESTAMP_LEN 50
static const char *_timestamp(char *buffer)
{
    struct tm *time_now;
    time_t secs_now;
    time(&secs_now);
    time_now = localtime(&secs_now);
    strftime(buffer, _TIMESTAMP_LEN, "%Y%m%d-%H%M%S", time_now);
    return buffer;
}

bool verysimplelogger(ato_Log *log, ato_eLoglevel loglevel, ato_eLogState logstate, const char *library, const char *module, const char *function, const char *format, va_list args)
{
    vfprintf(stdout, format, args);
    fprintf(stdout, "\n");

    //suppress compiler warnings
    ATO_IGNORE(log);
    ATO_IGNORE(loglevel);
    ATO_IGNORE(logstate);
    ATO_IGNORE(library);
    ATO_IGNORE(module);
    ATO_IGNORE(function);
    return TRUE;
}

bool customlogger(ato_Log *log, ato_eLoglevel loglevel, ato_eLogState logstate, const char *library, const char *module, const char *function, const char *format, va_list args)
{
    FILE *fp = NULL;

    if (log == NULL)
        return FALSE;

    switch (ato_log_outputtype(log)) {
        case ATO_LOG_OUTPUTTYPE_STDOUT:
            fp = stdout;
            break;
        case ATO_LOG_OUTPUTTYPE_STDERR:
            fp = stderr;
            break;
        case ATO_LOG_OUTPUTTYPE_PATH:
            {
            //const char *filepath = ato_log_upath(log); // use this if app is multi-threaded
            const char *filepath = ato_log_path(log);
            if (filepath != NULL && (filepath)[0] != '\0')
                fp = fopen(filepath, "a+t");
            }
            break;
        case ATO_LOG_OUTPUTTYPE_NONE:
        default:
            return FALSE;
    }

    if (fp == NULL)
        return FALSE;

    {
    char buffer[_TIMESTAMP_LEN+1];
    fprintf(fp, "%s: ", _timestamp(buffer));
    }

    {
    size_t len = 0;
    size_t indentlen = ato_log_indentsize(log) * ato_log_indentlevel(log);
    for (len = 0; len < indentlen; len++)
        fprintf(fp, " ");
    }

    if (logstate == ATO_LOGSTATE_OPEN)
        fprintf(fp, "+");
    else if (logstate == ATO_LOGSTATE_CLOSE)
        fprintf(fp, "-");
    else
        fprintf(fp, ".");

    fprintf(fp, "%c ", (char)toupper((int)(ato_log_level2name(loglevel)[0])));

    if (logstate == ATO_LOGSTATE_OPEN || logstate == ATO_LOGSTATE_CLOSE)
        fprintf(fp, "%s.%s.%s ", library, module, function);

    fprintf(fp, "[");
    vfprintf(fp, format, args);
    fprintf(fp, "]");

    fprintf(fp, "\n");

    if (ato_log_outputtype(log) == 'p' && fp != NULL)
        fclose(fp);

    return TRUE;
}

/*********************************************************************************/
