#ifndef __ATO_ARG_H__
#define __ATO_ARG_H__

/** @addtogroup atobase_api_public_arg

@{
*/

#ifdef __cplusplus
extern "C" {
#endif

//ATO_EXPORT int ato_arg_init(void);

/**
Add a new argument/property.
@param name the name of the property
@param required when checking indicate if this property must have a value supplied.
@param defvalue value to use if not set.
@param allowedvalues comma delimited list of predefined values
@param help help string to display if asked
*/

ATO_EXPORT void ato_arg_add(const char *name, bool required, const char *defvalue, const char *allowedvalues, const char *help);

/**
Add the standard C args as properties.
@param argc the number of args
@param argv array of args prefixed with - or @@ (@@ starts reading from argfile e.g. @@argfile).

@return TRUE if no errors in loading args
*/
ATO_EXPORT bool ato_arg_process(int argc, const char *argv[]);

/**
Write all properties to the console
*/
ATO_EXPORT void ato_arg_dump(void);

/**
Print usage/help for known properties to the Console.
@param appname the name of the calling program
*/
ATO_EXPORT void ato_arg_usage(const char *appname);

/**
Check that all args/properties are valid.

@return TRUE if all args have valid values
*/
ATO_EXPORT bool ato_arg_check(void);

/**
Reset the value of the property
@param name the name of property
@param value the va;ue of property

@return property value or NULL if not found
*/
ATO_EXPORT const char *ato_arg_value_set(const char *name, const char *value);
/**
Get the property value
@param name the name of property

@return The property value or NULL if not found
*/
ATO_EXPORT const char *ato_arg_value(const char *name);
/**
Get the property value
@param name the name of property
* 
@return The property value as a bool or FALSE
*/
ATO_EXPORT bool ato_arg_value_bool(const char *name);
/**
Get the property value as an in
@param name the name of property

@return The property value as an int or 0
*/
ATO_EXPORT int ato_arg_value_int(const char *name);

/**
Free all properties set using ato_arg_add()
*/
ATO_EXPORT void ato_arg_free(void);

#ifdef __cplusplus
}
#endif

/*! @} */

#endif /*__ATO_ARG_H__*/
