#ifndef __ATO_ERRH_H__
#define __ATO_ERRH_H__

/** @addtogroup atobase_api_public_errh

@{
*/

#ifdef __cplusplus
extern "C" {
#endif

/**
Invoke the error handler for any errors in the Context.

Each SDK has its own handler to handle custom error objects the SDK may produce.

The error handler interprets the error and calls the logging function.

The default logging function can be replaced by the application - see ato_log_setlogfn().

@param ctx the thread local context containing 0 or more (nested) @ref ato_Err objects.
@param errcode the error code of the top level error object. If this does not match, it indicates
a coding error has occurred which will result in an assertion failure.

@return TRUE if the error was processed (i.e. logged) or FALSE otherwise.
*/
ATO_EXPORT bool ato_errh_handler(ato_Ctx *ctx, int errcode);

#ifdef __cplusplus
}
#endif

/*! @} */

#endif /*__ATO_ERRH_H__*/

