#ifndef __ATO_LIB_H__
#define __ATO_LIB_H__

/** @addtogroup atobase_api_public_lib

@{
*/

#ifdef __cplusplus
extern "C" {
#endif

/**
Return the version of the ATO Base API.
@return version in the form major.minor.patch.tweak (not all levels may be present)
*/
ATO_EXPORT const char *ato_base_version(void);

/**
Returns whether or not the ato base library is initialised.

@return TRUE or FALSE.
*/
ATO_EXPORT bool ato_base_isinited(void);

/**
Initialise the SDK - see also ato_base_deinit().

This must be called at application startup prior to any threads being started,
and before any other initialisation routines but AFTER the first main context
object is created using ato_ctx_create() AND AFTER the softwareinfo object has been
set using ato_si_set().

Subsequent calls to this are ignored.

@param ctx the main context object for associated error information if any.
@param flag used to control the initialisation process - use ATO_BASE_INIT_ALL unless advised otherwise.

@return ATO_ERR_OK or an error code - see ato_ctx_err() for any error details
*/
ATO_EXPORT int ato_base_init(ato_Ctx *ctx, unsigned short flag);

/**
Deinitialise the SDK. This must be called at application shutdown after threads are finished and
any allocated objects freed.

Subsequent calls to this are ignored.

ato_base_deinit() should be called after all other deinitialisation routines are called.
*/
ATO_EXPORT void ato_base_deinit(void);

#ifdef __cplusplus
}
#endif

/*! @} */

#endif /*__ATO_LIB_H__*/
