#ifndef __ATO_LIB_PRIVATE_H__
#define __ATO_LIB_PRIVATE_H__

#include "atobase/lib.h"

#ifdef __cplusplus
extern "C" {
#endif

ATO_EXPORT void ato_base_var_set(const char *name, const char *value);
ATO_EXPORT bool ato_base_var(const char *name, const char **value);

#ifdef __cplusplus
}
#endif

#define ATO_FN_TRACESTART() \
    (ato_log_start(log, ATO_LOG_TRACE, _loglevel, _library, _module, function, ""))
#define ATO_FN_TRACEEND()   \
    { \
    ATO_CTX_ERR_CHECK(ctx, errcode); \
    if (errcode != ATO_ERR_OK) ato_ctx_log(ctx); \
    ato_log_end(log, ATO_LOG_TRACE, _loglevel, _library, _module, function, errcode != 0, ""); \
    }

#endif /*__ATO_LIB_PRIVATE_H__*/
