#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <time.h>
#include <stdarg.h>
#if !defined(WIN32)
#include <stdint.h>
#else
#include <Windows.h>
#include <WinCrypt.h> /* X509_NAME defined here. It is explicitly undefined in openssl/x509.h for WIN32. */
#endif

#define OPENSSL_THREAD_DEFINES
#include "openssl/opensslconf.h"

#include "openssl/err.h"
#include "openssl/x509.h"
#include "openssl/x509v3.h"
#include "openssl/conf.h"
#include "openssl/bio.h"
#include "openssl/ssl.h"
#include "openssl/err.h"
#include "openssl/pem.h"
#include "openssl/evp.h"
#include "openssl/pkcs12.h"
#include "openssl/rand.h"
#include "openssl/hmac.h"
#include "openssl/cms.h"
#include "openssl/crypto.h"

#include "atointernal.h"
#include "atotypes.h"

#include "atobcshim.h"

//#define MGID_FORCE_OPENSSL10 1

/*********************************************************************************/
void bcshim_init(void) {
#if OPENSSL_VERSION_NUMBER < 0x10100000L
    SSL_library_init();
    SSL_load_error_strings();
    ERR_load_BIO_strings();
    OpenSSL_add_all_algorithms();
#else
    //https://www.openssl.org/docs/man1.1.0/crypto/OPENSSL_init_crypto.html
#endif
}

void bcshim_deinit(void) {
#if OPENSSL_VERSION_NUMBER < 0x10100000L
    ERR_clear_error();
    ERR_remove_thread_state(NULL);
    ERR_free_strings();
    RAND_cleanup();
    EVP_cleanup();
    OBJ_cleanup();
    X509V3_EXT_cleanup();
    CONF_modules_finish();
    CONF_modules_free();
    CONF_modules_unload(1);
    CRYPTO_cleanup_all_ex_data();
    OPENSSL_free(NULL);
#else
    //https://wiki.openssl.org/index.php/Library_Initialization#Cleanup
#endif
}

int bcshim_X509_SIG_get_nid(X509_SIG *sig) {
    const X509_ALGOR *alg = NULL;
#if OPENSSL_VERSION_NUMBER < 0x10100000L
    alg = sig->algor;
#else
    //ASN_OCTET_STRING *pdigest = NULL;
    X509_SIG_get0(sig, &alg, NULL);
#endif
    return OBJ_obj2nid(alg->algorithm);
}

X509_SIG *bcshim_PKCS8_encrypt_pbe2(int prf_nid, const EVP_CIPHER *cipher, const char *pass, int passlen, unsigned char *salt, int saltlen, int iter, PKCS8_PRIV_KEY_INFO *p8) {
#if OPENSSL_VERSION_NUMBER < 0x10100000L
    X509_SIG *sig = X509_SIG_new();
    X509_ALGOR *pbe = NULL;
    //if(EVP_PBE_find(EVP_PBE_TYPE_PRF, prf_nid, NULL, NULL, 0)) {
    pbe = PKCS5_pbe2_set_iv(cipher, iter, salt, saltlen, NULL, prf_nid);
    //}

    X509_ALGOR_free(sig->algor);
    sig->algor = pbe;
    M_ASN1_OCTET_STRING_free(sig->digest); // 1.0
    //ASN1_OCTET_STRING_free(sig->digest); // 1.1
    sig->digest = PKCS12_item_i2d_encrypt(pbe, ASN1_ITEM_rptr(PKCS8_PRIV_KEY_INFO), pass, passlen, p8, 1);

    return sig;
#else
    //X509_SIG *sig = X509_SIG_new();
    //X509_ALGOR *alg = NULL;
    //ASN1_OCTET_STRING *digest = NULL;
    //X509_ALGOR *pbe_alg = NULL;
    //ASN1_OCTET_STRING *pbe_digest = NULL;

    //X509_SIG_getm(sig, &alg, &digest);

    ////if (alg != NULL) X509_ALGOR_free(alg);
    ////if (digest != NULL) ASN1_OCTET_STRING_free(digest);

    //pbe_alg = PKCS5_pbe2_set_iv(cipher, iter, salt, saltlen, NULL, prf_nid);
    //pbe_digest = PKCS12_item_i2d_encrypt(pbe_alg, ASN1_ITEM_rptr(PKCS8_PRIV_KEY_INFO), pass, passlen, p8, 1);
    //X509_ALGOR_set0(alg, pbe_alg, V_ASN1_NULL, NULL);
    //ASN1_STRING_set(digest, pbe_digest, -1);

    //return sig;

    ATO_IGNORE(prf_nid);
    ATO_IGNORE(cipher);
    ATO_IGNORE(pass);
    ATO_IGNORE(passlen);
    ATO_IGNORE(salt);
    ATO_IGNORE(saltlen);
    ATO_IGNORE(iter);
    ATO_IGNORE(p8);
    return NULL;
#endif
}
