/*
This file is for documentation purposes only.
*/

/*! @defgroup atobase_api_public_si SoftwareInfo
@ingroup atobase_api_public

@brief
The global software information.
*/

/*! @defgroup atobase_api_public_types Types
@ingroup atobase_api_public

@brief
General types used across the ATO BASE API.
*/

/*! @defgroup atobase_api_public_lib Library
@ingroup atobase_api_public

@brief
General (miscellaneous) library API.
*/

/*! @defgroup atobase_api_public_ctx Context
@ingroup atobase_api_public

@brief
Query the current thread local context.
*/

/*! @defgroup atobase_api_public_err Errors
@ingroup atobase_api_public

@brief
Error API - for codes see @ref atobase_api_public_types_errcodes.
*/

/*! @defgroup atobase_api_public_errgen General Error
@ingroup atobase_api_public_err

@brief
Query ato_Error objects.
*/

/*! @defgroup atobase_api_public_errsoap SOAP Error
@ingroup atobase_api_public_err

@brief
Query ato_ErrSoap objects.
*/

/*! @defgroup atobase_api_public_errh Error Handler
@ingroup atobase_api_public_err

@brief
Handle any errors that an SDK may produce.
*/

/*! @defgroup atobase_api_public_log Log
@ingroup atobase_api_public

@brief
Logging API.
*/

/*! @defgroup atobase_api_public_str String
@ingroup atobase_api_public

@brief
Create and manage "string" objects that encapsulate non-const and const char arrays with explicit length.
*/

/*! @defgroup atobase_api_public_iter Iterator
@ingroup atobase_api_public

@brief
Use iterators returned by various SDK APIs.
*/

/*! @defgroup atobase_api_public_arg Args
@ingroup atobase_api_public

@brief
API used by sample programs (and internally) to track arbitrary properties.
*/
