#ifndef __ATO_BNET_PRIVATE_H__
#define __ATO_BNET_PRIVATE_H__

#include "atobnet/bnet.h"

typedef struct _ato_Net ato_Net;

#ifdef __cplusplus
extern "C" {
#endif

ATO_BNET_EXPORT size_t ato_bnet_settimeout(ato_Net *net, size_t timeout);
ATO_BNET_EXPORT size_t ato_bnet_settimeoutconnect(ato_Net *net, size_t timeout);
ATO_BNET_EXPORT size_t ato_bnet_timeout(ato_Net *net);
ATO_BNET_EXPORT size_t ato_bnet_timeoutconnect(ato_Net *net);

ATO_BNET_EXPORT void ato_bnet_create(ato_Ctx *ctx, ato_Net **net, const char *url, const char *contenttype);
ATO_BNET_EXPORT void ato_bnet_free(ato_Net *net);
ATO_BNET_EXPORT void ato_bnet_setproxy(ato_Net *net, const char *url, const char *userpwd, const char *excludehosts);
ATO_BNET_EXPORT ato_NetData *ato_bnet_request(ato_Ctx *ctx, ato_Net *net, ato_String *data);
ATO_BNET_EXPORT ato_NetData *ato_bnet_requestmp(ato_Ctx *ctx, ato_Net *net, ato_NetData *netdata);

ATO_BNET_EXPORT size_t ato_bnet_timeout_default(ato_Ctx *ctx);
ATO_BNET_EXPORT size_t ato_bnet_timeoutconnect_default(ato_Ctx *ctx);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_BNET_PRIVATE_H__*/
