/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup atobnet_overview_designnotes

The SDK itself is memory-based. That is, loading data into and saving data from, the SDK is via
memory buffers. In particular, some of the behaviour is driven by configuration settings and it is
up to the application to provide the settings to the initialisation methods of the SDK. Sample configuration
files are provided.

@section atobnet_designnotes_folders Folder organisation

There are two sets of folders: the source code folders; and the package (installed) folders which vary
according to the platform.

<b>source</b>

- atobnet (Base module)
    - config (sample configuration file and description)
    - include (public/private header files)
    - packages (source files for generating packages)
    - resources (resource files to be included in packages)
    - src (source and internal header files)

<b>package</b>

- atobnet (Base module)
    - etc (resource and sample configuration file and description)
    - include (public/private header files)
    - lib (Libraries for various platforms)
    - docs (doxygen generated API documentation)

Note: a seperate example/sample "testharness" application is available to test the library.

@section atobnet_designnotes_usage Usage

Using the SDK follows the pattern:

- Set the global application information
- Create an initial global context object
- Initialise the system at application startup and specify a ConfigurationManager and Configuration to use
    - Use the context to retrieve and set values such as proxy settings (optional)
    - Create one or more SDK objects
        - Perform SDK operations
    - Free any SDK objects created
- Free the global context object and ConfigurationManager
- Deinitialise the system at application shutdown

Note: initialisation / deinitialises must be performed before / after any threading.

@section atobnet_designnotes_memory Memory allocation

It is often unclear in C as to who is responsible for freeing an object.
Where appropriate, methods allocating memory and handing responsibility for freeing memory to the caller,
include "create" in the method name. This is not always appropriate.
In order to be more explicit, all such "generated" objects (at least for non-static methods)
are passed as non-const parameter addresses rather than a return value. i.e.

- errcode = ato_obj_create(ctx, &obj);
rather than
- obj = ato_obj_create(ctx).

As a precaution, all methods that allocate objects first check that the pointer is currently NULL. If it
is not, it is assumed it is currently allocated and will ASSERT. While this does force client code into the
discipline of 'always initialise variables', it has been adopted as a minimal safety mechanism because it
was felt it was:

- good practice;
- not particularly onerous; and
- very helpful in catching some unfreed memory


@section atobnet_designnotes_lifecycle Object lifecycle

All relevant objects are created using ato_xx_create methods which return an error code.
The address of the object to be created is passed as the second argument
(the first argument being the ctx or Context argument discussed later).

Out of memory errors are considered catastophic and will halt the application with an assertion error.
This means that if the ato_xx_create method returns, the object will always be allocated, regardless
of any error that may have occurred.

All ato_xx_free methods can be called on NULL objects. This does nothing and is a convenience.

@section atobnet_designnotes_threading Threading

The API is thread-safe and Collections and objects are thread-safe for read-only operations,
except in specific documented cases. It is up to the application to apply appropriate thread
protection mechanisms if an object is being updated while shared between threads.

If in doubt, or if there are issues, create a new instance of any collection and objects for each thread.

*/
