/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup atobnet_overview_thirdparty

There are a number of criteria used for choosing third-party libraries:

- Open source
- Widely used
- Currently active
- High level of cross platform support
- Is a dependent library

This SDK has the following dependencies on Open Source software:

- ANSI C99 compliant compiler
    - primarily for 64 bit support in 3rd party libraries using "long long"

- Libcurl (7.21.4)
    - http://www.libcurl.org
    - Function: Network protocols (HTTP/s, etc) including proxy authentication
    - Chosen for: Open source, widely used, currently active, cross-platform

- Libxml2 (2.7.7)
    - http://xmlsoft.org/
    - Function: XML and XPATH support
    - Chosen for: Open source, widely used, currently active, cross-platform, is a dependent library

- Openssl (1.0.1)
    - http://www.openssl.org
    - Function: Cryptographic engine
    - Chosen for: Open source, widely used, currently active, cross-platform

- iconv (1.9.0.0)
    - http://www.gnu.org/software/libiconv/
    - Function: Character encoding and conversion support
    - Chosen for: Is a dependent library

- Zlib (1.2.5)
    - http://www.zlib.net/
    - Function: Compression/decompression support
    - Chosen for: Is a dependent library

Licensing and copyright information for the open source software are:

- Libcurl - see http://curl.haxx.se/docs/copyright.html
- Libxml2 - see http://xmlsoft.org/FAQ.html
- Openssl - see http://www.openssl.org/source/license.html
- Iconv - see http://www.gnu.org/software/libiconv/#downloading
- Zlib - see http://www.zlib.net/zlib_license.html

*/
