#ifndef __ATOTST_UTIL_H__
#define __ATOTST_UTIL_H__

#ifdef __cplusplus
extern "C" {
#endif

// Allocates buf and loads a file content into buf and returns the length - caller must free buf if length not 0.
// An extra byte is allocated at the end containing '\0' so the caller can interpret
// this as a C string - but .... caller better be confident it's not binary.
// Returns 0 if there was a problem (or the file is 0 length).
extern size_t utl_loadfile(char **buf, const char *filepath, bool recurseup);
extern long utl_filesize(const char *filepath);

// Look for file in current folder or above.
// There's no portable/easy way to recurse folders, so this is a kludge
// complete with magic numbers (it's just non-prod test code).
// Recurse up 10 times then fail.
extern FILE *utl_findandopen(const char *fname, const char *mode);

// Look for fname in current folder or above (max 10 levels).
// If found, return dir which will contain the folder name, else return NULL.
extern char *utl_filedir(char *dir, const char *fname);

#ifdef __cplusplus
}
#endif

#endif /*__ATOTST_UTIL_H__*/
