#ifndef __ATO_STM_TKN_H__
#define __ATO_STM_TKN_H__

/** @addtogroup atostm_api_stmtkn

@{
*/

/**
The Security Token object.
*/
typedef struct _ato_StmTkn ato_StmTkn;

#ifdef __cplusplus
extern "C" {
#endif

/**
Given a SecurityToken object, serialise the data - see also ato_stm_loadst().

@param st the SecurityToken.
@return The ATO RSTR serialised SecurityToken.
*/
ATO_STM_EXPORT ato_String *ato_stmtkn_xml(ato_StmTkn *st);

/**
Given a SecurityToken object, retrieve the key used in an ST cache.

@param st the SecurityToken.

@return ST key.
*/
ATO_STM_EXPORT const char *ato_stmtkn_key(ato_StmTkn *st);

/**
Given a SecurityToken object, retrieve the embedded proof token.

@param st the SecurityToken.

@return Proof Token.
*/
ATO_STM_EXPORT ato_String *ato_stmtkn_prooftoken(ato_StmTkn *st);

/**
Given a SecurityToken object, retrieve the encrypted assertion.

@param st the SecurityToken.

@return Assertion.
*/
ATO_STM_EXPORT ato_String *ato_stmtkn_assertion(ato_StmTkn *st);

/**
Given a SecurityToken object, retrieve the Assertion (SAML) ID.

This is stored in the KeyIdentifier Element of the RSTR.

@param st the SecurityToken.

@return Assertion (SAML) ID.
*/
ATO_STM_EXPORT const char *ato_stmtkn_samlid(ato_StmTkn *st);

/**
Check if the SecurityToken has expired - see also ato_stm_setexpirytime() and ato_stmtkn_expirytime().

@param st the SecurityToken.

@return TRUE or FALSE.
*/
ATO_STM_EXPORT bool ato_stmtkn_isexpired(ato_StmTkn *st);

/**
Get the local time the SecurityToken is to expire - see also ato_stmtkn_isexpired() and ato_stm_setexpirytime().

@param st the SecurityToken.

@return the expiry time (granularity is seconds).
*/
ATO_STM_EXPORT time_t ato_stmtkn_expirytime(ato_StmTkn *st);

ATO_STM_EXPORT void ato_stmtkn_free(ato_StmTkn *st);


#ifdef __cplusplus
}
#endif

/*! @} */

#endif /*__ATO_STM_TKN_H__*/
