/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup atostm_gettingstarted_stm

@section atostm_gettingstarted_stm_intro Using the STM API involves

- using ato_stm_create() to create one or more STS service objects,
based on a template used to construct requests, and which represents
    - the STS end-point (URL) from which to request SecurityTokens.
- using ato_stm_stsissue to request SecurityTokens
- using the STM TKN API to query the SecurityToken

@section atostm_gettingstarted_stm_create Create an STM object

@code
ato_Ctx *ctx = NULL;
ato_CfgMgr *ctxmgr = NULL;
ato_Stm *stm = NULL;
const ato_StmTkn *st = NULL;

int errcode = ATO_ERR_OK;

    : // initialise the SDKs.

errcode = ato_stm_create(ctx, stm, stsurl, xtemplate);
if (errcode != ATO_ERR_OK) ; // handle the error
    :
@endcode

The parameters are:
- context
- address of the STM object to allocate
- the endpoint URL - if NULL then load from the configuration
- the buffer containing the XML string for the template - if NULL then load from the file specified in the configuration

@note
The stm object must be freed when finished with.

@section atostm_gettingstarted_stm_st Get a SecurityToken

@code
    :
errcode = ato_stm_stsissue(ctx, stm, &st, certificate, privatekey, NULL);
if (errcode != ATO_ERR_OK) ; // handle the error
    :
@endcode

The parameters are:
- the STM object
- the address of the SecurityToken object to create
- the X509 certificate to use for the request
- the privatekey corresponding to the X509Certificate
- the relying party URL to use in subsequent WebServices transactions (e.g. SBRCSR);
if NULL get the value from the configuration

@note
The SecurityToken object is a const which is freed when the STM object is freed.

@section atostm_gettingstarted_stm_values Retrieve values from the SecurityToken

@code
ato_String *pt = ato_stmtkn_prooftoken(st);
ato_String *a = ato_stmtkn_assertion(st);
@endcode

@section atostm_gettingstarted_stm_cleanup Cleanup

@code
ato_stm_free(stm);
@endcode

*/
