#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <time.h>
#include <stdarg.h>

#include "atobase/all.h"
#include "atobnet/all.h"
#include "atoakm/all.h"
#include "atostm/all.h"

#include "../common/util.h"
#include "sys.h"

/*********************************************************************************/
int init(ato_Ctx *ctx)
{
    int errcode = ato_base_init(ctx, ATO_BASE_INIT_ALL);
    if (errcode == ATO_ERR_OK)
        errcode = ato_bnet_init(ctx, ATO_BNET_INIT_ALL);
    if (errcode == ATO_ERR_OK)
        errcode = ato_akm_init(ctx, ATO_AKM_INIT_ALL);
    if (errcode == ATO_ERR_OK)
        errcode = ato_stm_init(ctx, ATO_STM_INIT_ALL);
    return errcode;
}

void deinit(ato_Ctx *ctx)
{
    ato_stm_deinit();
    ato_akm_deinit();
    ato_bnet_deinit();
    ato_ctx_free(ctx);
    ato_base_deinit();
}

int loadks(ato_Ctx *ctx, ato_Keystore **ks, const char *dirname, const char *filename)
{
    int errcode = ATO_ERR_OK;
    char *buf = NULL;
    char dirbuf[FILENAME_MAX+1];

    assert(ks != NULL);

    if (*dirname == '.') {
        if (utl_filedir(dirbuf, filename) != NULL) // search in current folder or above
            dirname = dirbuf;
    }

    printf("Loading keystore %s/%s\n", dirname, filename);
    if ((errcode = ato_akm_loadks(ctx, &buf, dirname, filename)) != ATO_ERR_OK)
        goto finally;

    if ((errcode = ato_ks_create(ctx, ks, buf, NULL)) != ATO_ERR_OK) {
        printf("Failed to load keystore %s/%s\n", dirname, filename);
        goto finally;
    }

    errcode = ATO_ERR_OK;
finally:
    if (buf) free(buf);
    return errcode;
}

int saveks(ato_Ctx *ctx, ato_Keystore *ks, const char *dirname, const char *filename)
{
    int errcode = ATO_ERR_OK;
    char *buf = NULL;

    assert(ks != NULL);

    if ((errcode = ato_ks_save(ctx, ks, &buf)) != ATO_ERR_OK)
        goto finally;

    if ((errcode = ato_akm_saveks(ctx, buf, dirname, filename)) != ATO_ERR_OK)
        goto finally;

    errcode = ATO_ERR_OK;
finally:
    if (buf) free(buf);
    return errcode;
}

int sys_load(ato_Ctx *ctx, ato_Keystore **ks, const char *ksdirname, const char *ksfilename)
{
    int errcode = ATO_ERR_OK;
    if ((errcode = loadks(ctx, ks, ksdirname, ksfilename)) != ATO_ERR_OK)
        return errcode;
    return errcode;
}

void sys_free(ato_Ctx *ctx, ato_Keystore *ks)
{
    ato_ks_free(ks);
    ATO_IGNORE(ctx);
}
