macro(AK_FIND_MODULE module)
    set(my_NAME ${module})

    string(TOUPPER ${my_NAME} my_VAR_NAME)

    set(${my_VAR_NAME}_NAME ${my_NAME})
    find_path(${my_VAR_NAME}_INCLUDE_DIR ${my_NAME}/version.h PATH_SUFFIXES ${my_NAME}/include)
    find_library(${my_VAR_NAME}_LIBRARY NAMES ${my_NAME} lib${my_NAME} PATH_SUFFIXES ${my_NAME}/lib)
    find_path(${my_VAR_NAME}_DOC_DIR ${my_NAME}.tag PATH_SUFFIXES share/doc/lib${my_NAME} ${my_NAME}/docs)
    find_path(${my_VAR_NAME}_LIB_DIR lib${my_NAME}.a ${my_NAME}.lib lib${my_NAME}.lib lib${my_NAME}.dylib lib${my_NAME}.so PATH_SUFFIXES lib ${my_NAME}/lib)

    if (${my_VAR_NAME}_INCLUDE_DIR AND EXISTS "${${my_VAR_NAME}_INCLUDE_DIR}/${my_NAME}/version.h")
        file(
            STRINGS "${${my_VAR_NAME}_INCLUDE_DIR}/${my_NAME}/version.h" my_version_str
            REGEX "^#define[\t ]+${my_VAR_NAME}_VERSION[\t ]+\".*\""
        )
        string(REGEX REPLACE "^#define[\t ]+${my_VAR_NAME}_VERSION[\t ]+\"([^\"]*)\".*" "\\1"
            ${my_VAR_NAME}_VERSION_STRING "${my_version_str}"
        )
        unset(my_version_str)
    endif()

    # Handle the QUIETLY and REQUIRED arguments and set ${my_VAR_NAME}_FOUND to TRUE if all listed variables are TRUE.
    # Treat ${my_VAR_NAME}_DOC_DIR as optional
    include(FindPackageHandleStandardArgs)
    find_package_handle_standard_args(
        ${my_VAR_NAME}
        REQUIRED_VARS ${my_VAR_NAME}_LIBRARY ${my_VAR_NAME}_INCLUDE_DIR ${my_VAR_NAME}_LIB_DIR
        VERSION_VAR ${my_VAR_NAME}_VERSION_STRING
    )

    #if (${my_VAR_NAME}_FOUND)
        set(${my_VAR_NAME}_INCLUDE_DIRS ${${my_VAR_NAME}_INCLUDE_DIR} )
        set(${my_VAR_NAME}_LIBRARIES ${${my_VAR_NAME}_LIBRARY} )
    #endif()

    mark_as_advanced(${my_VAR_NAME}_INCLUDE_DIRS ${my_VAR_NAME}_LIBRARIES ${my_VAR_NAME}_DOC_DIR ${my_VAR_NAME}_LIB_DIR ${my_VAR_NAME}_VERSION_STRING)

    set(mymsg "${my_VAR_NAME}_FOUND = ${${my_VAR_NAME}_FOUND} (${${my_VAR_NAME}_VERSION_STRING})")
    set(mymsg "${mymsg} (LIB=${${my_VAR_NAME}_LIBRARIES}) (INC=${${my_VAR_NAME}_INCLUDE_DIRS}) (DOC=${${my_VAR_NAME}_DOC_DIR})")
    message(STATUS ${mymsg})
    if (NOT ${my_VAR_NAME}_FOUND AND ${my_NAME}_FIND_REQUIRED)
        message(FATAL_ERROR "Required library ${my_NAME} NOT FOUND.")
    endif()

    unset(mymsg)
    unset(${my_VAR_NAME}_INCLUDE_DIR)
    unset(${my_VAR_NAME}_LIBRARY)
    unset(my_VAR_NAME)
    unset(my_NAME)
endmacro(AK_FIND_MODULE)

macro(AK_FIND_LIBRARY LIBS library)
    string(TOUPPER "${library}" ulibrary)
    string(TOUPPER "${ARGV2}" required)
    find_library(${ulibrary}_LIBRARIES NAMES lib${library}.a ${library})
    if (${ulibrary}_LIBRARIES)
        message(STATUS "Found ${library} = ${${ulibrary}_LIBRARIES}")
        set(${LIBS} ${${LIBS}} ${${ulibrary}_LIBRARIES})
    elseif("${required}" STREQUAL "REQUIRED")
        message(FATAL_ERROR "***ERROR*** Cannot find ${library} = ${${ulibrary}_LIBRARIES}")
    else()
        message(STATUS "Cannot find optional ${library} = ${${ulibrary}_LIBRARIES}")
    endif()
endmacro(AK_FIND_LIBRARY)

macro(AK__ADD_DEP_LIBRARY library l_linkshared)
    set(l_set_win_build_type "")

    if (AK_IS_WINDOZE)
        set(l_set_win_build_type "/${CMAKE_BUILD_TYPE}")
        if (${l_linkshared})
            set(myLIB "${CMAKE_BINARY_DIR}/${library}/${CMAKE_CFG_INTDIR}/${library}${tmp_PREFIX}.${AK_PLATFORM_SHLIB_LINK_EXT}")
        else()
            set(myLIB "${CMAKE_BINARY_DIR}/${library}/${CMAKE_CFG_INTDIR}/${library}${tmp_PREFIX}.${AK_VAR_STATIC_POSTFIX}.lib")
        endif()
    elseif (${l_linkshared})
        set(myLIB "${CMAKE_BINARY_DIR}/${library}/lib${library}.${AK_PLATFORM_SHLIB_LINK_EXT}")
    else()
        set(myLIB "${CMAKE_BINARY_DIR}/${library}/lib${library}.a")
    endif()

    if (${l_linkshared})
        if ("${PROJECT_NAME}" MATCHES "^.*x$")
            file(TO_NATIVE_PATH "${CMAKE_BINARY_DIR}/${library}${l_set_win_build_type}" tmp)
            set(AK_VAR_LDLIB_PATH "${tmp}${AK_PATH_SEP}${AK_VAR_LDLIB_PATH}")
        endif()
    endif()
    #message(STATUS "AK_ADD_DEP_LIBRARY=${myLIB}")
    set(AK_DEP_LIBS ${AK_DEP_LIBS} "${myLIB}")
    #set(LIB_DIRS "${LIB_DIRS};${${umodule}_LIB_DIR}")
    #set(DOXY_TAGFILES "${DOXY_TAGFILES} \"${${umodule}_DOC_DIR}/${${umodule}_NAME}.tag\"=\"${${umodule}_DOC_DIR}/html\"")
    add_dependencies(${PROJECT_NAME} ${library})
    message(STATUS "Added ${library}")
endmacro(AK__ADD_DEP_LIBRARY)

macro(AK_ADD_DEP_LIBRARY library)
    set(l_linkshared 0)
    if (${ARGC} GREATER 1)
        set(l_linkshared ${ARGV1})
    endif()

    include_directories("${AK_DIR_PROJECT}/${library}/include")
    if (EXISTS "${AK_DIR_PROJECT}/${library}/resources")
        file(COPY "${AK_DIR_PROJECT}/${library}/resources/" DESTINATION "${PROJECT_BINARY_DIR}")
        #message(STATUS "Copying ${AK_DIR_PROJECT}/${library}/resources/ to ${PROJECT_BINARY_DIR}")
    endif()

    if (${l_linkshared} EQUAL 2)
        message(STATUS "Added ${library} includes")
    else()
        ak__add_dep_library(${library} ${l_linkshared})
    endif()
endmacro(AK_ADD_DEP_LIBRARY)

macro(AK_FIND_PACKAGE LIBS library)
    string(TOUPPER "${library}" ulibrary)
    string(TOUPPER "${ARGV2}" required)
    find_package(${library} ${required})
    if (${ulibrary}_LIBRARIES)
        include_directories(${${ulibrary}_INCLUDE_DIR})
        set(${LIBS} ${${LIBS}} ${${ulibrary}_LIBRARIES})
        message(STATUS "${library} = ${${ulibrary}_FOUND} (${${ulibrary}_VERSION_STRING}_${${ulibrary}_VERSION}) (${${ulibrary}_INCLUDE_DIR}) (${${ulibrary}_LIBRARIES})")
    else()
        message(STATUS "Cannot find optional ${library} = ${${ulibrary}_LIBRARIES}")
    endif()
endmacro(AK_FIND_PACKAGE)
