# - Try to find libxmlsec
# Once done, this will define
#
#  JANSSON_FOUND - system has libjanson
#  JANSSON_INCLUDE_DIRS - header file dir
#  JANSSON_LIBRARIES - lib dir
#  JANSSON_VERSION_STRING - version string


find_package(PkgConfig QUIET)

# Include dir
find_path(JANSSON_INCLUDE_DIR NAMES jansson.h)
if (JANSSON_INCLUDE_DIR AND EXISTS "${JANSSON_INCLUDE_DIR}/jansson.h")
    set(JANSSON_INCLUDE_DIR "${JANSSON_INCLUDE_DIR}")
endif()

# Finally the library itself
find_library(JANSSON_LIBRARY NAMES jansson libjansson)

if (JANSSON_INCLUDE_DIR AND EXISTS "${JANSSON_INCLUDE_DIR}/jansson.h")
    file(STRINGS "${JANSSON_INCLUDE_DIR}/jansson.h" my_version_str
        REGEX "^#define[\t ]+JANSSON_VERSION[\t ]+\".*\"")
    string(REGEX REPLACE "^#define[\t ]+JANSSON_VERSION[\t ]+\"([^\"]*)\".*" "\\1"
        JANSSON_VERSION_STRING "${my_version_str}")
    unset(my_version_str)
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    Jansson
    REQUIRED_VARS JANSSON_LIBRARY JANSSON_INCLUDE_DIR
    VERSION_VAR JANSSON_VERSION_STRING
)

if (JANSSON_FOUND)
    set(JANSSON_LIBRARIES ${JANSSON_LIBRARY})
    set(JANSSON_INCLUDE_DIRS ${JANSSON_INCLUDE_DIR})
endif()

mark_as_advanced(JANSSON_INCLUDE_DIR JANSSON_LIBRARY)
