# - Try to find libxmlsec
# Once done, this will define
#
#  XMLSEC1_FOUND - system has libxmlsec1
#  XMLSEC1_INCLUDE_DIRS - header file dir
#  XMLSEC1_LIBRARIES - lib dir
#  XMLSEC1_VERSION_STRING - version string

find_package(PkgConfig QUIET)

# Include dir
find_path(XMLSEC1_INCLUDE_DIR NAMES xmlsec/xmlsec.h PATH_SUFFIXES xmlsec1)
if (XMLSEC1_INCLUDE_DIR AND EXISTS "${XMLSEC1_INCLUDE_DIR}/xmlsec1/xmlsec/xmlsec.h")
    set(XMLSEC1_INCLUDE_DIR "${XMLSEC1_INCLUDE_DIR}/xmlsec1")
endif()

# Finally the library itself
find_library(XMLSEC1-OPENSSL_LIBRARY NAMES xmlsec1-openssl libxmlsec1-openssl libxmlsec-openssl)
find_library(XMLSEC1_LIBRARY NAMES xmlsec1 libxmlsec1 libxmlsec)

if (XMLSEC1_INCLUDE_DIR AND EXISTS "${XMLSEC1_INCLUDE_DIR}/xmlsec/version.h")
    file(STRINGS "${XMLSEC1_INCLUDE_DIR}/xmlsec/version.h" my_version_str
        REGEX "^#define[\t ]+XMLSEC_VERSION[\t ]+\".*\"")
    string(REGEX REPLACE "^#define[\t ]+XMLSEC_VERSION[\t ]+\"([^\"]*)\".*" "\\1"
        XMLSEC1_VERSION_STRING "${my_version_str}")
    unset(my_version_str)
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(
    XmlSec1
    REQUIRED_VARS XMLSEC1_LIBRARY XMLSEC1-OPENSSL_LIBRARY XMLSEC1_INCLUDE_DIR
    VERSION_VAR XMLSEC1_VERSION_STRING
)

if (XMLSEC1_FOUND)
    # Order is important if linking staticly
    set(XMLSEC1_LIBRARIES ${XMLSEC1-OPENSSL_LIBRARY} ${XMLSEC1_LIBRARY})
    set(XMLSEC1_INCLUDE_DIRS ${XMLSEC1_INCLUDE_DIR})
endif()

mark_as_advanced(XMLSEC1_INCLUDE_DIR XMLSEC1-OPENSSL_LIBRARY XMLSEC1_LIBRARY)
