
ak_find_package(AK_DEP_LIBS OpenSSL REQUIRED)
ak_find_package(AK_DEP_LIBS LibXml2 REQUIRED)
ak_find_package(AK_DEP_LIBS Jansson REQUIRED)

if ("${AK_PLATFORM}" STREQUAL "mingw64" OR "${AK_PLATFORM}" STREQUAL "mingw32")
    #Has to be a win path :(
    set(TEST_ENV "CURL_CA_BUNDLE=C:\\msys64\\usr\\ssl\\certs\\ca-bundle.crt")

    set(AK_DEP_LIBS ${AK_DEP_LIBS} -static-libgcc)

    # ssh2,etc only required for CURL
    # ming64 has a bug where psl.a and idn2.a are linked dymically against a another lib (__imp_uninorm_nfkc)
    if ("${AK_PLATFORM}" STREQUAL "mingw32")
        set(AK_DEP_LIBS ${AK_DEP_LIBS} -Wl,-Bstatic)
    endif()
    set(AK_DEP_LIBS ${AK_DEP_LIBS} psl idn2)
    set(AK_DEP_LIBS ${AK_DEP_LIBS} -Wl,-Bstatic nghttp2 crypt32 unistring ssh2 brotlidec-static brotlicommon-static)

    set(AK_DEP_LIBS ${AK_DEP_LIBS} z lzma intl iconv zstd)
    set(AK_DEP_LIBS ${AK_DEP_LIBS} wldap32 wsock32 ws2_32 gdi32 comdlg32)
elseif ("${AK_PLATFORM}" STREQUAL "mac")
    ak_find_package(AK_DEP_LIBS ZLIB REQUIRED)
    ak_find_package(AK_DEP_LIBS LibLZMA REQUIRED)
    ak_find_library(AK_DEP_LIBS IDN REQUIRED)
    #ak_find_package(AK_DEP_LIBS Intl REQUIRED)
    ak_find_library(AK_DEP_LIBS ICONV REQUIRED)
endif()

message(STATUS "-------------------------------------------------------------------------------")

if ("${PROJECT_NAME}" MATCHES "^.*x$")
    add_test(NAME ${PROJECT_NAME} COMMAND ${PROJECT_NAME} @run.ini${PROJECT_TEST_ARGS})
    if (NOT "${AK_VAR_LDLIB_PATH}" STREQUAL "")
        if ("${AK_PLATFORM}" STREQUAL "mingw64") # Because static curl is linked to some dlls instead of static libs
            set(AK_VAR_LDLIB_PATH "${AK_VAR_LDLIB_PATH}${AK_PATH_SEP}c:/msys64/mingw64/bin")
        endif()
        STRING(REPLACE "\\;" ";" AK_VAR_LDLIB_PATH "${AK_VAR_LDLIB_PATH}")
        STRING(REPLACE ";" "\\;" AK_VAR_LDLIB_PATH "${AK_VAR_LDLIB_PATH}")
        set(TEST_ENV "${TEST_ENV};${AK_PATH_LDLIB_NAME}=${AK_VAR_LDLIB_PATH}")
    endif()
    set(TEST_ENV "${TEST_ENV};a_masroot=${AK_DIR_PROJECT}")
    if (NOT "${TEST_ENV}" STREQUAL "")
        message("Setting TEST ENVIRONMENT: ${TEST_ENV}")
        set_tests_properties(${PROJECT_NAME} PROPERTIES ENVIRONMENT "${TEST_ENV}")
    endif()
endif()

target_link_libraries(${PROJECT_NAME} ${AK_DEP_LIBS} ${CMAKE_DL_LIBS})

if (AK_VERBOSE)
    message(STATUS)
    message(STATUS "-------------------------------------------------------------------------------")
    AK_print_properties_global()
    message(STATUS)
    message(STATUS "-------------------------------------------------------------------------------")
    AK_print_properties_dir()
    message(STATUS)
    message(STATUS "-------------------------------------------------------------------------------")
    AK_print_properties_target(${PROJECT_NAME})
endif()
message(STATUS)
message(STATUS "-------------------------------------------------------------------------------")
message(STATUS "AK_DEP_LIBS = ${AK_DEP_LIBS}")
GET_DIRECTORY_PROPERTY(output INCLUDE_DIRECTORIES)
message(STATUS "INCLUDE_DIRECTORIES = ${output}")
message(STATUS "AK_VAR_LDLIB_PATH = ${AK_VAR_LDLIB_PATH}")
message(STATUS "CMAKE_OSX_ARCHITECTURES=${CMAKE_OSX_ARCHITECTURES}")
message(STATUS "CMAKE_OSX_DEPLOYMENT_TARGET=${CMAKE_OSX_DEPLOYMENT_TARGET}")
message(STATUS "-------------------------------------------------------------------------------")
message(STATUS)

#message(FATAL_ERROR "Halting")
