#!/usr/bin/env bash

set -e

osname=$(uname)
if [[ "$osname" =~ "MSYS" ]]; then echo "Build under MINGW64 or MINGW32";
elif [[ "$osname" =~ "MINGW64" ]]; then platform="mingw64";
elif [[ "$osname" =~ "MINGW32" ]]; then platform="mingw32";
elif [ "$osname" == "Darwin" ]; then platform="mac";
else platform="nix"; fi

config=Release

build_level=${1:-0}
cmakefile=${2:-default}

builddir=$PWD/_build/${platform}-${config}

dogen() {
    rm -rf ${builddir}
    mkdir -p ${builddir}
    cd ${builddir}
    cmake -C ../../cmakemodules/cmvars-${platform}.cmake \
        -DCMAKE_BUILD_TYPE=${config} \
        -DAK_BUILD=${cmakefile} \
        -DAK_DOC=Y \
        -DAK_DIR_DEP=. \
        -DAK_SRC="$(uname -a)" \
        -DAK_HASH=0 \
        ../..
}

dobld() {
    cd ${builddir}
    cmake --build . --config ${config}
}

dodoc() {
    if [[ "${config}" == "Release" ]]; then
        cd ${builddir}
        cmake --build . --target doc --config ${config}
    fi
}

dotst() {
    cd ${builddir}
    if [[ "$platform" =~ "mimgw" ]]; then
        # curl seems to have problems locating its certs?
        export CURL_CA_BUNDLE="C:\\msys64\\usr\\ssl\\certs\\ca-bundle.crt"
    fi
    ctest -V -C ${config} -R
}

if [[ $build_level -le 1 ]]; then dogen; fi
if [[ $build_level -le 2 ]]; then dobld; fi
if [[ $build_level -le 3 ]]; then dotst; fi
if [[ $build_level -le 4 ]]; then dodoc; fi
