/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup sbrcsr_gettingstarted_all

Using AKM, STM, and CSR together, ignoring "incidental" issues such as error and logging, and dropping some variables:

@code
ato_Cxt *ctx;
ato_CfgMgr *cfgmgr;

ato_si_set("Your Organisation Name Here", "SBR CSR Reference Client (C version)", "0.6", buildtime, hash);
ato_ctx_create(&ctx);
ato_cfgm_create(ctx, &cfgmgr, NULL, "test")
ato_base_init(ctx, ATO_BASE_INIT_ALL);
ato_akm_init(ctx, ATO_AKM_INIT_ALL);
ato_stm_init(ctx, ATO_STM_INIT_ALL);
sbr_csr_init(ctx, SBR_CSR_INIT_ALL);

ato_ks_create(ctx, &ks, xmlKeystoreBuf);
ato_stm_create(ctx, &stm, stsurl, xmlSTMTemplateBuf);
sbr_csr_create(ctx, &csr, "lodge", csrurl, xmlCSRTemplateBufForLodge);

cr = ato_ks_credential(ks, alias);
if (ato_cr_isrenewable(cr) && ato_cr_renew(ctx, cr, password) != ATO_ERR_OK)
    logsomethingbutcarryon("Warning: renewal for '%s' failed\n", alias);
ato_cr_certificate(ctx, cr, &certificate);
ato_cr_privatekey(ctx, cr, &privatekey, password);

ato_stm_stsissue(ctx, stm, &st, certificate, privatekey, stsurl);
ato_String *prooftoken = ato_stmtkn_prooftoken(st);
ato_String *assertion = ato_stmtkn_assertion(st);

sbr_req_create(ctx, &request, csr);
sbr_req_submit(ctx, request, &response, certificate, privatekey, prooftoken, assertion);
sbr_res_xml(ctx, response, &buffer);

free(buffer);
sbr_req_free(request);
sbr_csr_free(csr);
ato_stm_free(stm);
ato_ks_free(ks);

ato_ctx_free(ctx);
ato_cfgm_free(cfgmgr);

sbr_csr_deinit();
ato_stm_deinit();
ato_akm_deinit();
ato_base_deinit();
@endcode

*/
