#ifndef __SBR_CSR_CSROBJ_INTERNAL_H__
#define __SBR_CSR_CSROBJ_INTERNAL_H__

#ifndef SBR_CSR_INTERNAL
#error "This file is for internal use only"
#endif

#include "sbrcsr/csr.h"

#ifdef __cplusplus
extern "C" {
#endif

extern int sbr__csr_init(void);
extern void sbr__csr_deinit(void);

extern void sbr__csr_create(ato_Ctx *ctx, sbr_Csr **obj, const char *servicetype, const char *csrurl, const char *csrtemplate);

/**@internal
Get the URL (service endpoint).
This will be the value passed to sbr_csr_create() if not NULL, otherwise it's the value from the configuration file.
@param csr the CSR object.
@return the URL
*/
SBR_CSR_EXPORT const char *sbr_csr_url(ato_Ctx *ctx, sbr_Csr *csr);

/**@internal
Get the XML template.
This is the value passed to sbr_csr_create().
@param csr the CSR object.
@return the template.
*/
SBR_CSR_EXPORT ato_String *sbr_csr_template(ato_Ctx *ctx, sbr_Csr *csr);

/**@internal
Get the servicename used in setting/getting nodes in the XML template.
Based on the servicetype parameter in sbr_csr_create(), this is the value from the configuration file.
@param csr the CSR object.
@return the servicename in the body of the XML template.
*/
SBR_CSR_EXPORT const char *sbr_csr_servicename(ato_Ctx *ctx, sbr_Csr *csr);

/**@internal
Get the servicenamespace (XML schema) used in the request node of the CSR XML template.
Based on the servicetype parameter in sbr_csr_create(), this is the value from the configuration file.
@param csr the CSR object.
@return the servicenamespace for the request node in the body of the XML template.
*/
SBR_CSR_EXPORT const char *sbr_csr_servicenamespace(ato_Ctx *ctx, sbr_Csr *csr);

#ifdef __cplusplus
}
#endif

#endif /*__SBR_CSR_CSROBJ_INTERNAL_H__*/
