<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile doxygen_version="1.9.1" doxygen_gitid="ec8203f43232e7e7b16b1c85351c7c48d128f924">
  <compound kind="group">
    <name>sbrcsr_api_csr_types_modules</name>
    <title>Module defines</title>
    <filename>group__sbrcsr__api__csr__types__modules.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_LIBRARY</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga5e0c1f35781a86995fd3a4c7285b9eaf</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULE_LIB</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga8552f3a871be26592e9b162fab6f54d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULE_ERRFN</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga4e266030b7b4cf90857310abcf4417bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULE_CSR</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>gae3fcc7f0e52c9bd06beea7aae9fe1ff0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULE_REQUEST</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga5234539fb98d7d29f41c846c631458d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULE_RESPONSE</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga7a2e5d209170b40167f6523aed5b6604</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULE_DOC</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga26cd6cf4dc1b005c52980ba423b71a55</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULE_DOCA</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga60caf79d3847932cb522d381379bf122</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULE_MSGEVENT</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga656edbaea0ba50558a22de5295a43c89</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULE_MSGTS</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga23d308bb3a108329bbc59249ad7cca5c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULE_MSGP</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>gab09f95a7b729454df8c21a6ac3276caa</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULE_MSGREC</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga18f138d0f13d08a6846e98d3e8fa417b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULE_SBDM</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>gac7a7c764e8498ca24f54fea696b41431</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULEID_LIB</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>gaafacf18ace2900573695705d33a0eda9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULEID_ERRFN</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga4dfdddc150330def4305191a010beac5</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULEID_CSR</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>gaaef9e4a4b02e62117ff3a23f6e287595</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULEID_REQUEST</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga6d6778691f2a0d645073e07199de25d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULEID_RESPONSE</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga8bc410a39dac77fe816ec9f4fc9a6b2c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULEID_DOC</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga26638de6a2335846e6745128ce0d54d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULEID_DOCA</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga97f87165d8ef0d0362165daf15dba448</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULEID_MSGEVENT</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga6819d06c88a7079022ec9083debdec9f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULEID_MSGTS</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga904ca90d8e7cb8a52e1e09df35313a54</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULEID_MSGP</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga796abdabe6021b43f387457a4754b29f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULEID_MSGREC</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>gace18b402b015159f24979bfec18a0d79</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_MODULEID_SBDM</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga6ae8d935969a1453654dffd3a60414b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_INIT_ALL</name>
      <anchorfile>group__sbrcsr__api__csr__types__modules.html</anchorfile>
      <anchor>ga773614c9f3da08d3c5f4355de25714d6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_types_config</name>
    <title>Configuration Values</title>
    <filename>group__sbrcsr__api__csr__types__config.html</filename>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_types_errcodes</name>
    <title>Error codes</title>
    <filename>group__sbrcsr__api__csr__types__errcodes.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_ERR_MIN</name>
      <anchorfile>group__sbrcsr__api__csr__types__errcodes.html</anchorfile>
      <anchor>ga44290f3307371db27c6fcf66b92b451b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_ERR_GENERAL</name>
      <anchorfile>group__sbrcsr__api__csr__types__errcodes.html</anchorfile>
      <anchor>gac574a758af059f99ce94214172ea3fb1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_ERR_NETSENDER</name>
      <anchorfile>group__sbrcsr__api__csr__types__errcodes.html</anchorfile>
      <anchor>ga25b3c0aa55dfd90136c99a09060d88e8</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_ERR_NETRECEIVER</name>
      <anchorfile>group__sbrcsr__api__csr__types__errcodes.html</anchorfile>
      <anchor>ga516b0e980056151c5e5d38e9a28d436e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_ERR_NETUNAVAILABLE</name>
      <anchorfile>group__sbrcsr__api__csr__types__errcodes.html</anchorfile>
      <anchor>ga7b774473038dbc99e92e64d6d6ad95aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_ERR_NETCOMMS</name>
      <anchorfile>group__sbrcsr__api__csr__types__errcodes.html</anchorfile>
      <anchor>ga0a54a02e48670415e1f3ff77d87fa4cc</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_ERR_NETTIMEOUT</name>
      <anchorfile>group__sbrcsr__api__csr__types__errcodes.html</anchorfile>
      <anchor>ga298e11189f5bf74e29a6116bbf1f8632</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SBR_CSR_ERR_MAX</name>
      <anchorfile>group__sbrcsr__api__csr__types__errcodes.html</anchorfile>
      <anchor>ga8c07233f88c342b4514833df9ca38def</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_types</name>
    <title>Types</title>
    <filename>group__sbrcsr__api__csr__types.html</filename>
    <subgroup>sbrcsr_api_csr_types_modules</subgroup>
    <subgroup>sbrcsr_api_csr_types_config</subgroup>
    <subgroup>sbrcsr_api_csr_types_errcodes</subgroup>
    <member kind="enumeration">
      <type></type>
      <name>sbr_eMsgSourceType</name>
      <anchorfile>group__sbrcsr__api__csr__types.html</anchorfile>
      <anchor>ga7d75dc23b4b720a68f3a9bf521b0eaa5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SBR_REQUEST</name>
      <anchorfile>group__sbrcsr__api__csr__types.html</anchorfile>
      <anchor>gga7d75dc23b4b720a68f3a9bf521b0eaa5af4a92f8438d76ae3ea943074bdaf569c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SBR_RESPONSE</name>
      <anchorfile>group__sbrcsr__api__csr__types.html</anchorfile>
      <anchor>gga7d75dc23b4b720a68f3a9bf521b0eaa5ab1974878e19b9afc2bc87e88f2c3aa60</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_lib</name>
    <title>Library</title>
    <filename>group__sbrcsr__api__csr__lib.html</filename>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_csr_version</name>
      <anchorfile>group__sbrcsr__api__csr__lib.html</anchorfile>
      <anchor>gac35af43ae00c073cceca451db9a9fcdc</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_csr_init</name>
      <anchorfile>group__sbrcsr__api__csr__lib.html</anchorfile>
      <anchor>ga754ca74313f113e6cda84393cf031573</anchor>
      <arglist>(ato_Ctx *ctx, unsigned short flag)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_csr_deinit</name>
      <anchorfile>group__sbrcsr__api__csr__lib.html</anchorfile>
      <anchor>ga9a134f06c58f1c36fa09185b698e21cf</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_csr_default_templatefile</name>
      <anchorfile>group__sbrcsr__api__csr__lib.html</anchorfile>
      <anchor>ga5a364b753a57495019ed0f93e76adc4a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_csr_loadtemplate</name>
      <anchorfile>group__sbrcsr__api__csr__lib.html</anchorfile>
      <anchor>ga51398f18e358c7955e0b83ac471269a2</anchor>
      <arglist>(ato_Ctx *ctx, char **buffer, const char *dirname, const char *filename)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr</name>
    <title>CSR Service</title>
    <filename>group__sbrcsr__api__csr.html</filename>
    <member kind="typedef">
      <type>struct _sbr_Csr</type>
      <name>sbr_Csr</name>
      <anchorfile>group__sbrcsr__api__csr.html</anchorfile>
      <anchor>gae22a8c20a0f9f3d5376111cc3982c342</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_csr_create</name>
      <anchorfile>group__sbrcsr__api__csr.html</anchorfile>
      <anchor>ga58d2ed37802871f51c72447b0438013b</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Csr **csr, const char *servicetype, const char *csrurl, const char *csrtemplate)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_csr_free</name>
      <anchorfile>group__sbrcsr__api__csr.html</anchorfile>
      <anchor>ga18f8aa568d0ce3b2b258c2f7ce08ae04</anchor>
      <arglist>(sbr_Csr *csr)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_csr_timeout</name>
      <anchorfile>group__sbrcsr__api__csr.html</anchorfile>
      <anchor>ga938023b590e3056945c15cd6f8f583af</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Csr *csr)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_csr_settimeout</name>
      <anchorfile>group__sbrcsr__api__csr.html</anchorfile>
      <anchor>gac3eb7f15f1194f87310fd125afa1ce0e</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Csr *csr, size_t timeout)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_csr_timeoutconnect</name>
      <anchorfile>group__sbrcsr__api__csr.html</anchorfile>
      <anchor>ga8f7a828b5fcc3b06a33aa501c3f6ab7c</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Csr *csr)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_csr_settimeoutconnect</name>
      <anchorfile>group__sbrcsr__api__csr.html</anchorfile>
      <anchor>gacfeba3c098f74fced472fa2d0c3f9d2c</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Csr *csr, size_t timeout)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_reqres</name>
    <title>Request and Response</title>
    <filename>group__sbrcsr__api__csr__reqres.html</filename>
    <subgroup>sbrcsr_api_csr_req</subgroup>
    <subgroup>sbrcsr_api_csr_res</subgroup>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_req</name>
    <title>Request Message</title>
    <filename>group__sbrcsr__api__csr__req.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>SBR_MTOM_THRESHOLD_DEFAULT</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>ga9262820026c0c6f9740d3738f32b9f0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct _sbr_Request</type>
      <name>sbr_Request</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>ga29565acd05cc70d75f61dd67a1609670</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_req_create</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>gae96f7959b23ddb32b1b97ea60450ee44</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Request **request, sbr_Csr *csr)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_req_free</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>gaa84bc22f65de6a2692c20984e816c6d6</anchor>
      <arglist>(sbr_Request *request)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_req_xml</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>ga45fe336721ba24a029a8bb8c42df8467</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Request *request, char **buffer)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_req_submit</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>ga333c2c27426b235d6355307df0ef0e22</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Request *request, sbr_Response **response, ato_String *certificate, ato_String *privatekey, ato_String *prooftoken, ato_String *assertion)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_req_mtom_setsize</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>ga1bf7157140d7ad38826da9a0a9a2f0a7</anchor>
      <arglist>(sbr_Request *request, size_t threshold)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_req_mtom_size</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>gabcc31fbb4fced9816919c748d55dd259</anchor>
      <arglist>(sbr_Request *request)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_req_ssid_set</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>gaf8d87c7b397aa7e4642c509e0abde83b</anchor>
      <arglist>(sbr_Request *request, const char *ssid)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_req_ssid</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>ga27d6fd16cc096130ea341f9d6a8a37ed</anchor>
      <arglist>(sbr_Request *request)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_req_sbdm_count</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>gac743613a6f88d20e47b1c1e66c298e31</anchor>
      <arglist>(sbr_Request *request)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_req_sbdm_iterator</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>gacec7fdd059510aeefdcf16541a7f672d</anchor>
      <arglist>(sbr_Request *request, ato_Iterator **iter)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_Sbdm *</type>
      <name>sbr_req_sbdm_firstv</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>ga05babbc21172719d801c5842108b2b1c</anchor>
      <arglist>(sbr_Request *request)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_Sbdm *</type>
      <name>sbr_req_sbdm_nextv</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>gaacf0f7a5a55793fc8943deab01398ee4</anchor>
      <arglist>(sbr_Request *request)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_req_sbdm_add</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>ga0cd4c689240ff9b92e24d5e15820e697</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Request *request, sbr_Sbdm **sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_req_sbdm_remove</name>
      <anchorfile>group__sbrcsr__api__csr__req.html</anchorfile>
      <anchor>ga9c35dc1b1ff750ab5177c22c654599ed</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Request *request, sbr_Sbdm *sbdm)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_res</name>
    <title>Response Message</title>
    <filename>group__sbrcsr__api__csr__res.html</filename>
    <member kind="typedef">
      <type>struct _sbr_Response</type>
      <name>sbr_Response</name>
      <anchorfile>group__sbrcsr__api__csr__res.html</anchorfile>
      <anchor>gade04c89ede4fade1c757356c15a9bdad</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_res_xml</name>
      <anchorfile>group__sbrcsr__api__csr__res.html</anchorfile>
      <anchor>gaf411fb91c03a57733002f1c0a0c6ff94</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Response *response, char **buffer)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_res_sbdm_count</name>
      <anchorfile>group__sbrcsr__api__csr__res.html</anchorfile>
      <anchor>gac1f7e06faf05ed9bcc0fa1e48b95cccc</anchor>
      <arglist>(sbr_Response *response)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_res_sbdm_iterator</name>
      <anchorfile>group__sbrcsr__api__csr__res.html</anchorfile>
      <anchor>gac2e7feb99f9a2d67e3aa5dc89f6df9d6</anchor>
      <arglist>(sbr_Response *response, ato_Iterator **iter)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_Sbdm *</type>
      <name>sbr_res_sbdm_firstv</name>
      <anchorfile>group__sbrcsr__api__csr__res.html</anchorfile>
      <anchor>ga274a3810ce88228e0f4186ec87c77e92</anchor>
      <arglist>(sbr_Response *response)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_Sbdm *</type>
      <name>sbr_res_sbdm_nextv</name>
      <anchorfile>group__sbrcsr__api__csr__res.html</anchorfile>
      <anchor>gad7241be6c478f4731daa8e5ee86fc8ab</anchor>
      <arglist>(sbr_Response *response)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT bool</type>
      <name>sbr_res_ismaxseveritycode</name>
      <anchorfile>group__sbrcsr__api__csr__res.html</anchorfile>
      <anchor>gaad7ff41cfc66586717b9617b7ebf147a</anchor>
      <arglist>(sbr_Response *response, const char *severitycode)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_sbdmetc</name>
    <title>Standard Business Document Message</title>
    <filename>group__sbrcsr__api__csr__sbdmetc.html</filename>
    <subgroup>sbrcsr_api_csr_sbdm</subgroup>
    <subgroup>sbrcsr_api_csr_msgparty</subgroup>
    <subgroup>sbrcsr_api_csr_msgrec</subgroup>
    <subgroup>sbrcsr_api_csr_msgts</subgroup>
    <subgroup>sbrcsr_api_csr_msgevent</subgroup>
    <subgroup>sbrcsr_api_csr_doc</subgroup>
    <subgroup>sbrcsr_api_csr_doca</subgroup>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_sbdm</name>
    <title>SBDM</title>
    <filename>group__sbrcsr__api__csr__sbdm.html</filename>
    <member kind="typedef">
      <type>struct _sbr_Sbdm</type>
      <name>sbr_Sbdm</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga1747e0adda5917a44332a4411aee6fed</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_sbdm_iid</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga86904eaf9d8993f5fe542c30c5563342</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_eMsgSourceType</type>
      <name>sbr_sbdm_msgsourcetype</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga26a49f035f490e7223a0335626736554</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_sbdm_setmessagetype</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga720d2593caff097436641bb30cb64e35</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Sbdm *sbdm, const char *messagetype)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_sbdm_messagetype</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga96f09a018dc38dc6e5d663872030dc35</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_sbdm_setparty</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga4478d04c4c6801cba5a76e23752cffe8</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Sbdm *sbdm, sbr_eMsgPartyType partytype, const char *iddesignation, const char *idname)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_MsgParty *</type>
      <name>sbr_sbdm_party</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>gada2c6543226b38ee361f1705033c0c0c</anchor>
      <arglist>(sbr_Sbdm *sbdm, sbr_eMsgPartyType partytype)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_sbdm_doc_add</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga4d18126a52821e46faac448f94dbf671</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Sbdm *sbdm, sbr_Doc **doc, const char *validationuri, const char *governmentid, const char *businessid, time_t createtime)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_sbdm_doc_remove</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>gaab9a05e939739f03481742da5237a46d</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Sbdm *sbdm, sbr_Doc *doc)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_sbdm_doc_count</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga17113cc68ff62a80a8087678c2bb9823</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_sbdm_doc_iterator</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga4a198a0156650761c08df5d2909cb93f</anchor>
      <arglist>(sbr_Sbdm *sbdm, ato_Iterator **iter)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_Doc *</type>
      <name>sbr_sbdm_doc_firstv</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>gadce3b20072c9653644b1e50de95ab344</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_Doc *</type>
      <name>sbr_sbdm_doc_nextv</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga36c19ee59bc218d0c6e9317e46e53676</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_MsgReceipt *</type>
      <name>sbr_sbdm_receipt</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga860da8f5d6bdd99c800ddf27434c6704</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_sbdm_maxseveritycode</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga75c490c27138517e022bf4698e6e4447</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_sbdm_eventitem_count</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga7025ad5a746f91d1a49c62339508dc2b</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_sbdm_eventitem_iterator</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>gadd66f57f80e77435ce417cda52e93f6c</anchor>
      <arglist>(sbr_Sbdm *sbdm, ato_Iterator **iter)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_MsgEventItem *</type>
      <name>sbr_sbdm_eventitem_firstv</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga00d146c4c8b120de3b39f38bd5c65603</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_MsgEventItem *</type>
      <name>sbr_sbdm_eventitem_nextv</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>gaa7a9a165f7f99544394545aaeb146ab6</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_sbdm_timestamp_count</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>gacd98f4419d17b5ac69cd50f29b7ca89f</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_sbdm_timestamp_iterator</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga8997ed3f2702b897ee06edc50c64a904</anchor>
      <arglist>(sbr_Sbdm *sbdm, ato_Iterator **iter)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_MsgTimestamp *</type>
      <name>sbr_sbdm_timestamp_firstv</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>ga786a0ed6702f499e7adf92891d7e6b74</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_MsgTimestamp *</type>
      <name>sbr_sbdm_timestamp_nextv</name>
      <anchorfile>group__sbrcsr__api__csr__sbdm.html</anchorfile>
      <anchor>gad268975c8316d6def21c8aaf430c3f0c</anchor>
      <arglist>(sbr_Sbdm *sbdm)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_msgparty</name>
    <title>SBDM Party</title>
    <filename>group__sbrcsr__api__csr__msgparty.html</filename>
    <member kind="typedef">
      <type>struct _sbr_MsgParty</type>
      <name>sbr_MsgParty</name>
      <anchorfile>group__sbrcsr__api__csr__msgparty.html</anchorfile>
      <anchor>gaaea7ff1f0c5a268409d2b8abeb9ba46c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>sbr_eMsgPartyType</name>
      <anchorfile>group__sbrcsr__api__csr__msgparty.html</anchorfile>
      <anchor>ga2a411e6d9e13be8e21cb37d6c170534d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SBR_MSG_SENDER</name>
      <anchorfile>group__sbrcsr__api__csr__msgparty.html</anchorfile>
      <anchor>gga2a411e6d9e13be8e21cb37d6c170534da8d78f2674bb2726753d0a14db98a418a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SBR_MSG_RECEIVER</name>
      <anchorfile>group__sbrcsr__api__csr__msgparty.html</anchorfile>
      <anchor>gga2a411e6d9e13be8e21cb37d6c170534da86c432410c1b4c414de98eb8e32733ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgp_iddesignation</name>
      <anchorfile>group__sbrcsr__api__csr__msgparty.html</anchorfile>
      <anchor>ga8b84952867a4674d77ed91768d3e8e29</anchor>
      <arglist>(sbr_MsgParty *party)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgp_idname</name>
      <anchorfile>group__sbrcsr__api__csr__msgparty.html</anchorfile>
      <anchor>gac48de262f3d9f2d1642df85a28e96e1d</anchor>
      <arglist>(sbr_MsgParty *party)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_eMsgPartyType</type>
      <name>sbr_msgp_type</name>
      <anchorfile>group__sbrcsr__api__csr__msgparty.html</anchorfile>
      <anchor>gaa6e1a97bd1fd3fc0345893235a3d5dec</anchor>
      <arglist>(sbr_MsgParty *party)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgp_typestr</name>
      <anchorfile>group__sbrcsr__api__csr__msgparty.html</anchorfile>
      <anchor>ga84b5a4a49617eb499e7ede8453f80ed4</anchor>
      <arglist>(sbr_eMsgPartyType msgpartytype)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_msgrec</name>
    <title>SBDM Receipt</title>
    <filename>group__sbrcsr__api__csr__msgrec.html</filename>
    <member kind="typedef">
      <type>struct _sbr_MsgReceipt</type>
      <name>sbr_MsgReceipt</name>
      <anchorfile>group__sbrcsr__api__csr__msgrec.html</anchorfile>
      <anchor>gad07abf902e9c889f060a09821dbed454</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgrec_id</name>
      <anchorfile>group__sbrcsr__api__csr__msgrec.html</anchorfile>
      <anchor>ga4a833ae1b67f75690b8ef46599d7fbb2</anchor>
      <arglist>(sbr_MsgReceipt *receipt)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgrec_datetime</name>
      <anchorfile>group__sbrcsr__api__csr__msgrec.html</anchorfile>
      <anchor>ga3aecf6c482107885ed066ed8b9f77c06</anchor>
      <arglist>(sbr_MsgReceipt *receipt)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_msgts</name>
    <title>SBDM Timestamp</title>
    <filename>group__sbrcsr__api__csr__msgts.html</filename>
    <member kind="typedef">
      <type>struct _sbr_MsgTimestamp</type>
      <name>sbr_MsgTimestamp</name>
      <anchorfile>group__sbrcsr__api__csr__msgts.html</anchorfile>
      <anchor>gad0af21f9866f20fa128ae4afcb03d346</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgts_datetime</name>
      <anchorfile>group__sbrcsr__api__csr__msgts.html</anchorfile>
      <anchor>ga0d4bd7158db894d3fe785af4c587576f</anchor>
      <arglist>(sbr_MsgTimestamp *timestamp)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgts_source</name>
      <anchorfile>group__sbrcsr__api__csr__msgts.html</anchorfile>
      <anchor>ga6c360a6b18df6fbea42c0aa07326e001</anchor>
      <arglist>(sbr_MsgTimestamp *timestamp)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_msgevent</name>
    <title>SBDM Event</title>
    <filename>group__sbrcsr__api__csr__msgevent.html</filename>
    <member kind="typedef">
      <type>struct _sbr_MsgEventItem</type>
      <name>sbr_MsgEventItem</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>gae9c16b31ab02306d4e23d57ee96f4175</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct _sbr_MsgEventItemLocation</type>
      <name>sbr_MsgEventItemLocation</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>ga1e0956fa4201660f01901cb5d79b0876</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct _sbr_MsgEventItemParam</type>
      <name>sbr_MsgEventItemParam</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>gae6bd6ca8e626190ba54aa5169164e41d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgevent_code</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>ga8c769931ef00aa3d6f34cb7ec3eff16e</anchor>
      <arglist>(sbr_MsgEventItem *eventitem)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgevent_severity</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>ga8b94999183e3019cb7108d3d2b18112b</anchor>
      <arglist>(sbr_MsgEventItem *eventitem)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgevent_shortdesc</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>gab94b3533dd2c7589547bd1f2a61db1e3</anchor>
      <arglist>(sbr_MsgEventItem *eventitem)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgevent_longdesc</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>gaff69340cc549905e5b9c066780eeb13a</anchor>
      <arglist>(sbr_MsgEventItem *eventitem)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_msgevent_location_count</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>ga7eed0e32ba3acf38321335617d9acb1b</anchor>
      <arglist>(sbr_MsgEventItem *eventitem)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_msgevent_location_iterator</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>ga545b1de8c9310ed2ff1190a5eee388cd</anchor>
      <arglist>(sbr_MsgEventItem *eventitem, ato_Iterator **iter)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_MsgEventItemLocation *</type>
      <name>sbr_msgevent_location_firstv</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>ga641f627902523c2672474b3d3ae35ee8</anchor>
      <arglist>(sbr_MsgEventItem *eventitem)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_MsgEventItemLocation *</type>
      <name>sbr_msgevent_location_nextv</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>gaa1cca8c074d7fd8d677f9a5762d7037a</anchor>
      <arglist>(sbr_MsgEventItem *eventitem)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_msgevent_location_sequencenr</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>ga01b26882c3b2451822e1979d0525dd6c</anchor>
      <arglist>(sbr_MsgEventItemLocation *location)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgevent_location_path</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>gaca2b8929c41e348772a79ed5e62cda13</anchor>
      <arglist>(sbr_MsgEventItemLocation *location)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_msgevent_param_count</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>ga15382e47c7dbd2a1c0a0e9d2e00cbf7c</anchor>
      <arglist>(sbr_MsgEventItem *eventitem)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_msgevent_param_iterator</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>ga8c983850b262e1870c00d65652f80071</anchor>
      <arglist>(sbr_MsgEventItem *eventitem, ato_Iterator **iter)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_MsgEventItemParam *</type>
      <name>sbr_msgevent_param_firstv</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>ga51578e8f1f0ddce68a83855b7dabc500</anchor>
      <arglist>(sbr_MsgEventItem *eventitem)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_MsgEventItemParam *</type>
      <name>sbr_msgevent_param_nextv</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>gaa3803d8974cad2db921220caeed009c4</anchor>
      <arglist>(sbr_MsgEventItem *eventitem)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgevent_param_name</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>ga771e242ee14f4f3ab7bd8753af8c3d0b</anchor>
      <arglist>(sbr_MsgEventItemParam *param)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_msgevent_param_value</name>
      <anchorfile>group__sbrcsr__api__csr__msgevent.html</anchorfile>
      <anchor>gada0133cce1ac852323aedb678ca7cf47</anchor>
      <arglist>(sbr_MsgEventItemParam *param)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_doc</name>
    <title>The Business Document</title>
    <filename>group__sbrcsr__api__csr__doc.html</filename>
    <member kind="typedef">
      <type>struct _sbr_Doc</type>
      <name>sbr_Doc</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>gaf93ed80b5d3fb7b77bb013b699cfb278</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_doc_iid</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>ga80192634af16d45d6bfbd0f6398f0a6b</anchor>
      <arglist>(sbr_Doc *doc)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_doc_content</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>gab463d994e808d5ad6c045cbcab5ffebc</anchor>
      <arglist>(sbr_Doc *doc)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_doc_governmentid</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>gae7177370c708a18babf5f07662c5e3cc</anchor>
      <arglist>(sbr_Doc *doc)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_doc_businessid</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>gab5431b2bcc4619bc65b74767ee0ee835</anchor>
      <arglist>(sbr_Doc *doc)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_doc_createtime</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>ga44cb81b5af7ad11cd00aa89b203b901d</anchor>
      <arglist>(sbr_Doc *doc)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_doc_validationuri</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>ga1e7b070288be34b4083fb2ed44268427</anchor>
      <arglist>(sbr_Doc *doc)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_doc_sequencenr</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>ga7a8b90a37e3daf823cf92818247cdd4e</anchor>
      <arglist>(sbr_Doc *doc)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_eMsgSourceType</type>
      <name>sbr_doc_msgsourcetype</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>ga29e56664d1675c916afadf6e4f01c4ae</anchor>
      <arglist>(sbr_Doc *doc)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_doc_setcontent</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>ga74de0cb5c46cde13228c628336224a1a</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Doc *doc, const char *content, ato_eParamAction contentaction)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_doc_setcontentref</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>ga02cce5985d784eabc15d5ce251f38050</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Doc *doc, char *content, ato_eParamAction contentaction)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_doc_setvalidationuri</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>gaf2c2054057cc18e57c2c5c2a069273b9</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Doc *doc, const char *validationuri)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_doc_setgovernmentid</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>gaeb83e1d511a74f78f949705305787125</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Doc *doc, const char *governmentid)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_doc_setbusinessid</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>gaa3f9de66c314105c3c4f436991d0d680</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Doc *doc, const char *businessid)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_doc_setcreatetime</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>ga433c88ce8eec96ca9d532f0e654e1248</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Doc *doc, time_t createtime)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_doc_attachment_count</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>ga62f3f8a63bcfbc605ccf0dc3b820841c</anchor>
      <arglist>(sbr_Doc *doc)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT void</type>
      <name>sbr_doc_attachment_iterator</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>ga1530fdb3d0cd82cabab2f984765f9048</anchor>
      <arglist>(sbr_Doc *doc, ato_Iterator **iter)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_DocA *</type>
      <name>sbr_doc_attachment_firstv</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>ga29990d522861bfe963ac6119b50bf283</anchor>
      <arglist>(sbr_Doc *doc)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_DocA *</type>
      <name>sbr_doc_attachment_nextv</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>ga49b2e0dd894b25d13bd22cae7b471697</anchor>
      <arglist>(sbr_Doc *doc)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_doc_attachment_add</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>ga7b57044349d1b6149239d2016083901c</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Doc *doc, sbr_DocA **attachment, const char *description, const char *filename, const char *contenttype)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_doc_attachment_remove</name>
      <anchorfile>group__sbrcsr__api__csr__doc.html</anchorfile>
      <anchor>gaa573b858c9bfff445ca2b51a066fdb91</anchor>
      <arglist>(ato_Ctx *ctx, sbr_Doc *doc, sbr_DocA *attachment)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api_csr_doca</name>
    <title>The Business Document Attachment</title>
    <filename>group__sbrcsr__api__csr__doca.html</filename>
    <member kind="typedef">
      <type>struct _sbr_DocA</type>
      <name>sbr_DocA</name>
      <anchorfile>group__sbrcsr__api__csr__doca.html</anchorfile>
      <anchor>ga8fe091a801f2a74a0cfd0fd92c36e68e</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_doca_iid</name>
      <anchorfile>group__sbrcsr__api__csr__doca.html</anchorfile>
      <anchor>ga3485ed88a0ddabb31f64a3b7cfeb3f94</anchor>
      <arglist>(sbr_DocA *attachment)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT ato_String *</type>
      <name>sbr_doca_content</name>
      <anchorfile>group__sbrcsr__api__csr__doca.html</anchorfile>
      <anchor>ga672cfa7afc740b80b725b1a615ffe012</anchor>
      <arglist>(sbr_DocA *attachment)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_doca_contenttype</name>
      <anchorfile>group__sbrcsr__api__csr__doca.html</anchorfile>
      <anchor>ga4dd1698038452950bb07c375b99b1413</anchor>
      <arglist>(sbr_DocA *attachment)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_doca_description</name>
      <anchorfile>group__sbrcsr__api__csr__doca.html</anchorfile>
      <anchor>gaacb98d5cbbe80cabd39f0f44c13d0248</anchor>
      <arglist>(sbr_DocA *attachment)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT const char *</type>
      <name>sbr_doca_filename</name>
      <anchorfile>group__sbrcsr__api__csr__doca.html</anchorfile>
      <anchor>gae1e485ba677523ad06d494fb25cd19eb</anchor>
      <arglist>(sbr_DocA *attachment)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT size_t</type>
      <name>sbr_doca_sequencenr</name>
      <anchorfile>group__sbrcsr__api__csr__doca.html</anchorfile>
      <anchor>gaf70aa7fe0ee078389f4f0c65e951f905</anchor>
      <arglist>(sbr_DocA *attachment)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT sbr_eMsgSourceType</type>
      <name>sbr_doca_msgsourcetype</name>
      <anchorfile>group__sbrcsr__api__csr__doca.html</anchorfile>
      <anchor>ga3a4da04a5078d6be716ac1d099d75751</anchor>
      <arglist>(sbr_DocA *attachment)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_doca_setcontent</name>
      <anchorfile>group__sbrcsr__api__csr__doca.html</anchorfile>
      <anchor>gaf53b0cf35a4542117f2ed799a154e574</anchor>
      <arglist>(ato_Ctx *ctx, sbr_DocA *attachment, ato_String *content, ato_eParamAction contentaction)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_doca_setdescription</name>
      <anchorfile>group__sbrcsr__api__csr__doca.html</anchorfile>
      <anchor>gae4d9f202c10b62d31cfc42fc4383960b</anchor>
      <arglist>(ato_Ctx *ctx, sbr_DocA *attachment, const char *description)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_doca_setfilename</name>
      <anchorfile>group__sbrcsr__api__csr__doca.html</anchorfile>
      <anchor>ga21f99f54bae1350ebb596a37451c36be</anchor>
      <arglist>(ato_Ctx *ctx, sbr_DocA *attachment, const char *filename)</arglist>
    </member>
    <member kind="function">
      <type>SBR_CSR_EXPORT int</type>
      <name>sbr_doca_setcontenttype</name>
      <anchorfile>group__sbrcsr__api__csr__doca.html</anchorfile>
      <anchor>gaa187ba5d88d65b2c087605264b03e860</anchor>
      <arglist>(ato_Ctx *ctx, sbr_DocA *attachment, const char *contenttype)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>sbrcsr_external_apis</name>
    <title>Dependent APIs</title>
    <filename>group__sbrcsr__external__apis.html</filename>
  </compound>
  <compound kind="group">
    <name>sbrcsr</name>
    <title>SBR CSR</title>
    <filename>group__sbrcsr.html</filename>
    <subgroup>sbrcsr_overview</subgroup>
    <subgroup>sbrcsr_gettingstarted</subgroup>
    <subgroup>sbrcsr_api</subgroup>
  </compound>
  <compound kind="group">
    <name>sbrcsr_overview</name>
    <title>Overview</title>
    <filename>group__sbrcsr__overview.html</filename>
    <subgroup>sbrcsr_intro</subgroup>
    <subgroup>sbrcsr_thirdparty</subgroup>
    <subgroup>sbrcsr_designnotes</subgroup>
    <subgroup>sbrcsr_config</subgroup>
  </compound>
  <compound kind="group">
    <name>sbrcsr_gettingstarted</name>
    <title>Getting Started</title>
    <filename>group__sbrcsr__gettingstarted.html</filename>
    <subgroup>sbrcsr_gettingstarted_summary</subgroup>
    <subgroup>sbrcsr_gettingstarted_init</subgroup>
    <subgroup>sbrcsr_gettingstarted_csr</subgroup>
    <subgroup>sbrcsr_gettingstarted_akm</subgroup>
    <subgroup>sbrcsr_gettingstarted_stm</subgroup>
    <subgroup>sbrcsr_gettingstarted_all</subgroup>
    <subgroup>sbrcsr_gettingstarted_error</subgroup>
  </compound>
  <compound kind="group">
    <name>sbrcsr_api</name>
    <title>API</title>
    <filename>group__sbrcsr__api.html</filename>
    <subgroup>sbrcsr_api_csr_types</subgroup>
    <subgroup>sbrcsr_api_csr_lib</subgroup>
    <subgroup>sbrcsr_api_csr</subgroup>
    <subgroup>sbrcsr_api_csr_reqres</subgroup>
    <subgroup>sbrcsr_api_csr_sbdmetc</subgroup>
  </compound>
  <compound kind="group">
    <name>sbrcsr_gettingstarted_summary</name>
    <title>Summary</title>
    <filename>group__sbrcsr__gettingstarted__summary.html</filename>
  </compound>
  <compound kind="group">
    <name>sbrcsr_gettingstarted_init</name>
    <title>Startup and Shutdown</title>
    <filename>group__sbrcsr__gettingstarted__init.html</filename>
    <docanchor file="group__sbrcsr__gettingstarted__init.html" title="Global vars">sbrcsr_gettingstarted_init_globals</docanchor>
    <docanchor file="group__sbrcsr__gettingstarted__init.html" title="Initialise">sbrcsr_gettingstarted_init_init</docanchor>
    <docanchor file="group__sbrcsr__gettingstarted__init.html" title="Configuration">sbrcsr_gettingstarted_init_cfg</docanchor>
    <docanchor file="group__sbrcsr__gettingstarted__init.html" title="Deinitialise">sbrcsr_gettingstarted_init_deinit</docanchor>
  </compound>
  <compound kind="group">
    <name>sbrcsr_gettingstarted_csr</name>
    <title>Using CSR</title>
    <filename>group__sbrcsr__gettingstarted__csr.html</filename>
    <docanchor file="group__sbrcsr__gettingstarted__csr.html" title="Using the CSR API involves">sbrcsr_gettingstarted_csr_intro</docanchor>
    <docanchor file="group__sbrcsr__gettingstarted__csr.html" title="Create the CSR object">sbrcsr_gettingstarted_csr_csr</docanchor>
    <docanchor file="group__sbrcsr__gettingstarted__csr.html" title="Create the CSR Request object">sbrcsr_gettingstarted_csr_req</docanchor>
    <docanchor file="group__sbrcsr__gettingstarted__csr.html" title="Submit the Request">sbrcsr_gettingstarted_csr_submit</docanchor>
    <docanchor file="group__sbrcsr__gettingstarted__csr.html" title="Query the Response">sbrcsr_gettingstarted_csr_res</docanchor>
    <docanchor file="group__sbrcsr__gettingstarted__csr.html" title="Cleanup">sbrcsr_gettingstarted_csr_cleanup</docanchor>
  </compound>
  <compound kind="group">
    <name>sbrcsr_gettingstarted_akm</name>
    <title>Getting credentials</title>
    <filename>group__sbrcsr__gettingstarted__akm.html</filename>
    <docanchor file="group__sbrcsr__gettingstarted__akm.html" title="Introduction">sbrcsr_gettingstarted_akm_intro</docanchor>
  </compound>
  <compound kind="group">
    <name>sbrcsr_gettingstarted_stm</name>
    <title>Getting a SecurityToken</title>
    <filename>group__sbrcsr__gettingstarted__stm.html</filename>
    <docanchor file="group__sbrcsr__gettingstarted__stm.html" title="Introduction">sbrcsr_gettingstarted_stm_intro</docanchor>
  </compound>
  <compound kind="group">
    <name>sbrcsr_gettingstarted_all</name>
    <title>All together</title>
    <filename>group__sbrcsr__gettingstarted__all.html</filename>
  </compound>
  <compound kind="group">
    <name>sbrcsr_gettingstarted_error</name>
    <title>Error handling</title>
    <filename>group__sbrcsr__gettingstarted__error.html</filename>
    <docanchor file="group__sbrcsr__gettingstarted__error.html" title="Overview">sbrcsr_gettingstarted_error_overview</docanchor>
    <docanchor file="group__sbrcsr__gettingstarted__error.html" title="Business Document Errors">sbrcsr_gettingstarted_error_business</docanchor>
    <docanchor file="group__sbrcsr__gettingstarted__error.html" title="Handling API Errors">sbrcsr_gettingstarted_error_handling</docanchor>
  </compound>
  <compound kind="group">
    <name>sbrcsr_intro</name>
    <title>Introduction</title>
    <filename>group__sbrcsr__intro.html</filename>
  </compound>
  <compound kind="group">
    <name>sbrcsr_thirdparty</name>
    <title>Third party dependencies and licensing</title>
    <filename>group__sbrcsr__thirdparty.html</filename>
  </compound>
  <compound kind="group">
    <name>sbrcsr_designnotes</name>
    <title>Design notes</title>
    <filename>group__sbrcsr__designnotes.html</filename>
    <docanchor file="group__sbrcsr__designnotes.html" title="Content">sbrcsr_designnotes_content</docanchor>
    <docanchor file="group__sbrcsr__designnotes.html" title="Usage">sbrcsr_designnotes_usage</docanchor>
  </compound>
  <compound kind="group">
    <name>sbrcsr_config</name>
    <title>Configuration</title>
    <filename>group__sbrcsr__config.html</filename>
  </compound>
</tagfile>
