<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile doxygen_version="1.9.2">
  <compound kind="group">
    <name>atoakm_api_types_modules</name>
    <title>Module defines</title>
    <filename>group__atoakm__api__types__modules.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_LIBRARY</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>ga97432edb0f4ddea93addc08d1e81de90</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_MODULE_LIB</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>ga684dca2b9611227c7572609aea40274a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_MODULE_KS</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>ga87d9733081175dd68c63d03ebcbf71df</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_MODULE_CR</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>gaff0ec45b3d913ffc741cd027f9cb5c6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_MODULE_CRR</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>ga1dd9c441aaee6258acb10df146032d81</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_MODULE_ERRFN</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>gad36831a9728380dfac5a0aa1d0643d6b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_MODULE_KSPROP</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>gaf71ff64ea58ebed0a181458f354ef51a</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_MODULEID_LIB</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>ga7fa232f46ffb570796b3fb4d5ebc32a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_MODULEID_KS</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>gae76e9d0f783ab1f06fd1bebefb87ef66</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_MODULEID_CR</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>ga7293991c5ef1789329d70969c10083dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_MODULEID_CRR</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>ga557f0d4e1ab9e65a26e9d229df80e187</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_MODULEID_ERRFN</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>gade42fe4386d8675894015bd263c2ef0f</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_MODULEID_KSPROP</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>gaa8d28946b637f7e634efb8c0bf462389</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_INIT_ALL</name>
      <anchorfile>group__atoakm__api__types__modules.html</anchorfile>
      <anchor>gab4a4bf786e3d8a77088728e7a2727fd0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>atoakm_api_types_config</name>
    <title>Configuration Values</title>
    <filename>group__atoakm__api__types__config.html</filename>
  </compound>
  <compound kind="group">
    <name>atoakm_api_types_errcodes</name>
    <title>AKM Error codes</title>
    <filename>group__atoakm__api__types__errcodes.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_MIN</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>gaa6ffab7cbf9a78b91b7291780af6364b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_GENERAL</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>ga7e40bd47ea07b10c699ed69f02f3f386</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_NETSENDER</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>ga2e5e7ee08a742578b836bb037947b87e</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_NETRECEIVER</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>gaa3af2b0ee07f0eb25274a7ffd27c7a1c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_NETUNAVAILABLE</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>ga1e823aa82fea6e536ce39849c2b7e6aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_NETCOMMS</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>gacbdfe16a5ad1452bb231f73195f4400c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_NETTIMEOUT</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>gae6ff88838602a1c8bb734ab2b62cae71</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_CRYPTO</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>ga6e15a130696139ea22e472cf25a1cb42</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_NOTRENEWABLE</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>gad62f52becc4798fb831466adc47d72d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_RENEW</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>ga56add502e25e0a7921412ae3f8c55f3b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_CREDNOTFOUND</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>gac6c5fd18df399ad530f20c4f27cb3a24</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_ALIASEXISTS</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>ga8dae10b9dfde5851d76d61f06e9cf212</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_KEYSTORE_CORRUPTED</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>gaf8e886aa6ea4f93fea0f602d29f39a13</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_BADPWD</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>ga9849573228fae38eb5ead193aafa29d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_PWDDEST</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>gac72a0ca03f87305e53995fea82ec269b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_SAVE</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>ga049edd0e848aadcba74b02e5c9140a24</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_INTEGRITYVALUE</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>ga7adccf19fff9c47d2b945ebdf989d8e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_RENEWNOTCALLED</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>ga0f0aac620f0cd843ab9fbbc852af15d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_PWDPOLICY</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>ga67747ecd270cb23147b90417ab9280dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_COPYCREDENTIAL</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>gaeab834318ae65ddf0700a458c1c77698</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_DUPLICATECR</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>ga256a90e60f062e30487aad09dedd62dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_LOAD</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>ga18e2a464cdcdbea60f8fe005f4dc08f6</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_RENEW_NOTAVAILABLE</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>gaccca4c455a0a85c817fb524ee7cffb3b</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_PWD</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>gacaec473b9089d362ca1588831051d9b9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_AKM_ERR_MAX</name>
      <anchorfile>group__atoakm__api__types__errcodes.html</anchorfile>
      <anchor>gadf2a11740d1d9815eb96e336a6b5382e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>atoakm_api_types</name>
    <title>Types</title>
    <filename>group__atoakm__api__types.html</filename>
    <subgroup>atoakm_api_types_modules</subgroup>
    <subgroup>atoakm_api_types_config</subgroup>
  </compound>
  <compound kind="group">
    <name>atoakm_api_lib</name>
    <title>Library</title>
    <filename>group__atoakm__api__lib.html</filename>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_akm_version</name>
      <anchorfile>group__atoakm__api__lib.html</anchorfile>
      <anchor>ga25b74f47ee167150d94427e72fceba69</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_akm_init</name>
      <anchorfile>group__atoakm__api__lib.html</anchorfile>
      <anchor>ga2f1c66e84a8c71fb71ba21d0fbcf0005</anchor>
      <arglist>(ato_Ctx *ctx, unsigned short flag)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT void</type>
      <name>ato_akm_deinit</name>
      <anchorfile>group__atoakm__api__lib.html</anchorfile>
      <anchor>ga119d799963eda36eced2baf5c7abbddf</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_akm_default_dir</name>
      <anchorfile>group__atoakm__api__lib.html</anchorfile>
      <anchor>ga381ba8bae4584e525aa8611b96bc8a08</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_akm_default_ksfile</name>
      <anchorfile>group__atoakm__api__lib.html</anchorfile>
      <anchor>gadf3cc9f6387ae4dc782e4619aea19916</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_akm_default_kspath</name>
      <anchorfile>group__atoakm__api__lib.html</anchorfile>
      <anchor>gaa42756b51e47c4b9d2bbf5a37aecd266</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_akm_loadks</name>
      <anchorfile>group__atoakm__api__lib.html</anchorfile>
      <anchor>ga2cfa70466d657d328b896e987ce36f79</anchor>
      <arglist>(ato_Ctx *ctx, char **buffer, const char *dirname, const char *filename)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_akm_saveks</name>
      <anchorfile>group__atoakm__api__lib.html</anchorfile>
      <anchor>ga011e0e9c82c9fe90c46c53f98d664685</anchor>
      <arglist>(ato_Ctx *ctx, const char *buffer, const char *dirname, const char *filename)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>atoakm_api_ks</name>
    <title>Keystore</title>
    <filename>group__atoakm__api__ks.html</filename>
    <member kind="typedef">
      <type>struct _ato_Keystore</type>
      <name>ato_Keystore</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>ga4a06d5737990809ff0d0174cfaaa29e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_ks_create</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>ga91e78301dee92716a0dc2b5fddfbf903</anchor>
      <arglist>(ato_Ctx *ctx, ato_Keystore **ks, const char *buffer, const ato_ksProperties *properties)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT void *</type>
      <name>ato_ks_free</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>gad23f73ef4c85edc23dd22c38470274df</anchor>
      <arglist>(ato_Keystore *ks)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT ato_ksProperties *</type>
      <name>ato_ks_properties</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>gaf01481be77576e0d36ba4e282acd18e0</anchor>
      <arglist>(ato_Keystore *ks)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT bool</type>
      <name>ato_ks_ismodified</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>gacce18fc827e874d9adc6024e2a11ec88</anchor>
      <arglist>(ato_Keystore *ks)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT bool</type>
      <name>ato_ks_isvalid</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>ga7e7f481397e1c1dad1e1719e5715a441</anchor>
      <arglist>(ato_Keystore *ks)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_ks_save</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>gad30cc1ddf07f0f247f73bf8bd4da8d7e</anchor>
      <arglist>(ato_Ctx *ctx, ato_Keystore *ks, char **buffer)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT size_t</type>
      <name>ato_ks_count</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>ga1aed40e9c15847d83a05bb9cf36852a3</anchor>
      <arglist>(ato_Keystore *ks, ato_eCredfilter filter)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT ato_Credential *</type>
      <name>ato_ks_credential</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>ga7a87a8eb4866677d7a28f1863b2d1f61</anchor>
      <arglist>(ato_Keystore *ks, const char *alias)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT size_t</type>
      <name>ato_ks_credentials</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>ga1c6ec75e31f24df1324f9b996d67b139</anchor>
      <arglist>(ato_Keystore *ks, ato_Credential ***creds, ato_eCredfilter filter)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT size_t</type>
      <name>ato_ks_delete</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>gaca6485bc604582de9f0cf542ead61207</anchor>
      <arglist>(ato_Keystore *ks, const char *alias)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_ks_checkcorrectpwd</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>ga61def08b9a81e895a1f78fea2db536c9</anchor>
      <arglist>(ato_Ctx *ctx, ato_Keystore *ks, const char *pwd)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_ks_iscorrectpwd</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>ga00e241c817baa16e1005e21ec699cc2d</anchor>
      <arglist>(ato_Ctx *ctx, ato_Keystore *ks, bool *correct, const char *pwd)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_ks_changepwd</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>ga9fbcd6dc28fdfacc12a27c252a3e89d1</anchor>
      <arglist>(ato_Ctx *ctx, ato_Keystore *ks, const char *pwd, const char *newpwd)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT bool</type>
      <name>ato_ks_pwdpolicy_isvalid</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>gae44d2d46a4e4a1b5334f311fb1bcbb98</anchor>
      <arglist>(ato_Keystore *ks, const char *pwd)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_ks_pwdpolicy_desc</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>ga0b4c3e426526a24718566351caf2f87a</anchor>
      <arglist>(ato_Keystore *ks)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_ks_addcredential</name>
      <anchorfile>group__atoakm__api__ks.html</anchorfile>
      <anchor>ga89741ad16e610d5d5cf013cd359084e9</anchor>
      <arglist>(ato_Ctx *ctx, ato_Keystore *ks, const char *pwd, ato_Credential *cr, const char *crpwd, bool isreplacable)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>atoakm_api_cr</name>
    <title>Credential</title>
    <filename>group__atoakm__api__cr.html</filename>
    <member kind="typedef">
      <type>struct _ato_Credential</type>
      <name>ato_Credential</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga225f8bb8c715012d56a880de30200c57</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ato_eCredtype</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga72a63ef1f785e1d7a9c32b1f90cbe972</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ATO_NONE</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gga72a63ef1f785e1d7a9c32b1f90cbe972aa2fbe918faa8897e3ffb74a09c3516ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ATO_CREDUSER</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gga72a63ef1f785e1d7a9c32b1f90cbe972a66db100d34277f507bbc0899690d6ec7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ATO_CREDDEVICE</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gga72a63ef1f785e1d7a9c32b1f90cbe972a344a7bbed8b625b467df60766ec8bbc7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ato_eCredfilter</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga224023356c405260a2ef2ce4f5f21e82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ATO_FILTER_ALL</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gga224023356c405260a2ef2ce4f5f21e82a88b13b858e05eef191cbfe29f75dbbeb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ATO_FILTER_VALID</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gga224023356c405260a2ef2ce4f5f21e82adea2926142fb98be8003eebd8cd527a3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ATO_FILTER_USER</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gga224023356c405260a2ef2ce4f5f21e82af94c1d4667db24fbc9c4c22e93e7efab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ATO_FILTER_VALIDUSER</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gga224023356c405260a2ef2ce4f5f21e82a5ab29d75c65492606526268854218ec9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ATO_FILTER_DEVICE</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gga224023356c405260a2ef2ce4f5f21e82ad6885c7611ae4b4a3cae1fcbb0c716c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ATO_FILTER_VALIDDEVICE</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gga224023356c405260a2ef2ce4f5f21e82a2c7ecb8f021ae7cd14c7e5e1bdc69982</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_id</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga6565787d76cfed64d6b15f30a7cbdd5e</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_alias</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga378be27b16cb292693823292fc98d7a8</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT ato_eCredtype</type>
      <name>ato_cr_type</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga6db8bc91f7f307f9a6fb04010d4d4ae2</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_abn</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gaebe950c142b996a57340aeae59cbf054</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_legalname</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga4f317a22effb5001b48ea80fde19456a</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_serialnr</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gad1ba8c4f097f29275c2a7f2248e7fee2</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_creationdate</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga1811caef17010849c98dffb457beb391</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_notbefore</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gac346f9ce6be91e41895d112da4a03671</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_notafter</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga259f5f20d7d2582034970bdda4122cf5</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_sha1fingerprint</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga6634c43239e933ffd85f7ec7590aa1cf</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_sha1fingerprint_hex</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga914ac2f9e2b75a9e3307d762b06089b1</anchor>
      <arglist>(ato_Ctx *ctx, ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_personid</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga410f4bcdb853daa6d6625ca96dd1c84d</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_devicename</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gaf64eded9e88ee9c4c3832d4e8ac1836c</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_givenames</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gabe662f79ba3ed86089e138239ff39196</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_cr_familyname</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga53d76426da2a2b443c6f0dbe7fd95c14</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT bool</type>
      <name>ato_cr_matchesfilter</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gad04eb45cd0bfed7dfcbb8c9782bb5393</anchor>
      <arglist>(ato_Credential *cr, ato_eCredfilter filter)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT bool</type>
      <name>ato_cr_iscurrent</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gaed247ec07c391f4227de629116ce7727</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT bool</type>
      <name>ato_cr_ismodified</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gac5f08c6ac8702d4334036e02433eb6e8</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT bool</type>
      <name>ato_cr_isrenewed</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gaee9c5ccd3018d6fabbdc47933968a6d8</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT bool</type>
      <name>ato_cr_isrenewable</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga86cf37e4984316a4dca6960fbf28166e</anchor>
      <arglist>(ato_Ctx *ctx, ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT bool</type>
      <name>ato_is_integrity_valid</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga4bcd60b56f9d6fd6081646e466121a1c</anchor>
      <arglist>(ato_Ctx *ctx, ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_cr_checkcorrectpwd</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga45a4544f1469b7ed8ead59c9eb444e2b</anchor>
      <arglist>(ato_Ctx *ctx, ato_Credential *cr, const char *pwd)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_cr_iscorrectpwd</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gaf13ab5367c952843203747161bc0a291</anchor>
      <arglist>(ato_Ctx *ctx, ato_Credential *cr, bool *correct, const char *pwd)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT bool</type>
      <name>ato_cr_ispbe2</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga7d19b92ad7b4539aea41fb47ae0921cf</anchor>
      <arglist>(ato_Ctx *ctx, ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_cr_certificate</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gabb67effb02921efbfaa14a5b43d71cf5</anchor>
      <arglist>(ato_Ctx *ctx, ato_Credential *cr, ato_String **certificate)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_cr_chain</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gac92402d856bb6da43c455fa7b01cc077</anchor>
      <arglist>(ato_Ctx *ctx, ato_Credential *cr, ato_String **certificates)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_cr_privatekey</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gaa3fb8f7e87502e48febc25729b395f59</anchor>
      <arglist>(ato_Ctx *ctx, ato_Credential *cr, ato_String **privatekey, const char *pwd)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_cr_p12</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga7558508097da031a0544cf4ba8abf65b</anchor>
      <arglist>(ato_Ctx *ctx, ato_Credential *cr, ato_String **p12, const char *pwd)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT ato_String *</type>
      <name>ato_cr_integrityvalue</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga8b7e7ba519a70ae73161dd6dd1093b3f</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT ato_String *</type>
      <name>ato_cr_b64salt</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga8818b3146fcf6311863f03d67916eabd</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT ato_String *</type>
      <name>ato_cr_b64p7</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga186048c5c6fdd19e698c0c37ee99efb2</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT ato_String *</type>
      <name>ato_cr_b64p8</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gaa700cc3f28f26012665d9589e698e7dd</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_cr_sign</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gad94a5f8b1d4d009678969fdb58e6d2ef</anchor>
      <arglist>(ato_Ctx *ctx, ato_Credential *cr, ato_String **signed_data, const char *pwd, const char *data, size_t len)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_cr_request_generate</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gaa43510bdd061e5f14876128070b94ebc</anchor>
      <arglist>(ato_Ctx *ctx, ato_Credential *cr, const char *pwd, const char *id)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT ato_String *</type>
      <name>ato_cr_b64p10</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gaa2924e10ec1804d145d440b531ebee22</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT ato_String *</type>
      <name>ato_cr_request_data</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>ga43e31c4793a4b29bb8cc5484454223c3</anchor>
      <arglist>(ato_Credential *cr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT int</type>
      <name>ato_cr_request_process</name>
      <anchorfile>group__atoakm__api__cr.html</anchorfile>
      <anchor>gaf61e7aef42daf9bcc49558d8f9f9a39b</anchor>
      <arglist>(ato_Ctx *ctx, ato_Credential *cr, const char *responseData)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>atoakm_api_ksprop</name>
    <title>Keystore Properties</title>
    <filename>group__atoakm__api__ksprop.html</filename>
    <member kind="typedef">
      <type>struct _ato_ksProperties</type>
      <name>ato_ksProperties</name>
      <anchorfile>group__atoakm__api__ksprop.html</anchorfile>
      <anchor>gad1f22105e95b51720ad316288bc6dc13</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT ato_ksProperties *</type>
      <name>ato_ksprop_create</name>
      <anchorfile>group__atoakm__api__ksprop.html</anchorfile>
      <anchor>ga462812249e273ec2708a6d8048045f1c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT void *</type>
      <name>ato_ksprop_free</name>
      <anchorfile>group__atoakm__api__ksprop.html</anchorfile>
      <anchor>ga09eae80275c7b49c56b24b3558d10719</anchor>
      <arglist>(ato_ksProperties *ksprop)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_ksprop_ver</name>
      <anchorfile>group__atoakm__api__ksprop.html</anchorfile>
      <anchor>gaa672c4ab7fd327d764d0e7750cb8779f</anchor>
      <arglist>(const ato_ksProperties *ksprop)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_ksprop_salt</name>
      <anchorfile>group__atoakm__api__ksprop.html</anchorfile>
      <anchor>ga532fd74ada3d321fd177fbfdb8a0ad8c</anchor>
      <arglist>(const ato_ksProperties *ksprop)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_ksprop_PbeMode</name>
      <anchorfile>group__atoakm__api__ksprop.html</anchorfile>
      <anchor>gab33dffd54859b6fb0ac2f4edc4a9965b</anchor>
      <arglist>(const ato_ksProperties *ksprop)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT void</type>
      <name>ato_ksprop_PbeMode_Set</name>
      <anchorfile>group__atoakm__api__ksprop.html</anchorfile>
      <anchor>gad4908b56eac65776b1cda3a8044fede9</anchor>
      <arglist>(ato_Ctx *ctx, ato_ksProperties *ksprop, const char *pbemode)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_ksprop_var</name>
      <anchorfile>group__atoakm__api__ksprop.html</anchorfile>
      <anchor>ga1d739b99c7557cec11d99db7662c809e</anchor>
      <arglist>(ato_ksProperties *ksprop, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT void</type>
      <name>ato_ksprop_var_set</name>
      <anchorfile>group__atoakm__api__ksprop.html</anchorfile>
      <anchor>gab868b9d40621b51817d116249f428558</anchor>
      <arglist>(ato_ksProperties *ksprop, const char *name, const char *value)</arglist>
    </member>
    <member kind="function">
      <type>ATO_AKM_EXPORT const char *</type>
      <name>ato_ksprop_varn_checkIntegrityValue</name>
      <anchorfile>group__atoakm__api__ksprop.html</anchorfile>
      <anchor>ga40aa3fc8c731b2ea672d12c90c347dcf</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>atoakm_external_apis</name>
    <title>Dependent APIs</title>
    <filename>group__atoakm__external__apis.html</filename>
  </compound>
  <compound kind="group">
    <name>atoakm</name>
    <title>ATO AKM</title>
    <filename>group__atoakm.html</filename>
    <subgroup>atoakm_api_types_errcodes</subgroup>
    <subgroup>atoakm_overview</subgroup>
    <subgroup>atoakm_gettingstarted</subgroup>
    <subgroup>atoakm_api</subgroup>
  </compound>
  <compound kind="group">
    <name>atoakm_overview</name>
    <title>Overview</title>
    <filename>group__atoakm__overview.html</filename>
    <subgroup>atoakm_intro</subgroup>
    <subgroup>atoakm_thirdparty</subgroup>
    <subgroup>atoakm_designnotes</subgroup>
  </compound>
  <compound kind="group">
    <name>atoakm_gettingstarted</name>
    <title>Getting Started</title>
    <filename>group__atoakm__gettingstarted.html</filename>
    <subgroup>atoakm_gettingstarted_summary</subgroup>
    <subgroup>atoakm_gettingstarted_init</subgroup>
    <subgroup>atoakm_gettingstarted_akm</subgroup>
    <subgroup>atoakm_gettingstarted_all</subgroup>
    <subgroup>atoakm_gettingstarted_error</subgroup>
  </compound>
  <compound kind="group">
    <name>atoakm_api</name>
    <title>API</title>
    <filename>group__atoakm__api.html</filename>
    <subgroup>atoakm_api_types</subgroup>
    <subgroup>atoakm_api_lib</subgroup>
    <subgroup>atoakm_api_ks</subgroup>
    <subgroup>atoakm_api_cr</subgroup>
    <subgroup>atoakm_api_ksprop</subgroup>
  </compound>
  <compound kind="group">
    <name>atoakm_gettingstarted_summary</name>
    <title>Summary</title>
    <filename>group__atoakm__gettingstarted__summary.html</filename>
  </compound>
  <compound kind="group">
    <name>atoakm_gettingstarted_init</name>
    <title>Startup and Shutdown</title>
    <filename>group__atoakm__gettingstarted__init.html</filename>
    <docanchor file="group__atoakm__gettingstarted__init.html" title="Global vars">atoakm_gettingstarted_init_globals</docanchor>
    <docanchor file="group__atoakm__gettingstarted__init.html" title="Initialise">atoakm_gettingstarted_init_init</docanchor>
    <docanchor file="group__atoakm__gettingstarted__init.html" title="Configuration">atoakm_gettingstarted_init_cfg</docanchor>
    <docanchor file="group__atoakm__gettingstarted__init.html" title="Deinitialise">atoakm_gettingstarted_init_deinit</docanchor>
  </compound>
  <compound kind="group">
    <name>atoakm_gettingstarted_akm</name>
    <title>Using AKM &amp; getting credentials</title>
    <filename>group__atoakm__gettingstarted__akm.html</filename>
    <docanchor file="group__atoakm__gettingstarted__akm.html" title="Using the AKM API involves">atoakm_gettingstarted_akm_intro</docanchor>
    <docanchor file="group__atoakm__gettingstarted__akm.html" title="Create an keystore object">atoakm_gettingstarted_akm_create</docanchor>
    <docanchor file="group__atoakm__gettingstarted__akm.html" title="Get a credential for a given user/alias">atostm_gettingstarted_akm_cr</docanchor>
    <docanchor file="group__atoakm__gettingstarted__akm.html" title="Get DER encoded values">atostm_gettingstarted_akm_get</docanchor>
    <docanchor file="group__atoakm__gettingstarted__akm.html" title="Cleanup">atostm_gettingstarted_akm_cleanup</docanchor>
  </compound>
  <compound kind="group">
    <name>atoakm_gettingstarted_all</name>
    <title>All together</title>
    <filename>group__atoakm__gettingstarted__all.html</filename>
  </compound>
  <compound kind="group">
    <name>atoakm_gettingstarted_error</name>
    <title>Error handling</title>
    <filename>group__atoakm__gettingstarted__error.html</filename>
  </compound>
  <compound kind="group">
    <name>atoakm_intro</name>
    <title>Introduction</title>
    <filename>group__atoakm__intro.html</filename>
  </compound>
  <compound kind="group">
    <name>atoakm_thirdparty</name>
    <title>Third party dependencies and licensing</title>
    <filename>group__atoakm__thirdparty.html</filename>
  </compound>
  <compound kind="group">
    <name>atoakm_designnotes</name>
    <title>Design notes</title>
    <filename>group__atoakm__designnotes.html</filename>
    <docanchor file="group__atoakm__designnotes.html" title="Content">atoakm_designnotes_content</docanchor>
    <docanchor file="group__atoakm__designnotes.html" title="Usage">atoakm_designnotes_usage</docanchor>
    <docanchor file="group__atoakm__designnotes.html" title="Keystore Structure">atoakm_designnotes_ksstructure</docanchor>
    <docanchor file="group__atoakm__designnotes.html" title="Keystore Location">atoakm_designnotes_kslocation</docanchor>
  </compound>
</tagfile>
