#ifndef __ATO_AKM_KSPROP_H__
#define __ATO_AKM_KSPROP_H__

#include <stddef.h>

/** @addtogroup atoakm_api_ksprop

@{
*/

/**
The keystore properties object retrieved using ato_ks_properties().
*/
typedef struct _ato_ksProperties ato_ksProperties;

#ifdef __cplusplus
extern "C" {
#endif

/**
Create a properties object.

@return the newly created object or NULL if memory failure
*/
ATO_AKM_EXPORT ato_ksProperties *ato_ksprop_create(void);

/**
Free a properties object.

@param ksprop the properties object.
@return NULL.
*/
ATO_AKM_EXPORT void *ato_ksprop_free(ato_ksProperties *ksprop);

/**
Get the keystore version

@param ksprop the properties object associated with a keystore.
@return the version of the keystore or NULL if not associated with a keystore.
*/
ATO_AKM_EXPORT const char *ato_ksprop_ver(const ato_ksProperties *ksprop);

/**
Get the keystore salt

@param ksprop the properties object.
@return the salt of the keystore or NULL if not associated with a keystore.
*/
ATO_AKM_EXPORT const char *ato_ksprop_salt(const ato_ksProperties *ksprop);

/**
Get the pbe mode.

@param ksprop the properties object.
@return pbemode
*/
ATO_AKM_EXPORT const char *ato_ksprop_PbeMode(const ato_ksProperties *ksprop);

/**
Set the pbe mode. Do not use unless advised as this can cause compatibility issues with the website.
If pbemode is NULL then the call is ignored.

@param ctx the current thread local Context.
@param ksprop the properties object.
@param pbemode the pbe mode as a string.
*/
ATO_AKM_EXPORT void ato_ksprop_PbeMode_Set(ato_Ctx *ctx, ato_ksProperties *ksprop, const char *pbemode);

/**
Get the named value (string).

@param ksprop the properties object.
@param name variable name - case sensitive.
@return variable value.
*/
ATO_AKM_EXPORT const char *ato_ksprop_var(ato_ksProperties *ksprop, const char *name);

/**
Set the named value (string)

@param ksprop the properties object.
@param name variable name - case sensitive.
@param value - variable value.
*/
ATO_AKM_EXPORT void ato_ksprop_var_set(ato_ksProperties *ksprop, const char *name, const char *value);

/**
Name for variable checkIntegrityValue.

@return variable name.
*/
ATO_AKM_EXPORT const char *ato_ksprop_varn_checkIntegrityValue(void);

ATO_AKM_EXPORT int ato_ksprop_var_int(ato_ksProperties *ksprop, const char *name, int defvalue);

#ifdef __cplusplus
}
#endif

/*! @} */

#endif /*__ATO_AKM_KSPROP_H__*/
