#ifndef __ATO_AKM_CR_PRIVATE_H__
#define __ATO_AKM_CR_PRIVATE_H__

#include "atoakm/credential.h"

#ifdef __cplusplus
extern "C" {
#endif

//ATO_AKM_EXPORT ato_Crypto *ato_cr_crypto(ato_Credential *cr);


ATO_AKM_EXPORT int ato_cr_check_data(ato_Ctx *ctx, ato_Credential *cr);

ATO_AKM_EXPORT void set_now(time_t to_set);
ATO_AKM_EXPORT time_t get_now(void);

ATO_AKM_EXPORT void atoe_cr_check_data(ato_Ctx *ctx, ato_Credential *cr);
ATO_AKM_EXPORT void atoe_cr_request_generate(ato_Ctx *ctx, ato_Credential *cr, const char *pwd, const char *id);
ATO_AKM_EXPORT void atoe_cr_request_send(ato_Ctx *ctx, ato_Credential *cr);
ATO_AKM_EXPORT void atoe_cr_request_process(ato_Ctx *ctx, ato_Credential *cr, const char *responseData);
ATO_AKM_EXPORT void atoe_cr_renew(ato_Ctx *ctx, ato_Credential *cr, const char *pwd);
ATO_AKM_EXPORT void atoe_cr_sign(ato_Ctx *ctx, ato_Credential *cr, ato_String **signed_data, const char *pwd, const char *data, size_t len);
ATO_AKM_EXPORT void atoe_cr_privatekey(ato_Ctx *ctx, ato_Credential *cr, ato_String **privatekey, const char *pwd);
ATO_AKM_EXPORT void atoe_cr_p12(ato_Ctx *ctx, ato_Credential *cr, ato_String **p12, const char *pwd);
ATO_AKM_EXPORT void atoe_cr_certificate(ato_Ctx *ctx, ato_Credential *cr, ato_String **certificate);
ATO_AKM_EXPORT void atoe_cr_chain(ato_Ctx *ctx, ato_Credential *cr, ato_String **certificates);

ATO_AKM_EXPORT ato_String *atoe_cr_request_salt(ato_Credential *cr);
ATO_AKM_EXPORT ato_String *atoe_cr_request_p8(ato_Credential *cr);
ATO_AKM_EXPORT const char *atoe_cr_request_id(ato_Credential *cr);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_AKM_CR_PRIVATE_H__*/
