#ifndef __ATO_AKM_TYPES_H__
#define __ATO_AKM_TYPES_H__

/** @addtogroup atoakm_api_types

*/

/** @defgroup atoakm_api_types_modules Module defines
@ingroup atoakm_api_types
Each module within the library is individually defined by a name and id.
These can be used to target logging for particular modules and to identify the source of errors.
When setting logging, the MODULEID values can be bitwised or-ed.

Note that not all modules are necessarily exposed via a public API, even though they appear here.

@{
*/
#define ATO_AKM_LIBRARY "atoakm" /**< Short text Name of the library */
#define ATO_AKM_MODULE_LIB "lib" /**< Short text Name of the primary lib module */
#define ATO_AKM_MODULE_KS "ks" /**< Short text Name of the keystore module */
#define ATO_AKM_MODULE_CR "cr" /**< Short text Name of the credential module */
#define ATO_AKM_MODULE_CRR "crr" /**< Short text Name of the renewal module */
#define ATO_AKM_MODULE_ERRFN "errfn" /**< Short text Name of the error callback module */
#define ATO_AKM_MODULE_KSPROP "ksprop" /**< Short text Name of the keystore properties module */

#define ATO_AKM_MODULEID_LIB    0x00000001UL /**< The lib module id. */
#define ATO_AKM_MODULEID_KS     0x00000002UL /**< The keystore module id. */
#define ATO_AKM_MODULEID_CR     0x00000004UL /**< The credential module id. */
#define ATO_AKM_MODULEID_CRR    0x00000008UL /**< The renewal module id. */
#define ATO_AKM_MODULEID_ERRFN  0x00000010UL /**< The error callback module id. */
#define ATO_AKM_MODULEID_KSPROP 0x00000020UL /**< The keystore properties module id. */

/**
The ATO_AKM_INIT_... defines are used to control the initialisation that takes place. Currently
only ATO_AKM_INIT_ALL is defined.
*/
#define ATO_AKM_INIT_ALL 0xffff

/** @} */

#ifdef __cplusplus
extern "C" {
#endif

/** @defgroup atoakm_api_types_config Configuration Values
@ingroup atoakm_api_types
These values can optionally be used to access variables in the configuration file.

@{
*/


/** @} */

#ifdef __cplusplus
}
#endif

//@ingroup atoakm_api_types
/** @defgroup atoakm_api_types_errcodes AKM Error codes
@ingroup  atoakm
All errors are encapsulated in AKM specific errors.
For the underlying error, use ato_err_inner() to retrieve nested errors and their details.

@{
*/

#define ATO_AKM_ERR_MIN 12000 /**< The mimimum error number. */
#define ATO_AKM_ERR_GENERAL (ATO_AKM_ERR_MIN+1)  /**< For errors not otherwise specified. */

#define ATO_AKM_ERR_NETSENDER (ATO_AKM_ERR_MIN+2) /**< A SOAP fault generated by the sender, not including service unavailable. */
#define ATO_AKM_ERR_NETRECEIVER (ATO_AKM_ERR_MIN+3) /**< A SOAP fault generated by the receiver, not including service unavailable. */
#define ATO_AKM_ERR_NETUNAVAILABLE (ATO_AKM_ERR_MIN+4) /**< A SOAP fault where the remote service is unavailable. */
#define ATO_AKM_ERR_NETCOMMS (ATO_AKM_ERR_MIN+5) /**< A general network error has occurred, not including timeouts. */
#define ATO_AKM_ERR_NETTIMEOUT (ATO_AKM_ERR_MIN+6)  /**< A network time has occured trying to connect to a remote service. */

#define ATO_AKM_ERR_CRYPTO (ATO_AKM_ERR_MIN+7) /**< General cryptographic error. */
#define ATO_AKM_ERR_NOTRENEWABLE (ATO_AKM_ERR_MIN+8) /**< Credential is not renewable due to being created too recently. */
#define ATO_AKM_ERR_RENEW (ATO_AKM_ERR_MIN+9)  /**< Error renewing credential. */
#define ATO_AKM_ERR_CREDNOTFOUND (ATO_AKM_ERR_MIN+10) /**< Credential not found in keystore. */

#define ATO_AKM_ERR_ALIASEXISTS (ATO_AKM_ERR_MIN+11) /**< A credential with the given alias exists and is not replaceable. */
#define ATO_AKM_ERR_KEYSTORE_CORRUPTED (ATO_AKM_ERR_MIN+12) /**< Keystore is corrupted. */
#define ATO_AKM_ERR_BADPWD (ATO_AKM_ERR_MIN+13) /**< Bad password. */
#define ATO_AKM_ERR_PWDDEST (ATO_AKM_ERR_MIN+14) /**< The password for the target keystore is wrong. */

#define ATO_AKM_ERR_SAVE (ATO_AKM_ERR_MIN+15) /**< Error saving keystore. */
#define ATO_AKM_ERR_INTEGRITYVALUE (ATO_AKM_ERR_MIN+16) /**< Error validating integrity value. */
#define ATO_AKM_ERR_RENEWNOTCALLED (ATO_AKM_ERR_MIN+17) /**< Private key of a credential accessed without first calling renewall method. */
#define ATO_AKM_ERR_PWDPOLICY (ATO_AKM_ERR_MIN+18)  /**< The supplied password does not meet the strength requirements of the password policy. */
#define ATO_AKM_ERR_COPYCREDENTIAL (ATO_AKM_ERR_MIN+19) /**< Error during copycredential operation. */
#define ATO_AKM_ERR_DUPLICATECR (ATO_AKM_ERR_MIN+20) /**< Possible duplicate credential. */
#define ATO_AKM_ERR_LOAD (ATO_AKM_ERR_MIN+21) /**< Error loading keystore. */
#define ATO_AKM_ERR_RENEW_NOTAVAILABLE (ATO_AKM_ERR_MIN+22)  /**< Renewal not available for the given Certficate Authority (e.g. in a test environment). */

#define ATO_AKM_ERR_MISMATCHED_P7 (ATO_AKM_ERR_MIN+23)
#define ATO_AKM_ERR_INVALID_P7 (ATO_AKM_ERR_MIN+24)

#define ATO_AKM_ERR_PWD (ATO_AKM_ERR_MIN+25) /**< Password processing failed with possible corrupted P8 - see also ATO_AKM_ERR_BADPWD. */

#define ATO_AKM_ERR_MAX (ATO_AKM_ERR_MIN+200) /**< The maximum error number. */
/** @} */

#endif /*__ATO_AKM_TYPES_H__*/
