#ifndef __ATO_AKM_KS_INTERNAL_H__
#define __ATO_AKM_KS_INTERNAL_H__

#ifndef ATO_AKM_INTERNAL
#error "This file is for internal use only"
#endif

#include "atoakm/private/pkeystore.h"

#ifdef __cplusplus
extern "C" {
#endif

/** @internal
Return the salt for the keystore.
This is the default salt to use for any credential, in the keystore, which doesn't have its own salt.
@param ks the keystore object.
*/
extern const char *ato_ks_salt(ato_Keystore *ks);

extern int ato__ks_init(void);
extern void ato__ks_deinit(void);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_AKM_KS_INTERNAL_H__*/
