/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup atoakm_gettingstarted_all

Using AKM, ignoring "incidental" issues such as error and logging, and dropping some variables:

@code
ato_Cxt *ctx;
ato_CfgMgr *cfgmgr;

ato_si_set("Your Organisation Name Here", "ATO AKM Reference Client (C version)", "0.6", buildtime, hash);
ato_ctx_create(&ctx);
ato_cfgm_create(ctx, &cfgmgr, NULL, "test")
ato_base_init(ctx, ATO_BASE_INIT_ALL);
ato_akm_init(ctx, ATO_AKM_INIT_ALL);

ato_ks_create(ctx, &ks, xmlKeystoreBuf);

cr = ato_ks_credential(ks, alias);
if (ato_cr_isrenewable(cr) && ato_cr_renew(ctx, cr, password) != ATO_ERR_OK)
    logsomethingbutcarryon("Warning: renewal for '%s' failed\n", alias);
ato_cr_certificate(ctx, cr, &certificate);
ato_cr_privatekey(ctx, cr, &privatekey, password);

free(buffer);
ato_ks_free(ks);

ato_ctx_free(ctx);
ato_cfgm_free(cfgmgr);

ato_akm_deinit();
ato_base_deinit();
@endcode

*/
