/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup atoakm_gettingstarted_init

@section atoakm_gettingstarted_init_globals Global vars

Call the ato_si_set() method.
For example:

@code
ato_si_set("Your Organisation Name Here", "ATO AKM Reference Client (C version)", "0.6", buildtime, hash);
@endcode

@section atoakm_gettingstarted_init_init Initialise

The following initialises the base SDK and the AKM SDK. The ".._INIT_.." flags control the underlying initialisation.
However only the given values are currently supported.

@code
    int errcode = ATO_ERR_OK;
    ato_Ctx *ctx = NULL;

    // We need at least one context for the main thread prior to initialisation
    ato_ctx_create(&ctx);

    errcode = ato_base_init(ctx, ATO_BASE_INIT_ALL);

    // The following is required only if using the ATOAKM SDK
    if (errcode == ATO_ERR_OK)
        errcode = ato_akm_init(ctx, ATO_AKM_INIT_ALL);
@endcode

@section atoakm_gettingstarted_init_cfg Configuration

In order to do anything useful, we need to load a configuration as described in

- ATO Base section @ref atobase_init_config "Initialise a Configuration".

@section atoakm_gettingstarted_init_deinit Deinitialise

At the end of the program lifetime, and after all threads are finished, corresponding config/ctx free and
deinitialisation methods must be called.
@code
    ato_ctx_free(ctx);
    ato_cfgm_free(cfgmgr);

    ato_akm_deinit();
    ato_base_deinit();
@endcode
*/
