#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <time.h>
#include <stdarg.h>

#include "atobase/all.h"
#include "atoakm/all.h"

#include "../common/util.h"
#include "sys.h"

/*********************************************************************************/
int init(ato_Ctx *ctx)
{
    int errcode = ato_base_init(ctx, ATO_BASE_INIT_ALL);
    if (errcode == ATO_ERR_OK)
        errcode = ato_akm_init(ctx, ATO_AKM_INIT_ALL);
    return errcode;
}

void deinit()
{

    ato_akm_deinit();
    ato_base_deinit();
}

int loadks(ato_Ctx *ctx, ato_Keystore **ks, const char *dirname, const char *filename)
{
    int errcode = ATO_ERR_OK;
    char *buf = NULL;
    char dirbuf[FILENAME_MAX+1];

    assert(ks != NULL);

    if (*dirname == '.') {
        if (utl_filedir(dirbuf, filename) != NULL) // search in current folder or above
            dirname = dirbuf;
    }

    printf("Loading keystore %s/%s\n", dirname, filename);
    if ((errcode = ato_akm_loadks(ctx, &buf, dirname, filename)) != ATO_ERR_OK)
        goto finally;

    if ((errcode = ato_ks_create(ctx, ks, buf, NULL)) != ATO_ERR_OK)
        goto finally;

    errcode = ATO_ERR_OK;
finally:
    if (buf) free(buf);
    return errcode;
}

int saveks(ato_Ctx *ctx, ato_Keystore *ks, const char *dirname, const char *filename)
{
    int errcode = ATO_ERR_OK;
    char *buf = NULL;

    assert(ks != NULL);

    //save to memory
    if ((errcode = ato_ks_save(ctx, ks, &buf)) != ATO_ERR_OK)
        goto finally;

    // save to file
    if ((errcode = ato_akm_saveks(ctx, buf, dirname, filename)) != ATO_ERR_OK)
        goto finally;

    errcode = ATO_ERR_OK;
finally:
    if (buf) free(buf);
    return errcode;
}


/*********************************************************************************/
