#ifndef __ATO_CRYPTO_PRIVATE_H__
#define __ATO_CRYPTO_PRIVATE_H__

typedef struct _ato_Crypto ato_Crypto;

#ifdef __cplusplus
extern "C" {
#endif

// This will take an internal copy of the arguments
ATO_EXPORT void ato_crypto_create(ato_Ctx *ctx, ato_Crypto **obj, const char *b64p7c, const char *b64p8, const char *b64salt);
// This will take a reference - do not free arguments
ATO_EXPORT void ato_crypto_create_ref(ato_Ctx *ctx, ato_Crypto **obj, char *b64p7c, char *b64p8, char *b64salt);
// This will take a reference - do not free arguments
ATO_EXPORT void ato_crypto_createstr_ref(ato_Ctx *ctx, ato_Crypto **obj, ato_String *b64p7c, ato_String *b64p8, ato_String *b64salt);

ATO_EXPORT void *ato_crypto_free(ato_Crypto *crypto);
ATO_EXPORT ato_Ctx *ato_crypto_ctx(ato_Crypto *crypto);

ATO_EXPORT void ato_crypto_iscorrectpwd(ato_Ctx *ctx, ato_Crypto *crypto, bool *correct, ato_PwdKdf *pk);
ATO_EXPORT bool ato_crypto_changepwd(ato_Ctx *ctx, ato_Crypto *crypto, ato_PwdKdf *pk, ato_PwdKdf *newpk);
ATO_EXPORT void ato_crypto_certificate(ato_Ctx *ctx, ato_Crypto *crypto, ato_String **certificate);
ATO_EXPORT void ato_crypto_chain(ato_Ctx *ctx, ato_Crypto *crypto,  ato_String **certificates);
ATO_EXPORT bool ato_crypto_privatekey(ato_Ctx *ctx, ato_Crypto *crypto, ato_String **privatekey, ato_PwdKdf *pk);
ATO_EXPORT bool ato_crypto_p12(ato_Ctx *ctx, ato_Crypto *crypto, ato_String **p12, ato_PwdKdf *pk);
ATO_EXPORT ato_String *ato_crypto_b64salt(ato_Crypto *crypto);
ATO_EXPORT ato_String *ato_crypto_b64p7(ato_Crypto *crypto);
ATO_EXPORT ato_String *ato_crypto_b64p8(ato_Crypto *crypto);

ATO_EXPORT bool ato_crypto_generateP10new(ato_Ctx *ctx, int keylen, const char *type, const char *abn, const char *name1, const char *name2, const char *pid, ato_PwdKdf *pk, ato_String *b64salt, ato_String **p10, ato_String **p8);
ATO_EXPORT ato_String *ato_crypto_sign(ato_Ctx *ctx, ato_Crypto *crypto, ato_PwdKdf *pk, const char *data, size_t len);

ATO_EXPORT bool ato_crypto_generateP10(ato_Ctx *ctx, int keylen, ato_Crypto *crypto, ato_PwdKdf *kdf, ato_String *b64salt, ato_String **p10, ato_String **p8);
ATO_EXPORT ato_String *ato_crypto_serialnr(ato_Ctx *ctx, ato_Crypto *crypto, ato_String **serialNr);
ATO_EXPORT ato_String *ato_crypto_notbefore(ato_Ctx *ctx, ato_Crypto *crypto, ato_String **notBefore);
ATO_EXPORT ato_String *ato_crypto_notafter(ato_Ctx *ctx, ato_Crypto *crypto, ato_String **notAfter);
ATO_EXPORT char *ato_crypto_kdf(ato_Ctx *ctx, char **dpwd, const char *pwd, const ato_String *bsalt, size_t iterations, size_t octets, int prfid);

ATO_EXPORT bool ato_crypto_ispbe2(ato_Crypto *crypto);
ATO_EXPORT char *ato_crypto_rootcert_name(ato_Ctx *ctx, ato_Crypto *crypto, char *buf, size_t len);
ATO_EXPORT char *ato_crypto_usercert_name(ato_Ctx *ctx, ato_Crypto *crypto, char *buf, size_t len);
ATO_EXPORT char *ato_crypto_usercert_abn(ato_Ctx *ctx, ato_Crypto *crypto, char *buf, size_t len);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_CRYPTO_PRIVATE_H__*/
