#ifndef __ATO_ERRDEF_PRIVATE_H__
#define __ATO_ERRDEF_PRIVATE_H__

/* ! @defgroup atobase_api_perrdef PError Definition
@ingroup atobase_api_private

@{
*/

//#include "atobase/errdef.h"

#ifdef __cplusplus
extern "C" {
#endif

/** @internal
*/
ATO_EXPORT void ato_errdef_add(int errcode, const char *library, const char *name, const char *msg);

/** @internal
The string representation of the errcode
@param errcode the errorcode int
@return errcode name
*/
ATO_EXPORT const char *ato_errdef_name(int errcode);

/** @internal
The default error msg (may be blank)
@param errcode the errorcode int
@return error message
*/
ATO_EXPORT const char *ato_errdef_msg(int errcode);

/** @internal
The library the errcode belongs to
@param errcode the errorcode int
@return library name
*/
ATO_EXPORT const char *ato_errdef_library(int errcode);

#ifdef __cplusplus
}
#endif


/* ! @} */

#endif /*__ATO_ERRDEF_PRIVATE_H__*/
