#ifndef __ATO_ERRSOAP_PRIVATE_H__
#define __ATO_ERRSOAP_PRIVATE_H__

#include "atobase/errsoap.h"


#ifdef __cplusplus
extern "C" {
#endif

extern void ato_errsoap_create(ato_Ctx *ctx, ato_ErrSoap **err,
                            const char *code,
                            const char *type,
                            const char *severity,
                            const char *shortdesc,
                            const char *longdesc
                            );
extern void ato_errsoap_createassign(ato_Ctx *ctx, ato_ErrSoap **err,
                            char *detail,
                            char *node,
                            char *reason,
                            size_t codecount
                            );
extern void ato_errsoap_free(ato_ErrSoap *err);

extern void ato_errsoap_code_addassign(ato_Ctx *ctx, ato_ErrSoap *err, char *value, char *ns, size_t index);

extern const char *ato_errsoap_iid(ato_ErrSoap *err);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_ERRSOAP_PRIVATE_H__*/
