#ifndef __ATO_ITER_PRIVATE_H__
#define __ATO_ITER_PRIVATE_H__

/* ! @defgroup atobase_api_piter PIter
@ingroup atobase_api_private

@{
*/

#include "atobase/iter.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
Create an iterator for the given non-NULL collection - caller must free it.

This, and related methods, are generic methods, useful for collections shared between
threads where each thread may have its own iterator. Because these methods use void pointers, they
do not have type safety.

@param list the collection.

@return a new iterator or NULL if the collection is NULL.
*/
ATO_EXPORT ato_Iterator *ato_iter_create_lst(ato_List *list);

ATO_EXPORT ato_Iterator *ato_iter_create_arr(void **arr, size_t count);

#ifdef __cplusplus
}
#endif

/* ! @} */

#endif /*__ATO_ITER_PRIVATE_H__*/

