#ifndef __ATO_LST_PRIVATE_H__
#define __ATO_LST_PRIVATE_H__

#include <stddef.h>

typedef struct _ato_ListNode ato_ListNode;
typedef struct _ato_List ato_List;

#ifdef __cplusplus
extern "C" {
#endif

ATO_EXPORT void ato_lst_create(ato_List **lst);
ATO_EXPORT void *ato_lst_free(ato_List *lst);
ATO_EXPORT void ato_lst_clear(ato_List *lst);
ATO_EXPORT size_t ato_lst_count(ato_List *lst);
ATO_EXPORT ato_ListNode *ato_lst_add(ato_List *lst, const char *key, void *value);
ATO_EXPORT ato_ListNode *ato_lst_addconst(ato_List *lst, const char *key, const void *value);
ATO_EXPORT ato_ListNode *ato_lst_next(ato_List *lst, ato_ListNode *node);
ATO_EXPORT void *ato_lst_value(ato_ListNode *node);
ATO_EXPORT const void *ato_lst_valueconst(ato_ListNode *node);
// return value as a const or if NULL return const
ATO_EXPORT const void *ato_lst_valueorconst(ato_ListNode *node);
ATO_EXPORT const char *ato_lst_key(ato_ListNode *node);
ATO_EXPORT ato_ListNode *ato_lst_find(ato_List *lst, const char *key);
ATO_EXPORT void ato_lst_delete(ato_ListNode *node);
ATO_EXPORT void ato_lst_setvalue(ato_ListNode *node, void *value);
ATO_EXPORT void ato_lst_setvalueconst(ato_ListNode *node, const void *value);
//ATO_EXPORT void *ato_lst_findvalue(ato_ListNode *node);
ATO_EXPORT const void *ato_lst_findvalueconst(ato_List *lst, const char *key);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_LST_PRIVATE_H__*/

