#ifndef __ATO_TYPES_PRIVATE_H__
#define __ATO_TYPES_PRIVATE_H__

#include "atobase/types.h"

#define ATO_RETHROW_ONERR(errcode) { if ((errcode) != ATO_ERR_OK) Throw (errcode); }

typedef void (ato_setloglevelfn)(ato_eLoglevel level);
typedef void (ato_setlogfiledumpfn)(bool filedump);

typedef struct _ato_LibModule ato_LibModule;


#ifdef __cplusplus
extern "C" {
#endif

ATO_EXPORT ato_LibModule *ato_initfnloglevel(const char *library, const char *module, unsigned long moduleid, ato_eLoglevel level, ato_setloglevelfn setloglevelfn);
ATO_EXPORT void ato_initfnlogfiledump(ato_LibModule *moddefn, bool filedump, ato_setlogfiledumpfn setlogfiledumpfn);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_TYPES_PRIVATE_H__*/
