#ifndef __ATO_ERR_INTERNAL_H__
#define __ATO_ERR_INTERNAL_H__

#ifndef ATO_INTERNAL
#error "This file is for internal use only"
#endif

#include "atobase/private/perr.h"

#ifdef __cplusplus
extern "C" {
#endif

extern int ato__err_init(void);
extern void ato__err_deinit(void);

extern void ato__err_create(ato_Err **err, const char *library, const char *module, const char *function, int line, int code, ato_eErrSeverity severity, const char *msg, void *customobj, ato_Err *inner);
extern void ato__err_free(ato_Err *err);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_ERR_INTERNAL_H__*/
