/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup atobase_overview_context

The @ref ato_Ctx (context) object is a ubiquitous central object of the SDK(s).

When calling a method, there is "operating" data that needs to be passed to each method call, apart from the normal
business data the method needs to perform its operations. This data includes logging; configuration; and error
handling details; and also needs to support threading.

In order to simplify such calls, all such supporting data is encapsulated in a "Context" object.
The core functionality provided by this is thread specific error handling. For this reason, at least one context
object is created prior to any other call (except for ato_si_set()).
The initialisation routines may generate error objects attached to the context object.

The objects encapsulated by the Context object are:
- ato_ctx_cache() - context properties affecting behaviour of some objects
- ato_Log (ato_ctx_log()) - the log settings to use (derived from the Configuration)
- ato_Err (ato_ctx_err())- the errors, including nested errors, that an API method can generated

Each thread must create its own context object, although the underlying Configuration can be shared, provided
the configuration is not updated or updated in a threadsafe manner by the application.

Third party dependant libraries may have their own threading requirements that are the
responsibility of the application to implement.

*/
