/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup atobase_overview_designnotes

The SDK itself is mostly memory-based. That is, loading data into and saving data from, the SDK is via
memory buffers. Configuration of behaviour is either done with API parameters or using @ref atobase_api_public_arg or per context e.g. ato_ctx_cache().

Internally the library uses setjmp/longjmp, however these are always mapped to integer error return codes at the API boundary.

@section atobase_designnotes_content Content

Previously, packages were supplied. These have been dropped for now. Instead pre-build binaries are directly included.
These also include doxygen generate API files.

Source is built using cmake. This can be run using the build.sh shell script. Native windows builds are not supported - use MSYS2 instead.

A seperate test application is available to test the library.

A project naming convention has been used: where the library is called "myproj" the sample is postfixed with "x" i.e. "myprojx".

@section atobase_designnotes_usage Usage

Using the SDK follows the pattern:

- Set the global application information (ato_si_set())
- Create an initial global context object (ato_ctx_create())
- Initialise the system (ato_base_init())
    - Setup any logging (ato_ctx_log_set(), etc) and any known configuration items using @ref atobase_api_public_arg or per context e.g. ato_ctx_cache().
    - Create one or more SDK objects
        - Perform SDK operations
    - Free any SDK objects created
- Free the global context object
- Deinitialise the system at application shutdown

Note: initialisation / deinitialises must be performed before / after any threading.

@section atobase_designnotes_memory Memory allocation

It is often unclear in C as to who is responsible for freeing an object.
Where appropriate, methods allocating memory and handing responsibility for freeing memory to the caller,
include "create" in the method name. This is not always appropriate.
In order to be more explicit, all such "generated" objects (at least for non-static methods)
are passed as non-const parameter addresses rather than a return value. i.e.

- errcode = ato_obj_create(ctx, &obj);
rather than
- obj = ato_obj_create(ctx).

As a precaution, all methods that allocate objects first check that the pointer is currently NULL. If it
is not, it is assumed it is currently allocated and will ASSERT. While this does force client code into the
discipline of 'always initialise variables', it has been adopted as a minimal safety mechanism because it
was felt it was:

- good practice;
- not particularly onerous; and
- very helpful in catching some unfreed memory


@section atobase_designnotes_lifecycle Object lifecycle

All relevant objects are created using ato_xx_create methods which return an error code.
The address of the object to be created is passed as the second argument
(the first argument being the ctx or Context argument discussed later).

Out of memory errors are considered catastophic and will halt the application with an assertion error.
This means that if the ato_xx_create method returns, the object will always be allocated, regardless
of any error that may have occurred.

All ato_xx_free methods can be called on NULL objects. This does nothing and is a convenience.

@section atobase_designnotes_threading Threading

The API is thread-safe and Collections and objects are thread-safe for read-only operations,
except in specific documented cases. It is up to the application to apply appropriate thread
protection mechanisms if an object is being updated while shared between threads.

If in doubt, or if there are issues, create a new instance of any collection and objects for each thread.

*/
