/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup atobase_overview_init

@section atobase_init_setup Setup

Prior to calling any other SDK function initialise the SDK. This must be done prior to any threads starting as it initialises global memory including error handling
and logging. For convenience, initialisation also calls the init routines of underlying third-party libraries that
are used.

In order
- ato_si_set(): setting up the global application information
- ato_ctx_create(): creating the required initial main thread context object prior to any furthur initialisation
- ato_base_init()

The application should first call ato_si_set() to describe itself to the SDK(s).
For example:

@code
ato_si_set("Your Organisation Name Here", "ATO BASE Reference Client (C version)", "0.6", buildtime, hash);
@endcode

@section atobase_init_init Initialise

The following initialises the base SDK. Note the "flag" parameter controls the underlying initialisation,
although only ATO_BASE_INIT_ALL is currently supported.

@code
    int errcode = ATO_ERR_OK;
    ato_Ctx *ctx = NULL;

    // We need at least one context for the main thread prior to initialisation
    ato_ctx_create(&ctx);

    errcode = ato_base_init(ctx, ATO_BASE_INIT_ALL);

@endcode

@section atobase_init_config Configuration

Some configuration may be done.

@code
    ato_Log *log = ato_ctx_log_set(ctx, "", "2", NULL, "w");
@endcode

@section atobase_init_deinit Deinitialise

At the end of the program lifetime, and after all threads are finished, corresponding ctx free and
deinitialization methods must be called.

@code
    ato_ctx_free(ctx);
    ato_base_deinit();
@endcode

@section atobase_init_note Note

ato_base_init() is an initialization routine that sets up global values common to multiple independent SDKs, and,
as such it cannot easily be embedded within the init methods of the other SDKs. It should always be called
separately and prior to any other SDK init method.

*/
