/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup atobase_overview_logging

@section atobase_logging_overview Overview

The SDK logs appropriate information to support the software if issues arise.
As the SDK may be located on non-secure hardware and may be submitted to a help desk for analysis,
the log files should contain no sensitive information, such as passwords.

The initialization process will initialise all library modules to a default log level of <i>warning</i>.
If overriding log levels, do this after the initialization methods have been called.

@section atobase_logging_level Controlling logging output

The SDK code makes various logging calls that can be controlled, separately, by the logging level of
individual SDKs (libraries) and their modules. The level of each
library/module can be set using:

@code
void ato_setloglevel(const char *library, unsigned short moduleidmask, ato_eLoglevel level);

e.g.
// Set all registered libraries and modules
ato_setloglevel(NULL, 0, ATO_LOG_WARN);
// Turn off logging in crypto library
ato_setloglevel(ATO_BASE_LIBRARY, ATO_BASE_MODULEID_CRYPTO, ATO_LOG_OFF);

@endcode

@section atobase_logging_function Log function

The default logging function is controlled by some settings in the configuration file. However the entire
logging function can be replaced by setting a callback using:

@code
void ato_log_setlogfn(ato_logfunction logfunction);

where ato_logfunction is:
typedef bool (ato_logfunction)(ato_Log *log, ato_eLoglevel loglevel, ato_eLogState logstate, const char *library, const char *module, const char *function, const char *format, va_list args);
@endcode

For example:
@code
bool customlogger(ato_Log *log, ato_eLoglevel loglevel, ato_eLogState logstate, const char *library, const char *module, const char *function, const char *format, va_list args);
ato_log_setlogfn(customlogger);
@endcode

@section atobase_logging_levels Log Levels

The log levels are defined in @ref ato_eLoglevel.

This is a general rational for the logging levels.

@htmlonly
<table border>
    <tr><td><b>Logging Level</b></td><td><b>Intended Audience</b></td><td><b>Best Practice</b></td></tr>
    <tr><td>Off</td><td>Developer</td><td>Useful for targetting logging for individual submodules</td></tr>
    <tr><td>Fatal, Error, Warning</td><td>End-User</td><td>Events logged at this level are for messages reported back to an end-user when something has gone wrong. These correspond to the severity codes in @ref atobase_error "error handling"</td></tr>
    <tr><td>Information</td><td>Testing, Tech Support</td><td>Use events logged at this level to debug issues during testing, and to provide technical support to external clients. Log all operations supporting business functionality, including progress and status type information as Information messages</td></tr>
    <tr><td>Debug, Trace</td><td>Developer</td><td>This is for development use. Log full parameter lists, extra information and, in the case of Trace, method entry/exit</td></tr>
    <tr><td>All</td><td>Developer</td><td>Useful for targetting logging for individual submodules</td></tr>
</table>
@endhtmlonly

*/
